/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.util;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ruoyi.dto.supply.InventoryManagementListDTO;
import com.ruoyi.dto.supply.MaterialsApplicationDemandDetailDTO;
import com.ruoyi.dto.supply.OutWarehouseManagementDTO;
import com.ruoyi.dto.supply.PurchaseOrderDTO;
import com.ruoyi.dto.supply.PurchaseOrderDemandDetailDTO;
import com.ruoyi.entity.supply.EquipmentProfitLossMaterialListDO;
import com.ruoyi.entity.supply.InWarehouseManagementDetailDO;
import com.ruoyi.entity.supply.ItemCategoryDO;
import com.ruoyi.entity.supply.MaterialArchivesDO;
import com.ruoyi.entity.supply.MaterialCodeDo;
import com.ruoyi.entity.supply.MaterialsApplicationDemandDetailDO;
import com.ruoyi.entity.supply.MaterialsApplicationHandleDetailDO;
import com.ruoyi.entity.supply.MaterialsApplicationMaterialOrderDO;
import com.ruoyi.entity.supply.OutWarehouseManagementDO;
import com.ruoyi.entity.supply.OutWarehouseManagementDemandDetailDO;
import com.ruoyi.entity.supply.OutWarehouseManagementLogisticsInformationDO;
import com.ruoyi.entity.supply.PurchaseOrderDO;
import com.ruoyi.entity.supply.PurchaseOrderDemandDetailDO;
import com.ruoyi.entity.supply.PurchaseOrderLogisticsInformationDO;
import com.ruoyi.entity.supply.StockListDO;
import com.ruoyi.service.supply.EquipmentProfitLossMaterialListService;
import com.ruoyi.service.supply.ItemCategoryService;
import com.ruoyi.service.supply.KuaiDi100Service;
import com.ruoyi.service.supply.MaterialArchivesService;
import com.ruoyi.service.supply.MaterialCodeService;
import com.ruoyi.service.supply.MaterialsApplicationDemandDetailService;
import com.ruoyi.service.supply.MaterialsApplicationHandleDetailService;
import com.ruoyi.service.supply.MaterialsApplicationMaterialOrderService;
import com.ruoyi.service.supply.OutWarehouseManagementDemandDetailService;
import com.ruoyi.service.supply.OutWarehouseManagementLogisticsInformationService;
import com.ruoyi.service.supply.OutWarehouseManagementService;
import com.ruoyi.service.supply.PurchaseOrderDemandDetailService;
import com.ruoyi.service.supply.PurchaseOrderLogisticsInformationService;
import com.ruoyi.service.supply.PurchaseOrderService;
import com.ruoyi.service.supply.StockListService;
import com.ruoyi.service.workFlow.ProcessDTO;
import com.ruoyi.service.workFlow.ProcessEnum;
import com.ruoyi.service.workFlow.WorkFlowService;
import com.ruoyi.util.MapUtyils;
import com.ruoyi.util.ThemeUtils;
import com.ruoyi.vo.supply.DistrictsVO;
import com.ruoyi.vo.supply.InWarehouseManagementDetailVO;
import com.ruoyi.vo.supply.InventoryManagementDetailVO;
import com.ruoyi.vo.supply.ItemCategoryVO;
import com.ruoyi.vo.supply.LogisticsTrackingVO;
import com.ruoyi.vo.supply.MaterialApplicationOrderUnderListVO;
import com.ruoyi.vo.supply.MaterialArchivesVO;
import com.ruoyi.vo.supply.MaterialNameListVO;
import com.ruoyi.vo.supply.OutWarehouseManagementDemandDetailVO;
import com.ruoyi.vo.supply.PaymentDetailsVO;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SupplyUtils {
    private static final Logger log = LoggerFactory.getLogger(SupplyUtils.class);
    @Resource
    private StockListService stockListService;
    @Resource
    private ItemCategoryService itemCategoryService;
    @Resource
    private PurchaseOrderService purchaseOrderService;
    @Resource
    private MaterialsApplicationMaterialOrderService materialsApplicationMaterialOrderService;
    @Resource
    private PurchaseOrderDemandDetailService purchaseOrderDemandDetailService;
    @Resource
    private MaterialsApplicationDemandDetailService materialsApplicationDemandDetailService;
    @Resource
    private OutWarehouseManagementService outWarehouseManagementService;
    @Resource
    private OutWarehouseManagementDemandDetailService outWarehouseManagementDemandDetailService;
    @Resource
    private MaterialArchivesService materialArchivesService;
    @Resource
    private PurchaseOrderLogisticsInformationService purchaseOrderLogisticsInformationService;
    @Resource
    private MaterialsApplicationHandleDetailService materialsApplicationHandleDetailService;
    @Resource
    private OutWarehouseManagementLogisticsInformationService outWarehouseManagementLogisticsInformationService;
    @Resource
    private KuaiDi100Service kuaiDi100Service;
    @Resource
    private EquipmentProfitLossMaterialListService equipmentProfitLossMaterialListService;
    @Resource
    private WorkFlowService workFlowService;
    @Resource
    private MaterialCodeService materialCodeService;

    public List<PurchaseOrderDO> getLinkProjectPurchaseOrder(String projectCode) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)projectCode)) {
            wrapper.eq(ObjectUtil.isNotEmpty((Object)projectCode), PurchaseOrderDO::getProjectCode, (Object)projectCode);
            wrapper.eq(PurchaseOrderDO::getPurchaseStatus, (Object)3);
            wrapper.orderByDesc(PurchaseOrderDO::getCreateTime);
            wrapper.eq(PurchaseOrderDO::getStatus, (Object)0);
        } else {
            wrapper.eq(PurchaseOrderDO::getPurchaseStatus, (Object)3);
            wrapper.eq(PurchaseOrderDO::getStatus, (Object)0);
            wrapper.eq(PurchaseOrderDO::getPurchaseType, (Object)3);
            wrapper.orderByDesc(PurchaseOrderDO::getCreateTime);
        }
        List list = this.purchaseOrderService.list((Wrapper)wrapper);
        return list;
    }

    public List<MaterialApplicationOrderUnderListVO> getMaterialApplicationOrder() {
        List materialsApplicationMaterialOrderDOList = this.materialsApplicationMaterialOrderService.list((Wrapper)new LambdaQueryWrapper());
        List<MaterialApplicationOrderUnderListVO> materialApplicationOrderUnderListVOS = materialsApplicationMaterialOrderDOList.stream().map(m -> {
            MaterialApplicationOrderUnderListVO materialApplicationOrderUnderListVO = new MaterialApplicationOrderUnderListVO();
            BeanUtils.copyProperties((Object)m, (Object)materialApplicationOrderUnderListVO);
            return materialApplicationOrderUnderListVO;
        }).collect(Collectors.toList());
        return materialApplicationOrderUnderListVOS;
    }

    public List<InWarehouseManagementDetailVO> getInWarehouseDetail(Long id) {
        List<Object> inWarehouseManagementDetailVOList = new ArrayList<InWarehouseManagementDetailVO>();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)id), PurchaseOrderDemandDetailDO::getMainId, (Object)id);
        List purchaseOrderDemandDetailDOList = this.purchaseOrderDemandDetailService.list((Wrapper)wrapper);
        if (ObjectUtil.isNotEmpty((Object)purchaseOrderDemandDetailDOList)) {
            inWarehouseManagementDetailVOList = purchaseOrderDemandDetailDOList.stream().map(m -> {
                InWarehouseManagementDetailVO inWarehouseManagementDetailVO = new InWarehouseManagementDetailVO();
                MaterialArchivesDO byId = (MaterialArchivesDO)this.materialArchivesService.getById((Serializable)m.getMaterialId());
                byId.setPrice(m.getPrice());
                this.materialArchivesService.updateById((Object)byId);
                BeanUtils.copyProperties((Object)m, (Object)inWarehouseManagementDetailVO);
                inWarehouseManagementDetailVO.setMaterialName(byId.getMaterialName());
                inWarehouseManagementDetailVO.setMaterialSpecifications(byId.getMaterialSpecification());
                inWarehouseManagementDetailVO.setPurchaseCount(m.getPurchaseCount());
                inWarehouseManagementDetailVO.setPrice(m.getPrice());
                inWarehouseManagementDetailVO.setMaterialId(m.getMaterialId());
                inWarehouseManagementDetailVO.setOneYardPerObject(byId.getOneYardPerObject());
                if (ObjectUtil.isNotEmpty((Object)m.getPurchaseCount()) && ObjectUtil.isNotEmpty((Object)m.getPrice())) {
                    inWarehouseManagementDetailVO.setTotalPrice(m.getPrice().multiply(new BigDecimal(m.getPurchaseCount())));
                }
                return inWarehouseManagementDetailVO;
            }).collect(Collectors.toList());
        }
        return inWarehouseManagementDetailVOList;
    }

    public void inStocks(List<InWarehouseManagementDetailDO> inWarehouseManagementDetailDTOList, String projectCode, PurchaseOrderDO purchaseOrderDO) {
        for (InWarehouseManagementDetailDO inWarehouseManagementDetailDO : inWarehouseManagementDetailDTOList) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)inWarehouseManagementDetailDO.getMaterialId()), StockListDO::getMaterialId, (Object)inWarehouseManagementDetailDO.getMaterialId());
            StockListDO stockListDO = (StockListDO)this.stockListService.getOne((Wrapper)wrapper);
            if (ObjectUtil.isNotEmpty((Object)stockListDO)) {
                stockListDO.setCurrentStock(Long.valueOf(stockListDO.getCurrentStock() + inWarehouseManagementDetailDO.getActualWarehouseingQuantity()));
                stockListDO.setProjectCode(projectCode);
                this.stockListService.updateById((Object)stockListDO);
                if (!StringUtils.isNotEmpty((CharSequence)inWarehouseManagementDetailDO.getUniqueCodeCollection())) continue;
                List<String> materialCode = Arrays.asList(inWarehouseManagementDetailDO.getUniqueCodeCollection().split(","));
                ArrayList materialCodeDoList = new ArrayList();
                materialCode.forEach(a -> {
                    MaterialCodeDo materialCodeDo = new MaterialCodeDo();
                    materialCodeDo.setMaterialCode(a);
                    materialCodeDo.setMaterialId(stockListDO.getMaterialId());
                    materialCodeDo.setCreateTime(new Date());
                    materialCodeDo.setRkId(String.valueOf(inWarehouseManagementDetailDO.getId()));
                    materialCodeDo.setProjectId(projectCode);
                    materialCodeDo.setCgId(String.valueOf(purchaseOrderDO.getId()));
                    materialCodeDo.setWzId(String.valueOf(purchaseOrderDO.getAssociatedMaterialApplicationOrderId()));
                    materialCodeDoList.add(materialCodeDo);
                });
                this.materialCodeService.saveBatch(materialCodeDoList);
                continue;
            }
            MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesService.getById((Serializable)inWarehouseManagementDetailDO.getMaterialId());
            StockListDO stockList = new StockListDO();
            BeanUtils.copyProperties((Object)inWarehouseManagementDetailDO, (Object)stockList);
            if (!ObjectUtil.isNotEmpty((Object)materialArchivesDO)) continue;
            stockList.setCurrentStock(inWarehouseManagementDetailDO.getActualWarehouseingQuantity());
            stockList.setMaterialCategory(materialArchivesDO.getMaterialCategory());
            stockList.setMaterialCategoryId(materialArchivesDO.getMaterialCategoryId());
            stockList.setMaterialNumber(materialArchivesDO.getMaterialNumber());
            stockList.setReferencePrice(materialArchivesDO.getReferencePrice());
            stockList.setMaterialId(materialArchivesDO.getId());
            stockList.setMaterialSpecification(materialArchivesDO.getMaterialSpecification());
            stockList.setMaterialNumber(materialArchivesDO.getMaterialNumber());
            stockList.setUnitMeasurement(materialArchivesDO.getUnitMeasurement());
            stockList.setReferencePrice(materialArchivesDO.getReferencePrice());
            stockList.setAssociatedSupplier(materialArchivesDO.getAssociatedSupplier());
            stockList.setUpdateTime(new Date());
            stockList.setCreateTime(new Date());
            stockList.setIsDeleted(Integer.valueOf(0));
            stockList.setProjectCode(projectCode);
            boolean save = this.stockListService.save((Object)stockList);
            if (!save || !StringUtils.isNotEmpty((CharSequence)inWarehouseManagementDetailDO.getUniqueCodeCollection())) continue;
            List<String> materialCode = Arrays.asList(inWarehouseManagementDetailDO.getUniqueCodeCollection().split(","));
            ArrayList materialCodeDoList = new ArrayList();
            materialCode.forEach(a -> {
                MaterialCodeDo materialCodeDo = new MaterialCodeDo();
                materialCodeDo.setMaterialCode(a);
                materialCodeDo.setMaterialId(stockList.getMaterialId());
                materialCodeDo.setCreateTime(new Date());
                materialCodeDo.setRkId(String.valueOf(inWarehouseManagementDetailDO.getId()));
                materialCodeDo.setProjectId(projectCode);
                materialCodeDo.setCgId(String.valueOf(purchaseOrderDO.getId()));
                materialCodeDo.setWzId(String.valueOf(purchaseOrderDO.getAssociatedMaterialApplicationOrderId()));
                materialCodeDoList.add(materialCodeDo);
            });
            this.materialCodeService.saveBatch(materialCodeDoList);
        }
    }

    public List<PurchaseOrderDemandDetailDTO> getProjectMaterialDemandDetail(Long associatedMaterialApplicationOrderId, String outWarehouseNumber) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)outWarehouseNumber), OutWarehouseManagementDO::getOutWarehouseNumber, (Object)outWarehouseNumber);
        OutWarehouseManagementDO outWarehouseManagementDO = (OutWarehouseManagementDO)this.outWarehouseManagementService.getOne((Wrapper)wrapper);
        LambdaQueryWrapper materialsApplicationDemandDetailDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)associatedMaterialApplicationOrderId), MaterialsApplicationDemandDetailDO::getMainId, (Object)associatedMaterialApplicationOrderId);
        List materialsApplicationDemandDetailDOList = this.materialsApplicationDemandDetailService.list((Wrapper)materialsApplicationDemandDetailDOLambdaQueryWrapper);
        Long mainId = outWarehouseManagementDO.getId();
        LambdaQueryWrapper outWarehouseManagementDemandDetailDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)mainId), OutWarehouseManagementDemandDetailDO::getMainId, (Object)mainId);
        List outWarehouseManagementDemandDetailDOList = this.outWarehouseManagementDemandDetailService.list((Wrapper)outWarehouseManagementDemandDetailDOLambdaQueryWrapper);
        ArrayList<PurchaseOrderDemandDetailDTO> purchaseOrderDemandDetailDTOList = new ArrayList<PurchaseOrderDemandDetailDTO>();
        if (ObjectUtil.isNotEmpty((Object)materialsApplicationDemandDetailDOList) && ObjectUtil.isNotEmpty((Object)outWarehouseManagementDemandDetailDOList)) {
            for (MaterialsApplicationDemandDetailDO materialsApplicationDemandDetailDO : materialsApplicationDemandDetailDOList) {
                for (OutWarehouseManagementDemandDetailDO outWarehouseManagementDemandDetailDO : outWarehouseManagementDemandDetailDOList) {
                    if (!materialsApplicationDemandDetailDO.getMaterialName().equals(outWarehouseManagementDemandDetailDO.getMaterialName())) continue;
                    PurchaseOrderDemandDetailDTO purchaseOrderDemandDetailDTO = new PurchaseOrderDemandDetailDTO();
                    LambdaQueryWrapper stockListDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(StockListDO::getMaterialName, (Object)materialsApplicationDemandDetailDO.getMaterialName());
                    StockListDO stockListDO = (StockListDO)this.stockListService.getOne((Wrapper)stockListDOLambdaQueryWrapper);
                    purchaseOrderDemandDetailDTO.setMaterialName(stockListDO.getMaterialName());
                    purchaseOrderDemandDetailDTO.setSupplier(stockListDO.getAssociatedSupplier());
                    purchaseOrderDemandDetailDTO.setUnit(stockListDO.getUnitMeasurement());
                    purchaseOrderDemandDetailDTO.setDemandCount(Long.valueOf(materialsApplicationDemandDetailDO.getDemandCount() - outWarehouseManagementDemandDetailDO.getDeliveryFromStorageCount()));
                    purchaseOrderDemandDetailDTOList.add(purchaseOrderDemandDetailDTO);
                }
            }
        }
        return purchaseOrderDemandDetailDTOList;
    }

    public List<MaterialNameListVO> getThreeLevelMaterialNameList() {
        ArrayList<MaterialNameListVO> materialNameListVOList = new ArrayList<MaterialNameListVO>();
        List searchMenuList = this.itemCategoryService.getSearchMenu();
        if (ObjectUtil.isEmpty((Object)searchMenuList)) {
            return materialNameListVOList;
        }
        List materialArchivesDOList = this.materialArchivesService.list();
        List stockList = this.stockListService.list();
        for (ItemCategoryVO itemCategoryVO : searchMenuList) {
            MaterialNameListVO materialNameListVO = new MaterialNameListVO();
            materialNameListVO = this.getMaterialNameList(materialNameListVO, itemCategoryVO, materialArchivesDOList, stockList);
            materialNameListVOList.add(materialNameListVO);
        }
        return materialNameListVOList;
    }

    public List<ItemCategoryVO> getThreeLevelMaterialList() {
        List searchMenuList = this.itemCategoryService.getSearchMenu();
        return searchMenuList;
    }

    private MaterialNameListVO getMaterialNameList(MaterialNameListVO materialNameListVO, ItemCategoryVO itemCategoryVO, List<MaterialArchivesDO> materialArchivesDOLists, List<StockListDO> stockList) {
        if (ObjectUtil.isNotEmpty((Object)itemCategoryVO.getMenuName())) {
            materialNameListVO.setMaterialName(itemCategoryVO.getMenuName());
            materialNameListVO.setMaterialId(itemCategoryVO.getId());
        }
        if (ObjectUtil.isNotEmpty((Object)itemCategoryVO.getAuthMenuList())) {
            ArrayList<MaterialNameListVO> materialNameListVOList = new ArrayList<MaterialNameListVO>();
            for (ItemCategoryVO categoryVO : itemCategoryVO.getAuthMenuList()) {
                MaterialNameListVO materialNameList = new MaterialNameListVO();
                this.getMaterialNameList(materialNameList, categoryVO, materialArchivesDOLists, stockList);
                materialNameListVOList.add(materialNameList);
            }
            materialNameListVO.setMaterialNameListVOList(materialNameListVOList);
        }
        if (ObjectUtil.isEmpty((Object)itemCategoryVO.getAuthMenuList())) {
            Long id = itemCategoryVO.getId();
            List materialArchivesDOList = materialArchivesDOLists.stream().filter(f -> id.equals(f.getMaterialCategoryId())).collect(Collectors.toList());
            if (ObjectUtil.isNotEmpty(materialArchivesDOList)) {
                List materialNameListVOList = materialArchivesDOList.stream().map(m -> {
                    MaterialNameListVO materialNameListVO1 = new MaterialNameListVO();
                    materialNameListVO1.setMaterialId(m.getId());
                    materialNameListVO1.setMaterialName(m.getMaterialName());
                    materialNameListVO1.setMaterialSpecification(m.getMaterialSpecification());
                    materialNameListVO1.setUnitMeasurement(m.getUnitMeasurement());
                    StockListDO stockListDO = stockList.stream().filter(f -> m.getId().equals(f.getMaterialId())).findFirst().orElse(null);
                    if (ObjectUtil.isNotEmpty((Object)stockListDO)) {
                        materialNameListVO1.setCurrentCount(stockListDO.getCurrentStock());
                    } else {
                        materialNameListVO1.setCurrentCount(Long.valueOf(0L));
                    }
                    return materialNameListVO1;
                }).collect(Collectors.toList());
                materialNameListVO.setMaterialNameListVOList(materialNameListVOList);
            }
        }
        return materialNameListVO;
    }

    public List<OutWarehouseManagementDemandDetailVO> getOutWarehouseDetail(String outWarehouseNumber) {
        LambdaQueryWrapper outWarehouseManagementDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(OutWarehouseManagementDO::getOutWarehouseNumber, (Object)outWarehouseNumber);
        OutWarehouseManagementDO warehouseManagementDO = (OutWarehouseManagementDO)this.outWarehouseManagementService.getOne((Wrapper)outWarehouseManagementDOLambdaQueryWrapper);
        Long mainId = warehouseManagementDO.getId();
        LambdaQueryWrapper outWarehouseManagementDemandDetailDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(OutWarehouseManagementDemandDetailDO::getMainId, (Object)mainId);
        List outWarehouseManagementDemandDetailDOList = this.outWarehouseManagementDemandDetailService.list((Wrapper)outWarehouseManagementDemandDetailDOLambdaQueryWrapper);
        List<OutWarehouseManagementDemandDetailVO> outWarehouseManagementDemandDetailVOList = outWarehouseManagementDemandDetailDOList.stream().map(m -> {
            OutWarehouseManagementDemandDetailVO outWarehouseManagementDemandDetailVO = new OutWarehouseManagementDemandDetailVO();
            BeanUtils.copyProperties((Object)m, (Object)outWarehouseManagementDemandDetailVO);
            return outWarehouseManagementDemandDetailVO;
        }).collect(Collectors.toList());
        return outWarehouseManagementDemandDetailVOList;
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void autoGeneratePurchaseOrder(OutWarehouseManagementDTO outWarehouseManagementDTO) throws Exception {
        PurchaseOrderDO purchaseOrderDO = new PurchaseOrderDO();
        purchaseOrderDO.setPurchaser(outWarehouseManagementDTO.getSuppliesApplicants());
        purchaseOrderDO.setDepartment(outWarehouseManagementDTO.getDepartment());
        purchaseOrderDO.setPurchaseDate(new Date());
        purchaseOrderDO.setPurchaseType(Integer.valueOf(3));
        purchaseOrderDO.setProjectName(outWarehouseManagementDTO.getAssociatedProjects());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialsApplicationMaterialOrderDO::getId, (Object)outWarehouseManagementDTO.getRelatedMaterialApplicationFormId());
        MaterialsApplicationMaterialOrderDO materialsApplicationMaterialOrderDO = (MaterialsApplicationMaterialOrderDO)this.materialsApplicationMaterialOrderService.getOne((Wrapper)wrapper);
        purchaseOrderDO.setAssociatedMaterialApplicationOrderId(outWarehouseManagementDTO.getRelatedMaterialApplicationFormId());
        purchaseOrderDO.setMaterialNumber(materialsApplicationMaterialOrderDO.getItemRequisitionNumber());
        purchaseOrderDO.setPurchaseStatus(Integer.valueOf(1));
        purchaseOrderDO.setProjectName(materialsApplicationMaterialOrderDO.getProjectName());
        purchaseOrderDO.setProjectCode(materialsApplicationMaterialOrderDO.getProjectCode());
        purchaseOrderDO.setCity(outWarehouseManagementDTO.getCity());
        purchaseOrderDO.setBrand(outWarehouseManagementDTO.getBrand());
        purchaseOrderDO.setRoomsOrShopsCount(outWarehouseManagementDTO.getRoomStoreCount());
        purchaseOrderDO.setDemandDate(outWarehouseManagementDTO.getRequestDate());
        purchaseOrderDO.setMaterialCategories(materialsApplicationMaterialOrderDO.getApplicationMaterialCategory());
        purchaseOrderDO.setMaterialUsage(materialsApplicationMaterialOrderDO.getMaterialUsage());
        purchaseOrderDO.setRecipient(materialsApplicationMaterialOrderDO.getRecipient());
        purchaseOrderDO.setAddress(materialsApplicationMaterialOrderDO.getAddress());
        purchaseOrderDO.setAddressDetail(materialsApplicationMaterialOrderDO.getAddressDetail());
        purchaseOrderDO.setCreateTime(new Date());
        purchaseOrderDO.setUpdateTime(new Date());
        purchaseOrderDO.setIsDeleted(Integer.valueOf(0));
        String purchaseNumber = this.getPurchaseNumber();
        purchaseOrderDO.setPurchaseNumber(purchaseNumber);
        purchaseOrderDO.setSubjectName(ThemeUtils.getThemeName((String)"\u5b9e\u4f53\u7269\u8d44\u91c7\u8d2d"));
        this.savePurchaseOrderLogisticsInformation(purchaseNumber);
        this.savePurchaseDetail(purchaseNumber, outWarehouseManagementDTO);
        ProcessDTO processDTO = new ProcessDTO();
        processDTO.setProcessInstanceName(purchaseOrderDO.getSubjectName());
        processDTO.setProjectName(purchaseOrderDO.getProjectName());
        processDTO.setBusinessKey(purchaseOrderDO.getId().toString());
        String processId = this.workFlowService.startProcess(ProcessEnum.purchasing_requisition, processDTO, new Object[]{purchaseOrderDO.getId().toString()});
        System.out.println(processId);
        purchaseOrderDO.setProcessInstId(processId);
        this.purchaseOrderService.save((Object)purchaseOrderDO);
    }

    private void savePurchaseDetail(String purchaseNumber, OutWarehouseManagementDTO outWarehouseManagementDTO) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)purchaseNumber), PurchaseOrderDO::getPurchaseNumber, (Object)purchaseNumber);
        PurchaseOrderDO purchaseOrderDO = (PurchaseOrderDO)this.purchaseOrderService.getOne((Wrapper)wrapper);
        List outWarehouseManagementDemandDetailDTOList = outWarehouseManagementDTO.getOutWarehouseManagementDemandDetailDTOList();
        List purchaseOrderDemandDetailDOList = outWarehouseManagementDemandDetailDTOList.stream().map(m -> {
            PurchaseOrderDemandDetailDO purchaseOrderDemandDetailDO = new PurchaseOrderDemandDetailDO();
            purchaseOrderDemandDetailDO.setMainId(purchaseOrderDO.getId());
            purchaseOrderDemandDetailDO.setMaterialName(m.getMaterialName());
            purchaseOrderDemandDetailDO.setDemandCount(m.getDemandCount());
            purchaseOrderDemandDetailDO.setUnit(m.getUnit());
            LambdaQueryWrapper materialArchivesDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialArchivesDO::getMaterialName, (Object)m.getMaterialName());
            List materialArchivesDOList = this.materialArchivesService.list((Wrapper)materialArchivesDOLambdaQueryWrapper);
            if (ObjectUtil.isNotEmpty((Object)materialArchivesDOList)) {
                MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)materialArchivesDOList.get(0);
                purchaseOrderDemandDetailDO.setSupplier(materialArchivesDO.getAssociatedSupplier());
            }
            purchaseOrderDemandDetailDO.setRemark(m.getRemark());
            purchaseOrderDemandDetailDO.setCreateTime(new Date());
            purchaseOrderDemandDetailDO.setUpdateTime(new Date());
            purchaseOrderDemandDetailDO.setIsDeleted(Integer.valueOf(0));
            return purchaseOrderDemandDetailDO;
        }).collect(Collectors.toList());
        this.purchaseOrderDemandDetailService.saveBatch(purchaseOrderDemandDetailDOList);
        this.setMaterialsApplicationHandlePurchaseReviewed(outWarehouseManagementDTO);
    }

    private void setMaterialsApplicationHandlePurchaseReviewed(OutWarehouseManagementDTO outWarehouseManagementDTO) {
        MaterialsApplicationMaterialOrderDO materialsApplicationMaterialOrderDO = (MaterialsApplicationMaterialOrderDO)this.materialsApplicationMaterialOrderService.getById((Serializable)outWarehouseManagementDTO.getRelatedMaterialApplicationFormId());
        MaterialsApplicationHandleDetailDO materialsApplicationHandleDetailDO = new MaterialsApplicationHandleDetailDO();
        materialsApplicationHandleDetailDO.setMainId(outWarehouseManagementDTO.getRelatedMaterialApplicationFormId());
        materialsApplicationHandleDetailDO.setHandleTime(new Date());
        materialsApplicationHandleDetailDO.setHandleInformation("\u81ea\u52a8\u751f\u6210\u91c7\u8d2d\u8ba2\u5355\uff0c\u5f53\u524d\u5f85\u5ba1\u6838");
        materialsApplicationHandleDetailDO.setMaterialApplicationNumber(materialsApplicationMaterialOrderDO.getItemRequisitionNumber());
        materialsApplicationHandleDetailDO.setCreateTime(new Date());
        materialsApplicationHandleDetailDO.setUpdateTime(new Date());
        materialsApplicationHandleDetailDO.setIsDeleted(Integer.valueOf(0));
        this.materialsApplicationHandleDetailService.save((Object)materialsApplicationHandleDetailDO);
    }

    private void savePurchaseOrderLogisticsInformation(String purchaseNumber) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(ObjectUtil.isNotEmpty((Object)purchaseNumber), PurchaseOrderDO::getPurchaseNumber, (Object)purchaseNumber);
        PurchaseOrderDO purchaseOrderDO = (PurchaseOrderDO)this.purchaseOrderService.getOne((Wrapper)wrapper);
        PurchaseOrderLogisticsInformationDO purchaseOrderLogisticsInformationDO = new PurchaseOrderLogisticsInformationDO();
        purchaseOrderLogisticsInformationDO.setMainId(purchaseOrderDO.getId());
        purchaseOrderLogisticsInformationDO.setIsDeleted(Integer.valueOf(0));
        purchaseOrderLogisticsInformationDO.setUpdateTime(new Date());
        purchaseOrderLogisticsInformationDO.setUpdateTime(new Date());
        this.purchaseOrderLogisticsInformationService.save((Object)purchaseOrderLogisticsInformationDO);
    }

    public String incrementString(String numberString) {
        int number = Integer.parseInt(numberString.replaceAll("-", ""));
        return String.format("%04d", ++number);
    }

    public String incrementPurchaseString(String numberString) {
        int number = Integer.parseInt(numberString.replaceAll("-", ""));
        return String.format("%03d", ++number);
    }

    public String getPurchaseNumber() {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().like(PurchaseOrderDO::getPurchaseNumber, (Object)"CGDD-")).orderByDesc(PurchaseOrderDO::getCreateTime);
        Date date = new Date();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        List purchaseOrderDOList = this.purchaseOrderService.list((Wrapper)wrapper);
        if (ObjectUtil.isEmpty((Object)this.purchaseOrderService.list((Wrapper)wrapper))) {
            return "CGDD-" + dateFormat.format(date) + "-001";
        }
        String recentPurchaseNumber = ((PurchaseOrderDO)this.purchaseOrderService.list((Wrapper)wrapper).get(0)).getPurchaseNumber();
        String substring = recentPurchaseNumber.substring(recentPurchaseNumber.length() - 3);
        String fourNumber = this.incrementPurchaseString(substring);
        return "CGDD-" + dateFormat.format(date) + "-" + fourNumber;
    }

    public MaterialArchivesVO getMaterialSpecificationAndUnitAndCount(MaterialsApplicationDemandDetailDTO materialsApplicationDemandDetailDTO) {
        if (ObjectUtil.isNotEmpty((Object)materialsApplicationDemandDetailDTO.getMaterialId())) {
            LambdaQueryWrapper wrapper;
            StockListDO stockListDO;
            MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesService.getById((Serializable)materialsApplicationDemandDetailDTO.getMaterialId());
            if (ObjectUtil.isEmpty((Object)materialArchivesDO)) {
                return new MaterialArchivesVO();
            }
            MaterialArchivesVO materialArchivesVO = new MaterialArchivesVO();
            if (ObjectUtil.isNotEmpty((Object)materialArchivesDO.getMaterialSpecification())) {
                materialArchivesVO.setMaterialSpecification(materialArchivesDO.getMaterialSpecification());
            }
            if (ObjectUtil.isNotEmpty((Object)materialArchivesDO.getUnitMeasurement())) {
                materialArchivesVO.setUnitMeasurement(materialArchivesDO.getUnitMeasurement());
            }
            if (ObjectUtil.isNotEmpty((Object)materialArchivesDO.getReferencePrice())) {
                materialArchivesVO.setReferencePrice(materialArchivesDO.getReferencePrice());
            }
            if (ObjectUtil.isNotEmpty((Object)materialArchivesDO.getOneYardPerObject())) {
                materialArchivesVO.setOneYardPerObject(materialArchivesDO.getOneYardPerObject());
            }
            if (ObjectUtil.isNotEmpty((Object)materialArchivesDO.getMaterialName())) {
                materialArchivesVO.setMaterialName(this.getMaterialCategory(materialArchivesDO.getMaterialCategoryIdList()) + ">>" + materialArchivesDO.getMaterialName());
            }
            if (ObjectUtil.isNotEmpty((Object)(stockListDO = (StockListDO)this.stockListService.getOne((Wrapper)(wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(StockListDO::getMaterialId, (Object)materialsApplicationDemandDetailDTO.getMaterialId())))))) {
                materialArchivesVO.setCurrentCount(stockListDO.getCurrentStock());
            } else {
                materialArchivesVO.setCurrentCount(Long.valueOf(0L));
            }
            Long materialsApplicationDeliveredCount = this.materialsApplicationDemandDetailService.getMaterialsApplicationDeliveredCount(materialsApplicationDemandDetailDTO.getMaterialId());
            materialArchivesVO.setDeliveredCount(materialsApplicationDeliveredCount);
            return materialArchivesVO;
        }
        LambdaQueryWrapper materialArchivesDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialArchivesDO::getMaterialName, (Object)materialsApplicationDemandDetailDTO.getMaterialName());
        List materialArchivesDOList = this.materialArchivesService.list((Wrapper)materialArchivesDOLambdaQueryWrapper);
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(StockListDO::getMaterialName, (Object)materialsApplicationDemandDetailDTO.getMaterialName());
        StockListDO stockListDO = (StockListDO)this.stockListService.getOne((Wrapper)wrapper);
        if (ObjectUtil.isNotEmpty((Object)materialArchivesDOList)) {
            MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)materialArchivesDOList.get(0);
            MaterialArchivesVO materialArchivesVO = new MaterialArchivesVO();
            materialArchivesVO.setMaterialSpecification(materialArchivesDO.getMaterialSpecification());
            materialArchivesVO.setMaterialName(materialArchivesDO.getMaterialName());
            materialArchivesVO.setUnitMeasurement(this.getMaterialCategory(materialArchivesDO.getMaterialCategoryIdList()) + ">>" + materialArchivesDO.getUnitMeasurement());
            materialArchivesVO.setReferencePrice(materialArchivesDO.getReferencePrice());
            materialArchivesVO.setOneYardPerObject(materialArchivesVO.getOneYardPerObject());
            if (ObjectUtil.isNotEmpty((Object)stockListDO)) {
                materialArchivesVO.setCurrentCount(stockListDO.getCurrentStock());
            } else {
                materialArchivesVO.setCurrentCount(Long.valueOf(0L));
            }
            return materialArchivesVO;
        }
        return new MaterialArchivesVO();
    }

    public String getMaterialCategory(String materialCategoryIdList) {
        if (StringUtils.isBlank((CharSequence)materialCategoryIdList)) {
            return "";
        }
        List list = JSON.parseArray((String)materialCategoryIdList, String.class);
        List searchMenuList = this.itemCategoryService.list((Wrapper)new LambdaQueryWrapper().in(ItemCategoryDO::getId, (Collection)list));
        if (ObjectUtil.isNotEmpty((Object)searchMenuList)) {
            return searchMenuList.stream().map(ItemCategoryDO::getMenuName).collect(Collectors.joining(">>"));
        }
        return "";
    }

    public PurchaseOrderDTO getPurchaseNumberNew(Long purchaseOrderId) {
        PurchaseOrderDO purchaseOrderDO = (PurchaseOrderDO)this.purchaseOrderService.getById((Serializable)purchaseOrderId);
        PurchaseOrderDTO purchaseOrderDTO = new PurchaseOrderDTO();
        purchaseOrderDTO.setAssociatedMaterialApplicationOrderId(purchaseOrderDO.getAssociatedMaterialApplicationOrderId());
        purchaseOrderDTO.setPurchaseNumber(purchaseOrderDO.getPurchaseNumber());
        return purchaseOrderDTO;
    }

    public List<PurchaseOrderDemandDetailDO> getPurchaseDetail(PurchaseOrderDTO purchaseOrderDTO) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseOrderDO::getPurchaseNumber, (Object)purchaseOrderDTO.getPurchaseNumber());
        PurchaseOrderDO purchaseOrderDO = (PurchaseOrderDO)this.purchaseOrderService.getOne((Wrapper)wrapper);
        Long mainId = purchaseOrderDO.getId();
        Long associatedMaterialApplicationOrderId = purchaseOrderDO.getAssociatedMaterialApplicationOrderId();
        LambdaQueryWrapper wrapper1 = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseOrderDemandDetailDO::getMainId, (Object)mainId);
        List purchaseOrderDemandDetailDOList = this.purchaseOrderDemandDetailService.list((Wrapper)wrapper1);
        LambdaQueryWrapper outWarehouseManagementDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(OutWarehouseManagementDO::getRelatedMaterialApplicationFormId, (Object)associatedMaterialApplicationOrderId);
        OutWarehouseManagementDO warehouseManagementDO = (OutWarehouseManagementDO)this.outWarehouseManagementService.getOne((Wrapper)outWarehouseManagementDOLambdaQueryWrapper);
        Long id = warehouseManagementDO.getId();
        LambdaQueryWrapper outWarehouseManagementDemandDetailDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(OutWarehouseManagementDemandDetailDO::getMainId, (Object)id);
        List outWarehouseManagementDemandDetailDOList = this.outWarehouseManagementDemandDetailService.list((Wrapper)outWarehouseManagementDemandDetailDOLambdaQueryWrapper);
        MaterialsApplicationMaterialOrderDO materialsApplicationMaterialOrderDO = (MaterialsApplicationMaterialOrderDO)this.materialsApplicationMaterialOrderService.getById((Serializable)purchaseOrderDO.getId());
        Long materialsApplicationId = materialsApplicationMaterialOrderDO.getId();
        LambdaQueryWrapper materialsApplicationDemandDetailDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialsApplicationDemandDetailDO::getMainId, (Object)materialsApplicationId);
        List materialsApplicationDemandDetailDOList = this.materialsApplicationDemandDetailService.list((Wrapper)materialsApplicationDemandDetailDOLambdaQueryWrapper);
        ArrayList<PurchaseOrderDemandDetailDO> resultPurchaseOrderDemandDetailDOList = new ArrayList<PurchaseOrderDemandDetailDO>();
        for (PurchaseOrderDemandDetailDO purchaseOrderDemandDetailDO : purchaseOrderDemandDetailDOList) {
            Iterator iterator = outWarehouseManagementDemandDetailDOList.iterator();
            while (iterator.hasNext()) {
                OutWarehouseManagementDemandDetailDO outWarehouseManagementDemandDetailDO = (OutWarehouseManagementDemandDetailDO)iterator.next();
                if (!purchaseOrderDemandDetailDO.getMaterialName().equals(outWarehouseManagementDemandDetailDO.getMaterialName())) continue;
                purchaseOrderDemandDetailDO.setDeliveredCount(outWarehouseManagementDemandDetailDO.getDeliveredCount());
                break;
            }
            if (!(iterator = materialsApplicationDemandDetailDOList.iterator()).hasNext()) continue;
            MaterialsApplicationDemandDetailDO materialsApplicationDemandDetailDO = (MaterialsApplicationDemandDetailDO)iterator.next();
            if (materialsApplicationDemandDetailDO.getMaterialName().equals(purchaseOrderDemandDetailDO.getMaterialName())) {
                purchaseOrderDemandDetailDO.setMaterialSpecifications(materialsApplicationDemandDetailDO.getMaterialSpecification());
            }
            resultPurchaseOrderDemandDetailDOList.add(purchaseOrderDemandDetailDO);
        }
        return resultPurchaseOrderDemandDetailDOList;
    }

    public InventoryManagementDetailVO getInventoryList(String inventoryContent) {
        if (StringUtils.isEmpty((CharSequence)inventoryContent)) {
            List materialArchivesDOList = this.materialArchivesService.list();
            if (ObjectUtil.isEmpty((Object)materialArchivesDOList)) {
                return new InventoryManagementDetailVO();
            }
            InventoryManagementDetailVO inventoryManagementDetailVO = this.getInventoryManagementDetailVO(materialArchivesDOList);
            return inventoryManagementDetailVO;
        }
        LambdaQueryWrapper materialArchivesDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialArchivesDO::getMaterialCategoryId, (Object)inventoryContent);
        List materialArchivesDOList = this.materialArchivesService.list((Wrapper)materialArchivesDOLambdaQueryWrapper);
        if (ObjectUtil.isEmpty((Object)materialArchivesDOList)) {
            return new InventoryManagementDetailVO();
        }
        InventoryManagementDetailVO inventoryManagementDetailVO = this.getInventoryManagementDetailVO(materialArchivesDOList);
        return inventoryManagementDetailVO;
    }

    public InventoryManagementDetailVO getInventoryManagementDetailVO(List<MaterialArchivesDO> materialArchivesDOList) {
        List inventoryManagementListDTOS = materialArchivesDOList.stream().map(m -> {
            InventoryManagementListDTO inventoryManagementListDTO = new InventoryManagementListDTO();
            inventoryManagementListDTO.setOneThingOneCode(m.getOneYardPerObject());
            if (ObjectUtil.isNotEmpty((Object)m.getPrice())) {
                inventoryManagementListDTO.setPrice(m.getPrice());
            } else {
                inventoryManagementListDTO.setPrice(m.getReferencePrice());
            }
            inventoryManagementListDTO.setMaterialSpecifications(m.getMaterialSpecification());
            inventoryManagementListDTO.setItemName(m.getMaterialName());
            inventoryManagementListDTO.setMaterialId(m.getId());
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(StockListDO::getMaterialId, (Object)m.getId());
            StockListDO stockListDO = (StockListDO)this.stockListService.getOne((Wrapper)wrapper);
            if (ObjectUtil.isNotEmpty((Object)stockListDO)) {
                inventoryManagementListDTO.setStockCount(stockListDO.getCurrentStock());
            }
            LambdaQueryWrapper equipmentProfitLossMaterialListDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(EquipmentProfitLossMaterialListDO::getMaterialId, (Object)m.getId());
            List equipmentProfitLossMaterialListDOList = this.equipmentProfitLossMaterialListService.list((Wrapper)equipmentProfitLossMaterialListDOLambdaQueryWrapper);
            Long totalProfitQuantity = 0L;
            Long totalLossQuantity = 0L;
            if (ObjectUtil.isNotEmpty((Object)equipmentProfitLossMaterialListDOList)) {
                for (EquipmentProfitLossMaterialListDO equipmentProfitLossMaterialListDO : equipmentProfitLossMaterialListDOList) {
                    if (!StringUtils.isNotEmpty((CharSequence)equipmentProfitLossMaterialListDO.getLossProfitWay())) continue;
                    if (equipmentProfitLossMaterialListDO.getLossProfitWay().equals("\u635f")) {
                        totalLossQuantity = totalLossQuantity + equipmentProfitLossMaterialListDO.getLossProfitQuantity();
                    }
                    if (!equipmentProfitLossMaterialListDO.getLossProfitWay().equals("\u76ca")) continue;
                    totalProfitQuantity = totalProfitQuantity + equipmentProfitLossMaterialListDO.getLossProfitQuantity();
                }
                inventoryManagementListDTO.setProfitLossVolume(Long.valueOf(totalLossQuantity - totalProfitQuantity));
                inventoryManagementListDTO.setProfitLossAmount(m.getReferencePrice().multiply(new BigDecimal(totalLossQuantity - totalProfitQuantity)));
            } else {
                inventoryManagementListDTO.setProfitLossVolume(Long.valueOf(0L));
                inventoryManagementListDTO.setProfitLossAmount(new BigDecimal(0));
            }
            return inventoryManagementListDTO;
        }).collect(Collectors.toList());
        Long totalProfitLossVolume = 0L;
        BigDecimal totalProfitLossAmount = new BigDecimal(0);
        Long totalStockCount = 0L;
        for (InventoryManagementListDTO inventoryManagementListDTO : inventoryManagementListDTOS) {
            if (ObjectUtil.isEmpty((Object)inventoryManagementListDTO.getProfitLossAmount())) {
                inventoryManagementListDTO.setProfitLossAmount(new BigDecimal(0));
            }
            if (ObjectUtil.isEmpty((Object)inventoryManagementListDTO.getStockCount())) {
                inventoryManagementListDTO.setStockCount(Long.valueOf(0L));
            }
            if (ObjectUtil.isEmpty((Object)inventoryManagementListDTO.getProfitLossVolume())) {
                inventoryManagementListDTO.setProfitLossVolume(Long.valueOf(0L));
            }
            if (ObjectUtil.isNotEmpty((Object)inventoryManagementListDTO.getProfitLossAmount())) {
                totalProfitLossAmount = totalProfitLossAmount.add(inventoryManagementListDTO.getProfitLossAmount());
            }
            if (ObjectUtil.isNotEmpty((Object)inventoryManagementListDTO.getProfitLossVolume())) {
                totalProfitLossVolume = totalProfitLossVolume + inventoryManagementListDTO.getProfitLossVolume();
            }
            if (!ObjectUtil.isNotEmpty((Object)inventoryManagementListDTO.getStockCount())) continue;
            totalStockCount = totalStockCount + inventoryManagementListDTO.getStockCount();
        }
        InventoryManagementDetailVO inventoryManagementDetailVO = new InventoryManagementDetailVO();
        inventoryManagementDetailVO.setInventoryManagementListDTOList(inventoryManagementListDTOS);
        inventoryManagementDetailVO.setTotalProfitLossVolume(totalProfitLossVolume);
        inventoryManagementDetailVO.setTotalStockCount(totalStockCount);
        inventoryManagementDetailVO.setTotalProfitLossAmount(totalProfitLossAmount);
        return inventoryManagementDetailVO;
    }

    public List<LogisticsTrackingVO> getLogisticsInformation(String purchaseOrOutWarehouseNumber) {
        if (purchaseOrOutWarehouseNumber.contains("WZCK")) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(OutWarehouseManagementDO::getOutWarehouseNumber, (Object)purchaseOrOutWarehouseNumber);
            OutWarehouseManagementDO warehouseManagementDO = (OutWarehouseManagementDO)this.outWarehouseManagementService.getOne((Wrapper)wrapper);
            Long mainId = warehouseManagementDO.getId();
            LambdaQueryWrapper managementLogisticsInformationDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(OutWarehouseManagementLogisticsInformationDO::getMainId, (Object)mainId);
            List outWarehouseManagementLogisticsInformationDOList = this.outWarehouseManagementLogisticsInformationService.list((Wrapper)managementLogisticsInformationDOLambdaQueryWrapper);
            List<LogisticsTrackingVO> logisticsTrackingVOList = outWarehouseManagementLogisticsInformationDOList.stream().map(m -> {
                LogisticsTrackingVO logisticsTrackingVO = new LogisticsTrackingVO();
                String trackingNumber = m.getTrackingNumber();
                logisticsTrackingVO.setTrackingNumber(trackingNumber);
                try {
                    String order = this.kuaiDi100Service.findOrder(trackingNumber);
                    JSONObject jsonObject = JSON.parseObject((String)order);
                    String data = jsonObject.getString("data");
                    logisticsTrackingVO.setLogisticsInformation(JSON.parseArray((String)data));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return logisticsTrackingVO;
            }).collect(Collectors.toList());
            return logisticsTrackingVOList;
        }
        if (purchaseOrOutWarehouseNumber.contains("CGDD")) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseOrderDO::getPurchaseNumber, (Object)purchaseOrOutWarehouseNumber);
            PurchaseOrderDO purchaseOrderDO = (PurchaseOrderDO)this.purchaseOrderService.getOne((Wrapper)wrapper);
            Long mainId = purchaseOrderDO.getId();
            LambdaQueryWrapper purchaseOrderLogisticsInformationDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseOrderLogisticsInformationDO::getMainId, (Object)mainId);
            List logisticsInformationDOList = this.purchaseOrderLogisticsInformationService.list((Wrapper)purchaseOrderLogisticsInformationDOLambdaQueryWrapper);
            if (ObjectUtil.isEmpty((Object)logisticsInformationDOList)) {
                return null;
            }
            List<LogisticsTrackingVO> logisticsTrackingVOList = logisticsInformationDOList.stream().map(m -> {
                LogisticsTrackingVO logisticsTrackingVO = new LogisticsTrackingVO();
                String trackingNumber = m.getTrackingNumber();
                logisticsTrackingVO.setTrackingNumber(trackingNumber);
                try {
                    String order = this.kuaiDi100Service.findOrder(trackingNumber);
                    JSONObject jsonObject = JSON.parseObject((String)order);
                    String data = jsonObject.getString("data");
                    logisticsTrackingVO.setLogisticsInformation(JSON.parseArray((String)data));
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return logisticsTrackingVO;
            }).collect(Collectors.toList());
            return logisticsTrackingVOList;
        }
        return null;
    }

    public List<PaymentDetailsVO> getPaymentDetails(Long id) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(PurchaseOrderDemandDetailDO::getMainId, (Object)id);
        List purchaseOrderDemandDetailDOList = this.purchaseOrderDemandDetailService.list((Wrapper)wrapper);
        if (ObjectUtil.isEmpty((Object)purchaseOrderDemandDetailDOList)) {
            return null;
        }
        PurchaseOrderDO purchaseOrderDO = (PurchaseOrderDO)this.purchaseOrderService.getById((Serializable)id);
        if (ObjectUtil.isNotEmpty((Object)purchaseOrderDO)) {
            List<PaymentDetailsVO> paymentDetailsVOList = purchaseOrderDemandDetailDOList.stream().map(m -> {
                PaymentDetailsVO paymentDetailsVO = new PaymentDetailsVO();
                paymentDetailsVO.setUser(purchaseOrderDO.getPurchaser());
                paymentDetailsVO.setPaymentDate(purchaseOrderDO.getPurchaseDate());
                paymentDetailsVO.setPurpose(purchaseOrderDO.getMaterialUsage());
                paymentDetailsVO.setReimbursementContent(m.getMaterialName());
                paymentDetailsVO.setQuantity(m.getPurchaseCount());
                LambdaQueryWrapper materialArchivesDOLambdaQueryWrapper = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(MaterialArchivesDO::getMaterialName, (Object)m.getMaterialName());
                MaterialArchivesDO materialArchivesDO = (MaterialArchivesDO)this.materialArchivesService.getOne((Wrapper)materialArchivesDOLambdaQueryWrapper);
                if (ObjectUtil.isNotEmpty((Object)materialArchivesDO)) {
                    paymentDetailsVO.setPrice(materialArchivesDO.getReferencePrice());
                    paymentDetailsVO.setTotalPrice(materialArchivesDO.getReferencePrice().multiply(new BigDecimal(m.getPurchaseCount())));
                }
                return paymentDetailsVO;
            }).collect(Collectors.toList());
            return paymentDetailsVOList;
        }
        return null;
    }

    public String getCityCode(String city) {
        JSONArray body = MapUtyils.getDistricts();
        DistrictsVO districtsVO = (DistrictsVO)JSONObject.parseObject((String)body.toJSONString(), DistrictsVO.class);
        if (city.contains("-")) {
            String replace = city.replace("-", "");
            String code = this.findAreaCode(districtsVO, replace);
            return code;
        }
        String code = this.findAreaCode(districtsVO, city);
        return code;
    }

    public String findAreaCode(DistrictsVO districtsVO, String targetCityName) {
        if (ObjectUtil.isNotEmpty((Object)districtsVO.getName()) && districtsVO.getName().contains(targetCityName)) {
            return districtsVO.getCode();
        }
        for (DistrictsVO districts : districtsVO.getDistricts()) {
            String areaCode = this.findAreaCode(districts, targetCityName);
            if (areaCode == null) continue;
            return areaCode;
        }
        return null;
    }

    public List<ItemCategoryVO> getEquipmentAllocationDetail(String outProjectCode) {
        List searchMenuList = this.itemCategoryService.getSearchMenu();
        if (ObjectUtil.isEmpty((Object)searchMenuList)) {
            return searchMenuList;
        }
        List listItemCategoryVO = this.getListItemCategoryVO(searchMenuList, outProjectCode);
        return listItemCategoryVO;
    }

    private List<ItemCategoryVO> getListItemCategoryVO(List<ItemCategoryVO> itemCategoryVO, String outProjectCode) {
        ArrayList itemCategoryVOList = new ArrayList();
        itemCategoryVO.forEach(a -> {
            if (a.getAuthMenuList().size() > 0) {
                this.getListItemCategoryVO(a.getAuthMenuList(), outProjectCode);
            } else {
                LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
                lambdaQueryWrapper.eq(MaterialArchivesDO::getMaterialCategoryId, (Object)a.getId());
                lambdaQueryWrapper.eq(MaterialArchivesDO::getOneYardPerObject, (Object)"\u542f\u7528");
                List list = this.materialArchivesService.list((Wrapper)lambdaQueryWrapper);
                list.forEach(b -> {
                    LambdaQueryWrapper stockListWrapper = new LambdaQueryWrapper();
                    stockListWrapper.eq(StockListDO::getProjectCode, (Object)outProjectCode);
                    stockListWrapper.eq(StockListDO::getMaterialId, (Object)b.getId());
                    List stockListDOList = this.stockListService.list((Wrapper)stockListWrapper);
                    ItemCategoryVO itemCategorys = new ItemCategoryVO();
                    itemCategorys.setId(b.getId());
                    itemCategorys.setMenuName(b.getMaterialName());
                    itemCategorys.setParentId(b.getMaterialCategoryId());
                    itemCategorys.setAterialArchivesDOList(stockListDOList);
                    itemCategoryVOList.add(itemCategorys);
                    a.setAuthMenuList(itemCategoryVOList);
                });
            }
        });
        return itemCategoryVO;
    }

    public void test() {
        List list1 = this.purchaseOrderDemandDetailService.list();
        for (PurchaseOrderDemandDetailDO purchaseOrderDemandDetailDO : list1) {
            MaterialArchivesDO byId;
            if (ObjectUtil.isEmpty((Object)purchaseOrderDemandDetailDO.getMaterialId()) || !ObjectUtil.isNotEmpty((Object)(byId = (MaterialArchivesDO)this.materialArchivesService.getById((Serializable)purchaseOrderDemandDetailDO.getMaterialId())))) continue;
            String materialCategory = this.getMaterialCategory(byId.getMaterialCategoryIdList());
            System.out.println(materialCategory + "-" + byId.getMaterialName());
            PurchaseOrderDemandDetailDO dos = new PurchaseOrderDemandDetailDO();
            dos.setId(purchaseOrderDemandDetailDO.getId());
            dos.setMaterialName(materialCategory + ">>" + byId.getMaterialName());
            this.purchaseOrderDemandDetailService.updateById((Object)dos);
        }
    }
}

