/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.gateway.filter;

import com.ruoyi.common.core.utils.JwtUtils;
import com.ruoyi.common.core.utils.ServletUtils;
import com.ruoyi.common.core.utils.StringUtils;
import com.ruoyi.common.redis.service.RedisService;
import com.ruoyi.gateway.config.properties.IgnoreWhiteProperties;
import io.jsonwebtoken.Claims;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class AuthFilter
implements GlobalFilter,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(AuthFilter.class);
    @Autowired
    private IgnoreWhiteProperties ignoreWhite;
    @Autowired
    private RedisService redisService;

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        ServerHttpRequest.Builder mutate = request.mutate();
        String url = request.getURI().getPath();
        if (StringUtils.matches((String)url, (List)this.ignoreWhite.getWhites())) {
            return chain.filter(exchange);
        }
        String token = this.getToken(request);
        if (StringUtils.isEmpty((String)token)) {
            return this.unauthorizedResponse(exchange, "\u4ee4\u724c\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Claims claims = JwtUtils.parseToken((String)token);
        if (claims == null) {
            return this.unauthorizedResponse(exchange, "\u4ee4\u724c\u5df2\u8fc7\u671f\u6216\u9a8c\u8bc1\u4e0d\u6b63\u786e\uff01");
        }
        String userkey = JwtUtils.getUserKey((Claims)claims);
        boolean islogin = this.redisService.hasKey(this.getTokenKey(userkey));
        if (!islogin) {
            return this.unauthorizedResponse(exchange, "\u767b\u5f55\u72b6\u6001\u5df2\u8fc7\u671f");
        }
        String userid = JwtUtils.getUserId((Claims)claims);
        String username = JwtUtils.getUserName((Claims)claims);
        if (StringUtils.isEmpty((String)userid) || StringUtils.isEmpty((String)username)) {
            return this.unauthorizedResponse(exchange, "\u4ee4\u724c\u9a8c\u8bc1\u5931\u8d25");
        }
        this.addHeader(mutate, "user_key", (Object)userkey);
        this.addHeader(mutate, "user_id", (Object)userid);
        this.addHeader(mutate, "username", (Object)username);
        this.removeHeader(mutate, "from-source");
        return chain.filter(exchange.mutate().request(mutate.build()).build());
    }

    private void addHeader(ServerHttpRequest.Builder mutate, String name, Object value) {
        if (value == null) {
            return;
        }
        String valueStr = value.toString();
        String valueEncode = ServletUtils.urlEncode((String)valueStr);
        mutate.header(name, new String[]{valueEncode});
    }

    private void removeHeader(ServerHttpRequest.Builder mutate, String name) {
        mutate.headers(httpHeaders -> httpHeaders.remove((Object)name)).build();
    }

    private Mono<Void> unauthorizedResponse(ServerWebExchange exchange, String msg) {
        log.error("[\u9274\u6743\u5f02\u5e38\u5904\u7406]\u8bf7\u6c42\u8def\u5f84:{}", (Object)exchange.getRequest().getPath());
        return ServletUtils.webFluxResponseWriter((ServerHttpResponse)exchange.getResponse(), (Object)msg, (int)401);
    }

    private String getTokenKey(String token) {
        return "login_tokens:" + token;
    }

    private String getToken(ServerHttpRequest request) {
        String token = request.getHeaders().getFirst("Authorization");
        if (StringUtils.isNotEmpty((String)token) && token.startsWith("Bearer ")) {
            token = token.replaceFirst("Bearer ", "");
        }
        return token;
    }

    public int getOrder() {
        return -200;
    }
}

