/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.extension.api.R;
import com.ruoyi.query.AccessStatQuery;
import com.ruoyi.query.ChatStatQuery;
import com.ruoyi.service.CustomerServiceChatRecordService;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.vo.chatrecord.AccessStatVO;
import com.ruoyi.vo.stat.ChatStatExportVO;
import com.ruoyi.vo.stat.ChatStatTwoExportVO;
import com.ruoyi.vo.stat.ChatStatVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5ba2\u670d\u7edf\u8ba1"})
@RequestMapping(value={"/stat"})
@RestController
public class CustomerServiceStatController {
    private static final Logger log = LoggerFactory.getLogger(CustomerServiceStatController.class);
    @Autowired
    private CustomerServiceChatRecordService customerServiceChatRecordService;

    @PostMapping(value={"/chat"})
    @ApiOperation(value="\u4f1a\u8bdd\u7edf\u8ba1")
    public R<List<ChatStatVO>> chatStatPageList(@RequestBody ChatStatQuery query) {
        try {
            if (StrUtil.isBlank((CharSequence)query.getStatBeginDate()) || StrUtil.isBlank((CharSequence)query.getStatEndDate()) || StrUtil.isBlank((CharSequence)query.getBeginTime()) || StrUtil.isBlank((CharSequence)query.getEndTime())) {
                return R.failed((String)"\u53c2\u6570\u9519\u8bef");
            }
            return R.ok((Object)this.customerServiceChatRecordService.chatStat(query));
        }
        catch (Exception e) {
            log.error("An error occurred", (Throwable)e);
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/chat/export"})
    @ApiOperation(value="\u5bfc\u51fa\u4f1a\u8bdd\u7edf\u8ba1")
    public void exportChat(@RequestBody ChatStatQuery query, HttpServletResponse response) {
        try {
            if (StrUtil.isBlank((CharSequence)query.getStatBeginDate()) || StrUtil.isBlank((CharSequence)query.getStatEndDate()) || StrUtil.isBlank((CharSequence)query.getBeginTime()) || StrUtil.isBlank((CharSequence)query.getEndTime())) {
                throw new RuntimeException("\u53c2\u6570\u9519\u8bef");
            }
            List chatStatVOList = this.customerServiceChatRecordService.chatStat(query);
            if (query.getStarts().equals("\u5426")) {
                List exportList = chatStatVOList.stream().map(chatStatVO -> {
                    ChatStatTwoExportVO chatStatExportVO = new ChatStatTwoExportVO();
                    BeanUtil.copyProperties((Object)chatStatVO, (Object)chatStatExportVO, (String[])new String[0]);
                    return chatStatExportVO;
                }).collect(Collectors.toList());
                Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u4f1a\u8bdd\u7edf\u8ba1", "\u4f1a\u8bdd\u7edf\u8ba1", ExcelType.XSSF), ChatStatTwoExportVO.class, exportList);
                ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)"\u4f1a\u8bdd\u7edf\u8ba1");
            } else {
                List exportList = chatStatVOList.stream().map(chatStatVO -> {
                    ChatStatExportVO chatStatExportVO = new ChatStatExportVO();
                    BeanUtil.copyProperties((Object)chatStatVO, (Object)chatStatExportVO, (String[])new String[0]);
                    return chatStatExportVO;
                }).collect(Collectors.toList());
                Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u4f1a\u8bdd\u7edf\u8ba1", "\u4f1a\u8bdd\u7edf\u8ba1", ExcelType.XSSF), ChatStatExportVO.class, exportList);
                ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)"\u4f1a\u8bdd\u7edf\u8ba1");
            }
        }
        catch (Exception e) {
            log.warn("\u5bfc\u51fa\u5931\u8d25 error:{}", (Object)e.getMessage());
        }
    }

    @PostMapping(value={"/access"})
    @ApiOperation(value="\u5ba2\u670d\u63a5\u5165\u7edf\u8ba1")
    public R<PageResultVo<AccessStatVO>> getContractProjectsListPage(@RequestBody AccessStatQuery query) {
        try {
            if (StrUtil.isBlank((CharSequence)query.getStatBeginDate()) || StrUtil.isBlank((CharSequence)query.getStatEndDate()) || StrUtil.isBlank((CharSequence)query.getStatDimension())) {
                return R.failed((String)"\u53c2\u6570\u9519\u8bef");
            }
            return R.ok((Object)this.customerServiceChatRecordService.accessStat(query));
        }
        catch (Exception e) {
            log.error("An error occurred", (Throwable)e);
            return R.failed((String)e.getLocalizedMessage());
        }
    }
}

