/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import cn.hutool.core.util.NumberUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.constant.FinishedByEnum;
import com.ruoyi.entity.CustomerServiceChatRecord;
import com.ruoyi.entity.CustomerServiceChatRecordLog;
import com.ruoyi.mapper.CustomerServiceChatRecordMapper;
import com.ruoyi.query.AccessInfoQuery;
import com.ruoyi.query.AccessStatQuery;
import com.ruoyi.query.ChatStatQuery;
import com.ruoyi.service.CustomerServiceChatRecordLogService;
import com.ruoyi.service.CustomerServiceChatRecordService;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.vo.chatrecord.AccessInfoExportVO;
import com.ruoyi.vo.chatrecord.AccessInfoVO;
import com.ruoyi.vo.chatrecord.AccessStatVO;
import com.ruoyi.vo.chatrecord.RelatedProjectVO;
import com.ruoyi.vo.stat.ChatStatVO;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerServiceChatRecordServiceImpl
extends ServiceImpl<CustomerServiceChatRecordMapper, CustomerServiceChatRecord>
implements CustomerServiceChatRecordService {
    private static final Logger log = LoggerFactory.getLogger(CustomerServiceChatRecordServiceImpl.class);
    @Autowired
    private CustomerServiceChatRecordLogService customerServiceChatRecordLogService;

    private LambdaQueryWrapper getQueryWrapperByAccessInfoQuery(AccessInfoQuery query) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)query.getBeginTime())) {
            wrapper.ge(CustomerServiceChatRecord::getBeginTime, (Object)(query.getBeginTime() + " 00:00:00"));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getEndTime())) {
            wrapper.le(CustomerServiceChatRecord::getBeginTime, (Object)(query.getEndTime() + " 23:59:59"));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getNickname())) {
            wrapper.like(CustomerServiceChatRecord::getCusNickname, (Object)query.getNickname());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getAgentName())) {
            wrapper.like(CustomerServiceChatRecord::getAgentName, (Object)query.getAgentName());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getCity())) {
            String[] place = query.getCity().split("-");
            ((LambdaQueryWrapper)wrapper.eq(CustomerServiceChatRecord::getProvince, (Object)place[0])).eq(CustomerServiceChatRecord::getCity, (Object)place[1]);
        }
        if (StrUtil.isNotBlank((CharSequence)query.getFinishBy())) {
            wrapper.eq(CustomerServiceChatRecord::getFinishedBy, (Object)query.getFinishBy());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getSatisfactionName())) {
            wrapper.eq(CustomerServiceChatRecord::getFirstLevalSatisfactionName, (Object)query.getSatisfactionName());
        }
        if (null != query.getHasRelated()) {
            if (query.getHasRelated().booleanValue()) {
                wrapper.isNotNull(CustomerServiceChatRecord::getSystemProjectId);
            } else {
                wrapper.isNull(CustomerServiceChatRecord::getSystemProjectId);
            }
        }
        if (null != query.getProjectId()) {
            wrapper.eq(CustomerServiceChatRecord::getSystemProjectId, (Object)Long.parseLong(query.getProjectId()));
        }
        wrapper.orderByDesc(CustomerServiceChatRecord::getBeginTime);
        return wrapper;
    }

    public void receive(String data) {
        log.info("\u5ba2\u670d\u6d88\u606f\u5bf9\u63a5 =\u300b {}", (Object)data);
        Map map = (Map)JSONObject.parseObject((String)data, Map.class);
        CustomerServiceChatRecord chatRecord = (CustomerServiceChatRecord)BeanUtil.toBeanIgnoreCase((Object)map, CustomerServiceChatRecord.class, (boolean)false);
        log.info("\u5ba2\u670d\u6d88\u606f\u5bf9\u63a5 =\u300b {}", (Object)JSON.toJSONString((Object)chatRecord));
        this.save((Object)chatRecord);
        CustomerServiceChatRecordLog chatRecordLog = new CustomerServiceChatRecordLog();
        chatRecordLog.setId(chatRecord.getId());
        chatRecordLog.setMessage(JSONObject.toJSONString((Object)map));
        chatRecordLog.setCreateTime(LocalDateTime.now());
        this.customerServiceChatRecordLogService.save((Object)chatRecordLog);
    }

    public PageResultVo<AccessInfoVO> getPageList(AccessInfoQuery query) {
        LambdaQueryWrapper wrapper = this.getQueryWrapperByAccessInfoQuery(query);
        wrapper.isNotNull(CustomerServiceChatRecord::getAgentId);
        wrapper.ne(CustomerServiceChatRecord::getAgentId, (Object)"");
        Page page = new Page((long)query.getPageNum(), (long)query.getPageSize());
        this.page((IPage)page, (Wrapper)wrapper);
        ArrayList resultList = new ArrayList();
        page.getRecords().forEach(r -> {
            AccessInfoVO accessInfoVO = new AccessInfoVO();
            BeanUtil.copyProperties((Object)r, (Object)accessInfoVO, (String[])new String[0]);
            accessInfoVO.setChatBeginTime(DateUtil.formatLocalDateTime((LocalDateTime)r.getBeginTime()));
            accessInfoVO.setChatEndTime(DateUtil.formatLocalDateTime((LocalDateTime)r.getEndTime()));
            resultList.add(accessInfoVO);
        });
        return new PageResultVo(page, resultList);
    }

    public void relatedProject(RelatedProjectVO vo) {
        CustomerServiceChatRecord chatRecord = (CustomerServiceChatRecord)this.getById((Serializable)((Object)vo.getId()));
        if (null == chatRecord) {
            throw new RuntimeException("\u8bb0\u5f55\u4e0d\u5b58\u5728");
        }
        chatRecord.setSystemProjectId(Long.valueOf(Long.parseLong(vo.getProjectId())));
        chatRecord.setSystemProjectName(vo.getProjectName());
        this.updateById((Object)chatRecord);
    }

    public List<AccessInfoExportVO> exportList(AccessInfoQuery query) {
        List records = this.list((Wrapper)this.getQueryWrapperByAccessInfoQuery(query));
        ArrayList<AccessInfoExportVO> resultList = new ArrayList<AccessInfoExportVO>();
        records.forEach(r -> {
            AccessInfoExportVO accessInfoExportVO = new AccessInfoExportVO();
            BeanUtil.copyProperties((Object)r, (Object)accessInfoExportVO, (String[])new String[0]);
            accessInfoExportVO.setBeginTime(DateUtil.formatLocalDateTime((LocalDateTime)r.getBeginTime()));
            accessInfoExportVO.setEndTime(DateUtil.formatLocalDateTime((LocalDateTime)r.getEndTime()));
            accessInfoExportVO.setFinishedBy(FinishedByEnum.getNameByCode((String)accessInfoExportVO.getFinishedBy()));
            resultList.add(accessInfoExportVO);
        });
        return resultList;
    }

    public List<ChatStatVO> chatStat(ChatStatQuery query) {
        ArrayList<ChatStatVO> result = new ArrayList<ChatStatVO>();
        if (query.getStarts().equals("\u5426")) {
            try {
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd");
                LocalDate statBeginDate = LocalDate.parse(query.getStatBeginDate(), df);
                LocalDate statEndDate = LocalDate.parse(query.getStatEndDate(), df);
                long days = ChronoUnit.DAYS.between(statBeginDate, statEndDate);
                List records = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().between(CustomerServiceChatRecord::getBeginTime, (Object)DateUtil.parseLocalDateTime((CharSequence)(query.getStatBeginDate() + " 00:00:00")), (Object)DateUtil.parseLocalDateTime((CharSequence)(query.getStatEndDate() + " 23:59:59")))).apply("DATE(begin_time) BETWEEN {0} AND {1}", new Object[]{query.getStatBeginDate(), query.getStatEndDate()}));
                Map<LocalDate, List<CustomerServiceChatRecord>> groupedByHour = records.stream().collect(Collectors.groupingBy(item -> item.getBeginTime().toLocalDate()));
                int i = 0;
                while ((long)i <= days) {
                    LocalDate localDate = statBeginDate.plusDays(i);
                    List<CustomerServiceChatRecord> hourList = groupedByHour.get(localDate);
                    HashSet agentIds = new HashSet();
                    AtomicInteger robotServiceCount = new AtomicInteger();
                    AtomicInteger voicemailCount = new AtomicInteger();
                    AtomicInteger queueLeakCount = new AtomicInteger();
                    AtomicInteger satisfiedCount = new AtomicInteger();
                    AtomicInteger dissatisfiedCount = new AtomicInteger();
                    if (CollUtil.isNotEmpty(hourList)) {
                        hourList.forEach(h -> {
                            if ("robotService".equals(h.getStatus())) {
                                robotServiceCount.getAndIncrement();
                            }
                            if (StrUtil.isNotBlank((CharSequence)h.getAgentId())) {
                                agentIds.add(h.getAgentId());
                            }
                            if ("voicemail".equals(h.getStatus())) {
                                voicemailCount.getAndIncrement();
                            }
                            if ("queueLeak".equals(h.getStatus())) {
                                queueLeakCount.getAndIncrement();
                            }
                            if ("\u6ee1\u610f".equals(h.getFirstLevalSatisfactionName())) {
                                satisfiedCount.getAndIncrement();
                            }
                            if ("\u4e0d\u6ee1\u610f".equals(h.getFirstLevalSatisfactionName())) {
                                dissatisfiedCount.getAndIncrement();
                            }
                        });
                    }
                    ChatStatVO chatStatVO = new ChatStatVO();
                    chatStatVO.setStatBeginDate(String.valueOf(localDate));
                    chatStatVO.setChatTotalCount(Integer.valueOf(CollUtil.isEmpty(hourList) ? 0 : hourList.size()));
                    chatStatVO.setRobotServicesCount(Integer.valueOf(robotServiceCount.get()));
                    chatStatVO.setAgentCount(Integer.valueOf(agentIds.size()));
                    chatStatVO.setVoicemailCount(Integer.valueOf(voicemailCount.get()));
                    chatStatVO.setQueueLeakCount(Integer.valueOf(queueLeakCount.get()));
                    if (CollUtil.isEmpty(hourList)) {
                        chatStatVO.setQueueLeakRate("0%");
                    } else {
                        chatStatVO.setQueueLeakRate(Math.round((float)queueLeakCount.get() / (float)hourList.size() * 100.0f) + "%");
                    }
                    chatStatVO.setSatisfiedCount(Integer.valueOf(satisfiedCount.get()));
                    chatStatVO.setDissatisfiedCount(Integer.valueOf(dissatisfiedCount.get()));
                    result.add(0, chatStatVO);
                    ++i;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            int startHour = Integer.parseInt(query.getBeginTime());
            int endHour = Integer.parseInt(query.getEndTime());
            List records = this.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().between(CustomerServiceChatRecord::getBeginTime, (Object)DateUtil.parseLocalDateTime((CharSequence)(query.getStatBeginDate() + " 00:00:00")), (Object)DateUtil.parseLocalDateTime((CharSequence)(query.getStatEndDate() + " 23:59:59")))).apply("HOUR(begin_time) BETWEEN {0} AND {1}", new Object[]{startHour, endHour}));
            Map<Integer, List<CustomerServiceChatRecord>> groupedByHour = records.stream().collect(Collectors.groupingBy(item -> item.getBeginTime().getHour()));
            for (int i = startHour; i < endHour + 1; ++i) {
                List<CustomerServiceChatRecord> hourList = groupedByHour.get(i);
                HashSet agentIds = new HashSet();
                AtomicInteger robotServiceCount = new AtomicInteger();
                AtomicInteger voicemailCount = new AtomicInteger();
                AtomicInteger queueLeakCount = new AtomicInteger();
                AtomicInteger satisfiedCount = new AtomicInteger();
                AtomicInteger dissatisfiedCount = new AtomicInteger();
                if (CollUtil.isNotEmpty(hourList)) {
                    hourList.forEach(h -> {
                        if ("robotService".equals(h.getStatus())) {
                            robotServiceCount.getAndIncrement();
                        }
                        if (StrUtil.isNotBlank((CharSequence)h.getAgentId())) {
                            agentIds.add(h.getAgentId());
                        }
                        if ("voicemail".equals(h.getStatus())) {
                            voicemailCount.getAndIncrement();
                        }
                        if ("queueLeak".equals(h.getStatus())) {
                            queueLeakCount.getAndIncrement();
                        }
                        if ("\u6ee1\u610f".equals(h.getFirstLevalSatisfactionName())) {
                            satisfiedCount.getAndIncrement();
                        }
                        if ("\u4e0d\u6ee1\u610f".equals(h.getFirstLevalSatisfactionName())) {
                            dissatisfiedCount.getAndIncrement();
                        }
                    });
                }
                ChatStatVO chatStatVO = new ChatStatVO();
                chatStatVO.setStatBeginDate(query.getStatBeginDate());
                chatStatVO.setStatEndDate(query.getStatEndDate());
                chatStatVO.setTimePeriod(NumberUtil.decimalFormat((String)"#00", (long)i) + ":00 - " + NumberUtil.decimalFormat((String)"#00", (long)(i + 1 == 24 ? 0L : (long)(i + 1))) + ":00");
                chatStatVO.setChatTotalCount(Integer.valueOf(CollUtil.isEmpty(hourList) ? 0 : hourList.size()));
                chatStatVO.setRobotServicesCount(Integer.valueOf(robotServiceCount.get()));
                chatStatVO.setAgentCount(Integer.valueOf(agentIds.size()));
                chatStatVO.setVoicemailCount(Integer.valueOf(voicemailCount.get()));
                chatStatVO.setQueueLeakCount(Integer.valueOf(queueLeakCount.get()));
                if (CollUtil.isEmpty(hourList)) {
                    chatStatVO.setQueueLeakRate("0%");
                } else {
                    chatStatVO.setQueueLeakRate(Math.round((float)queueLeakCount.get() / (float)hourList.size() * 100.0f) + "%");
                }
                chatStatVO.setSatisfiedCount(Integer.valueOf(satisfiedCount.get()));
                chatStatVO.setDissatisfiedCount(Integer.valueOf(dissatisfiedCount.get()));
                result.add(chatStatVO);
            }
        }
        return result;
    }

    public PageResultVo<AccessStatVO> accessStat(AccessStatQuery query) {
        LocalDateTime beginDate = LocalDateTimeUtil.beginOfDay((LocalDateTime)DateUtil.parseLocalDateTime((CharSequence)(query.getStatBeginDate() + " 00:00:00")));
        LocalDateTime endDate = LocalDateTimeUtil.endOfDay((LocalDateTime)DateUtil.parseLocalDateTime((CharSequence)(query.getStatEndDate() + " 23:59:59")));
        Page page = new Page((long)query.getPageNum(), (long)query.getPageSize());
        ((CustomerServiceChatRecordMapper)this.baseMapper).accessStat(beginDate, endDate, query.getStatDimension(), page);
        ArrayList resultList = new ArrayList();
        page.getRecords().forEach(r -> {
            AccessStatVO accessStatVO = new AccessStatVO();
            BeanUtil.copyProperties((Object)r, (Object)accessStatVO, (String[])new String[0]);
            accessStatVO.setStatDate(query.getStatBeginDate().replace("-", ".") + " - " + query.getStatEndDate().replace("-", "."));
            resultList.add(accessStatVO);
        });
        return new PageResultVo(page, resultList);
    }
}

