/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUnit;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.constant.OpenNetworkWorkOrderProcessNode;
import com.ruoyi.constant.OpenNetworkWorkOrderStatus;
import com.ruoyi.constant.OpenNetworkWorkOrderType;
import com.ruoyi.entity.CustomerServiceOpenNetworkWorkOrder;
import com.ruoyi.entity.CustomerServiceRepairWorkOrder;
import com.ruoyi.entity.CustomerServiceRepairWorkOrderFile;
import com.ruoyi.mapper.CustomerServiceOpenNetworkWorkOrderMapper;
import com.ruoyi.mapper.CustomerServiceRepairWorkOrderFileMapper;
import com.ruoyi.query.OpenNetworkQuery;
import com.ruoyi.service.CustomerServiceOpenNetworkWorkOrderService;
import com.ruoyi.service.CustomerServiceRepairWorkOrderService;
import com.ruoyi.util.PageReqParam;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.SerialNumberUtil;
import com.ruoyi.util.ThemeUtils;
import com.ruoyi.vo.FileVO;
import com.ruoyi.vo.WorkOrderVo;
import com.ruoyi.vo.opennetwork.AppletWorkOrderInfoVO;
import com.ruoyi.vo.opennetwork.AppletWorkOrderVO;
import com.ruoyi.vo.opennetwork.CustomerServiceOpenNetworkWorkOrderVo;
import com.ruoyi.vo.opennetwork.EngineerInstallVO;
import com.ruoyi.vo.opennetwork.EngineeringManagerDispatchVO;
import com.ruoyi.vo.opennetwork.OrderTakerDispatchVO;
import com.ruoyi.vo.opennetwork.SelfServiceFillingVO;
import com.ruoyi.vo.opennetwork.TechnicalDeptApproveVO;
import com.ruoyi.vo.opennetwork.TmpStorageVO;
import com.ruoyi.vo.opennetwork.WorkOrderEditVO;
import com.ruoyi.vo.opennetwork.WorkOrderExportVO;
import com.ruoyi.vo.opennetwork.WorkOrderInfoVO;
import com.ruoyi.vo.opennetwork.WorkOrderRejectEditVO;
import com.ruoyi.vo.opennetwork.WorkOrderSaveVO;
import com.ruoyi.vo.opennetwork.WorkOrderVO;
import com.ruoyi.vo.repair.CustomerServiceRepairWorkOrderFileVo;
import com.ruoyi.workflow.service.WorkFlowService;
import com.ruoyi.workflow.vo.ApproveTaskVO;
import com.ruoyi.workflow.vo.ApproveVO;
import com.ruoyi.workflow.vo.JumpVO;
import com.ruoyi.workflow.vo.ProcessStartVO;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CustomerServiceOpenNetworkWorkOrderServiceImpl
extends ServiceImpl<CustomerServiceOpenNetworkWorkOrderMapper, CustomerServiceOpenNetworkWorkOrder>
implements CustomerServiceOpenNetworkWorkOrderService {
    @Autowired
    private WorkFlowService workFlowService;
    @Autowired
    private CustomerServiceRepairWorkOrderService customerServiceRepairWorkOrderService;
    @Autowired
    private CustomerServiceRepairWorkOrderFileMapper customerServiceRepairWorkOrderFileMapper;
    @Value(value="${work-flow.process-definition-key.kwgd}")
    private String PROCESS_DEFINITION_KEY;

    private LambdaQueryWrapper<CustomerServiceOpenNetworkWorkOrder> getQueryWrapperByOpenNetworkQuery(OpenNetworkQuery query) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)query.getSerialNumber())) {
            wrapper.like(CustomerServiceOpenNetworkWorkOrder::getSerialNumber, (Object)query.getSerialNumber());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getSubjectName())) {
            wrapper.like(CustomerServiceOpenNetworkWorkOrder::getSubjectName, (Object)query.getSubjectName());
        }
        if (null != query.getProjectType()) {
            wrapper.eq(CustomerServiceOpenNetworkWorkOrder::getProjectType, (Object)query.getProjectType());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getProjectName())) {
            wrapper.like(CustomerServiceOpenNetworkWorkOrder::getProjectName, (Object)query.getProjectName());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getBusinessManagerName())) {
            wrapper.like(CustomerServiceOpenNetworkWorkOrder::getBusinessManagerName, (Object)query.getBusinessManagerName());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getUserRoomNo())) {
            wrapper.like(CustomerServiceOpenNetworkWorkOrder::getUserRoomNo, (Object)query.getUserRoomNo());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getUserBroadbandAccount())) {
            wrapper.like(CustomerServiceOpenNetworkWorkOrder::getUserBroadbandAccount, (Object)query.getUserBroadbandAccount());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getUserLeaseEndTimeBegin())) {
            wrapper.ge(CustomerServiceOpenNetworkWorkOrder::getUserLeaseEndTime, (Object)query.getUserLeaseEndTimeBegin());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getUserLeaseEndTimeEnd())) {
            wrapper.le(CustomerServiceOpenNetworkWorkOrder::getUserLeaseEndTime, (Object)query.getUserLeaseEndTimeEnd());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getReportInstallTimeBegin())) {
            wrapper.ge(CustomerServiceOpenNetworkWorkOrder::getReportInstallTime, (Object)query.getReportInstallTimeBegin());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getReportInstallTimeEnd())) {
            wrapper.le(CustomerServiceOpenNetworkWorkOrder::getReportInstallTime, (Object)query.getReportInstallTimeEnd());
        }
        if (null != query.getWorkOrderStatus()) {
            wrapper.eq(CustomerServiceOpenNetworkWorkOrder::getWorkOrderStatus, (Object)query.getWorkOrderStatus());
        }
        if (null != query.getWorkOrderType()) {
            wrapper.eq(CustomerServiceOpenNetworkWorkOrder::getWorkOrderType, (Object)query.getWorkOrderType());
        }
        wrapper.orderByDesc(CustomerServiceOpenNetworkWorkOrder::getCreateTime);
        return wrapper;
    }

    public PageResultVo<WorkOrderVO> pageList(OpenNetworkQuery query) {
        LambdaQueryWrapper wrapper = this.getQueryWrapperByOpenNetworkQuery(query);
        Page page = new Page((long)query.getPageNum(), (long)query.getPageSize());
        this.page((IPage)page, (Wrapper)wrapper);
        List myTasks = this.workFlowService.getMyTask();
        ArrayList resultList = new ArrayList();
        page.getRecords().forEach(r -> {
            WorkOrderVO openNetworkWorkOrderVO = new WorkOrderVO();
            BeanUtil.copyProperties((Object)r, (Object)openNetworkWorkOrderVO, (String[])new String[0]);
            openNetworkWorkOrderVO.setWorkOrderType(OpenNetworkWorkOrderType.getNameByCode((Integer)r.getWorkOrderType()));
            openNetworkWorkOrderVO.setProjectType(r.getProjectType());
            if (CollUtil.isNotEmpty((Collection)myTasks) && myTasks.contains(r.getProcessId())) {
                openNetworkWorkOrderVO.setMyTask(Integer.valueOf(1));
            } else {
                openNetworkWorkOrderVO.setMyTask(Integer.valueOf(0));
            }
            resultList.add(openNetworkWorkOrderVO);
        });
        return new PageResultVo(page, resultList);
    }

    public List<WorkOrderExportVO> exportList(OpenNetworkQuery query) {
        List list = this.list((Wrapper)this.getQueryWrapperByOpenNetworkQuery(query));
        List<WorkOrderExportVO> result = list.stream().map(l -> {
            WorkOrderExportVO exportVO = new WorkOrderExportVO();
            BeanUtil.copyProperties((Object)l, (Object)exportVO, (String[])new String[0]);
            exportVO.setWorkOrderType(OpenNetworkWorkOrderType.getNameByCode((Integer)l.getWorkOrderType()));
            exportVO.setProjectType(l.getProjectType());
            exportVO.setWorkOrderStatus(OpenNetworkWorkOrderStatus.getNameByCode((Integer)l.getWorkOrderStatus()));
            exportVO.setCreateTime(DateUtil.formatLocalDateTime((LocalDateTime)l.getCreateTime()));
            return exportVO;
        }).collect(Collectors.toList());
        return result;
    }

    public CustomerServiceOpenNetworkWorkOrder findById(String id) {
        CustomerServiceOpenNetworkWorkOrder workOrder = (CustomerServiceOpenNetworkWorkOrder)this.getById((Serializable)Long.valueOf(Long.parseLong(id)));
        if (null == workOrder) {
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
        return workOrder;
    }

    public WorkOrderVo getWorkOrderVo(OpenNetworkQuery query) {
        CustomerServiceOpenNetworkWorkOrderVo customerServiceOpenNetworkWorkOrderVo;
        WorkOrderVo workOrderVo = new WorkOrderVo();
        Page page1 = new Page((long)query.getPageNum(), (long)query.getPageSize());
        Page page = new Page((long)query.getPageNum(), (long)query.getPageSize());
        if (null == query.getType() || query.getType() == 0) {
            LambdaQueryWrapper eq = new LambdaQueryWrapper();
            eq.eq(CustomerServiceOpenNetworkWorkOrder::getOrderTakerId, (Object)query.getUserId());
            eq.like(ObjectUtil.isNotEmpty((Object)query.getProjectName()), CustomerServiceOpenNetworkWorkOrder::getProjectName, (Object)query.getProjectName());
            eq.eq(ObjectUtil.isNotEmpty((Object)query.getCity()), CustomerServiceOpenNetworkWorkOrder::getCity, (Object)query.getCity());
            Page pages = (Page)this.page((IPage)page, (Wrapper)eq);
            PageResultVo resultVo = new PageResultVo(pages);
            PageResultVo adoptionReturnVOPageResultVo = new PageResultVo();
            ArrayList<CustomerServiceOpenNetworkWorkOrderVo> adoptionReturnVOList = new ArrayList<CustomerServiceOpenNetworkWorkOrderVo>();
            if (ObjectUtil.isNotEmpty((Object)resultVo.getData())) {
                for (CustomerServiceOpenNetworkWorkOrder adoptionReturnDO : resultVo.getData()) {
                    customerServiceOpenNetworkWorkOrderVo = new CustomerServiceOpenNetworkWorkOrderVo();
                    BeanUtils.copyProperties((Object)adoptionReturnDO, (Object)customerServiceOpenNetworkWorkOrderVo);
                    customerServiceOpenNetworkWorkOrderVo.setType(Integer.valueOf(0));
                    customerServiceOpenNetworkWorkOrderVo.setId(adoptionReturnDO.getId().toString());
                    adoptionReturnVOList.add(customerServiceOpenNetworkWorkOrderVo);
                }
            }
            adoptionReturnVOPageResultVo.setData(adoptionReturnVOList);
            adoptionReturnVOPageResultVo.setPageSize(resultVo.getPageSize());
            adoptionReturnVOPageResultVo.setPageNum(resultVo.getPageNum());
            adoptionReturnVOPageResultVo.setTotal(resultVo.getTotal());
            adoptionReturnVOPageResultVo.setTotalPageNum(resultVo.getTotalPageNum());
            workOrderVo.setCustomerServiceOpenNetworkWorkOrderPageResultVo(adoptionReturnVOPageResultVo);
            workOrderVo.setTotal(resultVo.getTotal());
        }
        if (null == query.getType() || query.getType() == 1) {
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(CustomerServiceRepairWorkOrder::getOrderTakerId, (Object)query.getUserId());
            queryWrapper.like(ObjectUtil.isNotEmpty((Object)query.getProjectName()), CustomerServiceRepairWorkOrder::getProjectName, (Object)query.getProjectName());
            queryWrapper.eq(ObjectUtil.isNotEmpty((Object)query.getCity()), CustomerServiceRepairWorkOrder::getCity, (Object)query.getCity());
            Page page2 = (Page)this.customerServiceRepairWorkOrderService.page((IPage)page1, (Wrapper)queryWrapper);
            PageResultVo resultVos = new PageResultVo(page2);
            PageResultVo adoptionReturnVOPageResultVos = new PageResultVo();
            ArrayList<CustomerServiceOpenNetworkWorkOrderVo> adoptionReturnVOLists = new ArrayList<CustomerServiceOpenNetworkWorkOrderVo>();
            if (ObjectUtil.isNotEmpty((Object)resultVos.getData())) {
                for (CustomerServiceOpenNetworkWorkOrder adoptionReturnDO : resultVos.getData()) {
                    customerServiceOpenNetworkWorkOrderVo = new CustomerServiceRepairWorkOrderFileVo();
                    BeanUtils.copyProperties((Object)adoptionReturnDO, (Object)customerServiceOpenNetworkWorkOrderVo);
                    List files = this.customerServiceRepairWorkOrderFileMapper.selectList((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerServiceRepairWorkOrderFile::getOrderId, (Object)customerServiceOpenNetworkWorkOrderVo.getId())).eq(CustomerServiceRepairWorkOrderFile::getIsDelete, (Object)0));
                    List fileVOList = files.stream().map(f -> {
                        FileVO fileVO = new FileVO();
                        fileVO.setName(f.getFileName());
                        fileVO.setUrl(f.getFilePath());
                        fileVO.setUid(f.getFileUid());
                        return fileVO;
                    }).collect(Collectors.toList());
                    customerServiceOpenNetworkWorkOrderVo.setFiles(fileVOList);
                    customerServiceOpenNetworkWorkOrderVo.setType(Integer.valueOf(1));
                    customerServiceOpenNetworkWorkOrderVo.setId(adoptionReturnDO.getId().toString());
                    adoptionReturnVOLists.add(customerServiceOpenNetworkWorkOrderVo);
                }
            }
            adoptionReturnVOPageResultVos.setData(adoptionReturnVOLists);
            adoptionReturnVOPageResultVos.setPageSize(resultVos.getPageSize());
            adoptionReturnVOPageResultVos.setPageNum(resultVos.getPageNum());
            adoptionReturnVOPageResultVos.setTotal(resultVos.getTotal());
            adoptionReturnVOPageResultVos.setTotalPageNum(resultVos.getTotalPageNum());
            workOrderVo.setCustomerServiceRepairWorkOrderFileVoPageResultVo(adoptionReturnVOPageResultVos);
            workOrderVo.setTotal(workOrderVo.getTotal() + resultVos.getTotal());
        }
        return workOrderVo;
    }

    public WorkOrderInfoVO info(String id) {
        CustomerServiceOpenNetworkWorkOrder workOrder = this.findById(id);
        WorkOrderInfoVO info = new WorkOrderInfoVO();
        BeanUtil.copyProperties((Object)workOrder, (Object)info, (String[])new String[0]);
        info.setCreateTime(DateUtil.formatLocalDateTime((LocalDateTime)workOrder.getCreateTime()));
        info.setInstallFinishTime(DateUtil.formatLocalDateTime((LocalDateTime)workOrder.getInstallFinishTime()));
        info.setCity(workOrder.getProvince() + "-" + workOrder.getCity());
        return info;
    }

    private CustomerServiceOpenNetworkWorkOrder save(WorkOrderSaveVO saveVO) {
        CustomerServiceOpenNetworkWorkOrder workOrder = new CustomerServiceOpenNetworkWorkOrder();
        BeanUtil.copyProperties((Object)saveVO, (Object)workOrder, (String[])new String[0]);
        if (StrUtil.isNotBlank((CharSequence)saveVO.getCity())) {
            String[] citys = saveVO.getCity().split("-");
            workOrder.setProvince(citys[0]);
            workOrder.setCity(citys[1]);
            workOrder.setSerialNumber(SerialNumberUtil.generate((String)"YY%s%s%s%s%s", (String)"KWGD", (String)citys[1]));
        }
        workOrder.setWorkOrderType(OpenNetworkWorkOrderType.ENTRY.getCode());
        ThemeUtils themes = new ThemeUtils();
        workOrder.setSubjectName(ThemeUtils.getThemeName((String)"\u5f00\u7f51\u5de5\u5355\u7533\u8bf7"));
        this.save((Object)workOrder);
        return workOrder;
    }

    private CustomerServiceOpenNetworkWorkOrder edit(WorkOrderEditVO editVO) {
        CustomerServiceOpenNetworkWorkOrder workOrder = this.findById(editVO.getId());
        BeanUtil.copyProperties((Object)editVO, (Object)workOrder, (String[])new String[0]);
        if (StrUtil.isNotBlank((CharSequence)editVO.getCity())) {
            String[] citys = editVO.getCity().split("-");
            workOrder.setProvince(citys[0]);
            workOrder.setCity(citys[1]);
            if (!citys[0].equals(workOrder.getProvince()) && !citys[1].equals(workOrder.getCity())) {
                workOrder.setSerialNumber(SerialNumberUtil.generate((String)"YY%s%s%s%s%s", (String)"KWGD", (String)citys[1]));
            }
        }
        this.updateById((Object)workOrder);
        return workOrder;
    }

    private void processStart(CustomerServiceOpenNetworkWorkOrder workOrder, String formUrl) {
        String processInstId = this.workFlowService.start(ProcessStartVO.builder().processDefinitionKey(this.PROCESS_DEFINITION_KEY).processInstanceName(workOrder.getSubjectName()).businessKey(workOrder.getId() + "").projectName(workOrder.getProjectName()).startUserId(workOrder.getCreateId() + "").formUrl(formUrl).build());
        if (ObjectUtil.isNotEmpty((Object)processInstId)) {
            workOrder.setProcessInstId(processInstId);
            this.updateById((Object)workOrder);
        }
    }

    private void processFlow(String processInstanceId, ApproveVO approveVO) {
        this.workFlowService.approveTask(ApproveTaskVO.builder().assignee(approveVO.getApprover()).businessStatus("PASSED").comment(approveVO.getComment()).processInstanceId(processInstanceId).build());
    }

    public void fillOutSave(WorkOrderSaveVO saveVO) {
        saveVO.setWorkOrderStatus(OpenNetworkWorkOrderStatus.AWAITING_SUBMIT.getCode());
        this.save(saveVO);
    }

    public void fillOutSaveAndApply(WorkOrderSaveVO saveVO) {
        saveVO.setWorkOrderStatus(OpenNetworkWorkOrderStatus.AWAITING_REVIEW.getCode());
        CustomerServiceOpenNetworkWorkOrder workOrder = this.save(saveVO);
        this.processStart(workOrder, saveVO.getFormUrl());
    }

    public void fillOutEdit(WorkOrderEditVO editVO) {
        this.edit(editVO);
    }

    public void fillOutEditAndApply(WorkOrderEditVO editVO) {
        editVO.setWorkOrderStatus(OpenNetworkWorkOrderStatus.AWAITING_REVIEW.getCode());
        CustomerServiceOpenNetworkWorkOrder workOrder = this.edit(editVO);
        this.processStart(workOrder, editVO.getFormUrl());
    }

    public void fillOutRejectEdit(WorkOrderRejectEditVO rejectEditVO) {
        WorkOrderEditVO editVO = new WorkOrderEditVO();
        BeanUtil.copyProperties((Object)rejectEditVO, (Object)editVO, (String[])new String[0]);
        CustomerServiceOpenNetworkWorkOrder workOrder = this.edit(editVO);
        this.processFlow(workOrder.getProcessId(), new ApproveVO());
    }

    public void technicalDeptApprove(TechnicalDeptApproveVO approveVO) {
        CustomerServiceOpenNetworkWorkOrder workOrder = this.findById(approveVO.getId());
        workOrder.setUserBroadbandAccount(approveVO.getUserBroadbandAccount());
        workOrder.setIsActivateOuterNet(approveVO.getIsActivateOuterNet());
        this.updateById((Object)workOrder);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("isInstall", workOrder.getIsInstall() + "");
        this.workFlowService.approveTask(ApproveTaskVO.builder().assignee(approveVO.getApprover()).businessStatus("PASSED").comment(approveVO.getComment()).processInstanceId(workOrder.getProcessId()).formData(map).build());
    }

    public void engineeringManagerApprove(EngineeringManagerDispatchVO dispatchVO) {
        ApproveVO approveVO = new ApproveVO();
        BeanUtil.copyProperties((Object)dispatchVO, (Object)approveVO, (String[])new String[0]);
        CustomerServiceOpenNetworkWorkOrder workOrder = this.findById(approveVO.getId());
        workOrder.setOrderTakerId(Long.valueOf(Long.parseLong(approveVO.getApprover())));
        workOrder.setOrderTakerName(dispatchVO.getName());
        workOrder.setOrderTakerPhoneNumber(dispatchVO.getPhoneNumber());
        this.updateById((Object)workOrder);
        this.processFlow(workOrder.getProcessId(), approveVO);
    }

    public void orderTakerApprove(OrderTakerDispatchVO dispatchVO) {
        ApproveVO approveVO = new ApproveVO();
        BeanUtil.copyProperties((Object)dispatchVO, (Object)approveVO, (String[])new String[0]);
        CustomerServiceOpenNetworkWorkOrder workOrder = this.findById(approveVO.getId());
        workOrder.setInstallerType(dispatchVO.getInstallerType());
        workOrder.setInstallerId(Long.valueOf(Long.parseLong(dispatchVO.getApprover())));
        workOrder.setInstallerName(dispatchVO.getName());
        workOrder.setInstallerPhoneNumber(dispatchVO.getPhoneNumber());
        this.updateById((Object)workOrder);
        this.processFlow(workOrder.getProcessId(), approveVO);
    }

    public void engineerApprove(EngineerInstallVO installVO) {
        ApproveVO approveVO = new ApproveVO();
        BeanUtil.copyProperties((Object)installVO, (Object)approveVO, (String[])new String[0]);
        CustomerServiceOpenNetworkWorkOrder workOrder = this.findById(approveVO.getId());
        workOrder.setInstallFinishTime(DateUtil.parseLocalDateTime((CharSequence)installVO.getFinishTime()));
        workOrder.setActualInstallDescription(installVO.getActualInstallDescription());
        workOrder.setNote(installVO.getNote());
        this.updateById((Object)workOrder);
        this.processFlow(workOrder.getProcessId(), approveVO);
    }

    public void customerServiceApprove(ApproveVO approveVO) {
        CustomerServiceOpenNetworkWorkOrder workOrder = this.findById(approveVO.getId());
        this.processFlow(workOrder.getProcessId(), approveVO);
    }

    public List<Map<String, String>> getHistoricActivity(String id) {
        CustomerServiceOpenNetworkWorkOrder workOrder = this.findById(id);
        return this.workFlowService.getHistoricActivity(workOrder.getProcessId());
    }

    private void jump(CustomerServiceOpenNetworkWorkOrder workOrder, JumpVO jumpVO) {
        this.workFlowService.jump(workOrder.getProcessId(), jumpVO.getNode());
    }

    public void toStart(JumpVO jumpVO) {
        jumpVO.setNode(OpenNetworkWorkOrderProcessNode.FILL_OUT_WORK_ORDER.getName());
        this.toNode(jumpVO);
    }

    public void toNode(JumpVO jumpVO) {
        CustomerServiceOpenNetworkWorkOrder workOrder = this.findById(jumpVO.getId());
        this.jump(workOrder, jumpVO);
    }

    public void toUp(JumpVO jumpVO) {
        CustomerServiceOpenNetworkWorkOrder workOrder = this.findById(jumpVO.getId());
        int processNode = workOrder.getProcessNode();
        if (processNode == OpenNetworkWorkOrderProcessNode.FILL_OUT_WORK_ORDER.getCode() || processNode == OpenNetworkWorkOrderProcessNode.END.getCode()) {
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
        processNode = processNode == OpenNetworkWorkOrderProcessNode.CUSTOMER_SERVICE_DEPT.getCode() && workOrder.getIsInstall() == 0 ? OpenNetworkWorkOrderProcessNode.TECHNICAL_DEPT.getCode() : --processNode;
        jumpVO.setNode(OpenNetworkWorkOrderProcessNode.getNameByCode((Integer)processNode));
        this.jump(workOrder, jumpVO);
    }

    public void tmpStorage(TmpStorageVO tmpStorageVO) {
        CustomerServiceOpenNetworkWorkOrder updateEntity = new CustomerServiceOpenNetworkWorkOrder();
        updateEntity.setId(Long.valueOf(Long.parseLong(tmpStorageVO.getId())));
        updateEntity.setSubjectName(tmpStorageVO.getSubjectName());
        updateEntity.setProjectType(tmpStorageVO.getProjectType());
        if (ObjectUtil.isNotEmpty((Object)tmpStorageVO.getProjectId())) {
            updateEntity.setProjectId(Long.valueOf(Long.parseLong(tmpStorageVO.getProjectId())));
        }
        updateEntity.setProjectName(tmpStorageVO.getProjectName());
        if (StrUtil.isNotBlank((CharSequence)tmpStorageVO.getCity())) {
            String[] citys = tmpStorageVO.getCity().split("-");
            updateEntity.setProvince(citys[0]);
            updateEntity.setCity(citys[1]);
        }
        if (StrUtil.isNotBlank((CharSequence)tmpStorageVO.getBusinessManagerId())) {
            updateEntity.setBusinessManagerId(Long.valueOf(Long.parseLong(tmpStorageVO.getBusinessManagerId())));
        }
        updateEntity.setBusinessManagerName(tmpStorageVO.getBusinessManagerName());
        if (ObjectUtil.isNotEmpty((Object)tmpStorageVO.getReportInstallTime())) {
            updateEntity.setReportInstallTime(LocalDate.parse(tmpStorageVO.getReportInstallTime()));
        }
        updateEntity.setUserName(tmpStorageVO.getUserName());
        updateEntity.setUserRoomNo(tmpStorageVO.getUserRoomNo());
        updateEntity.setUserPhoneNumber(tmpStorageVO.getUserPhoneNumber());
        updateEntity.setIsUrgent(tmpStorageVO.getIsUrgent());
        if (ObjectUtil.isNotEmpty((Object)tmpStorageVO.getExpectedVisitTime())) {
            updateEntity.setExpectedVisitTime(LocalTime.parse(tmpStorageVO.getExpectedVisitTime()));
        }
        updateEntity.setIsInstall(tmpStorageVO.getIsInstall());
        if (ObjectUtil.isNotEmpty((Object)tmpStorageVO.getUserLeaseBeginTime())) {
            updateEntity.setUserLeaseBeginTime(LocalDate.parse(tmpStorageVO.getUserLeaseBeginTime()));
        }
        if (ObjectUtil.isNotEmpty((Object)tmpStorageVO.getUserLeaseEndTime())) {
            updateEntity.setUserLeaseEndTime(LocalDate.parse(tmpStorageVO.getUserLeaseEndTime()));
        }
        updateEntity.setStatus(tmpStorageVO.getStatus());
        updateEntity.setCustomerTime(tmpStorageVO.getCustomerTime());
        updateEntity.setUserLeaseTerm(tmpStorageVO.getUserLeaseTerm());
        updateEntity.setInstallAddress(tmpStorageVO.getInstallAddress());
        updateEntity.setUserNote(tmpStorageVO.getUserNote());
        updateEntity.setUserBroadbandAccount(tmpStorageVO.getUserBroadbandAccount());
        updateEntity.setIsActivateOuterNet(tmpStorageVO.getIsActivateOuterNet());
        if (ObjectUtil.isNotEmpty((Object)tmpStorageVO.getOrderTakerId())) {
            updateEntity.setOrderTakerId(Long.valueOf(Long.parseLong(tmpStorageVO.getOrderTakerId())));
        }
        updateEntity.setOrderTakerName(tmpStorageVO.getOrderTakerName());
        updateEntity.setOrderTakerIdString(tmpStorageVO.getOrderTakerIdString());
        updateEntity.setOrderTakerPhoneNumber(tmpStorageVO.getOrderTakerPhoneNumber());
        updateEntity.setInstallerType(tmpStorageVO.getInstallerType());
        updateEntity.setInstallerIdString(tmpStorageVO.getInstallerIdString());
        if (ObjectUtil.isNotEmpty((Object)tmpStorageVO.getInstallerId())) {
            updateEntity.setInstallerId(Long.valueOf(Long.parseLong(tmpStorageVO.getInstallerId())));
        }
        updateEntity.setInstallerName(tmpStorageVO.getProjectName());
        updateEntity.setInstallerPhoneNumber(tmpStorageVO.getInstallerPhoneNumber());
        if (ObjectUtil.isNotEmpty((Object)tmpStorageVO.getInstallFinishTime())) {
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.CHINA);
            updateEntity.setInstallFinishTime(LocalDateTime.parse(tmpStorageVO.getInstallFinishTime(), formatter));
        }
        updateEntity.setActualInstallDescription(tmpStorageVO.getActualInstallDescription());
        updateEntity.setNote(tmpStorageVO.getNote());
        this.updateById((Object)updateEntity);
    }

    public PageResultVo<AppletWorkOrderVO> historyWorkOrder(String projectId, PageReqParam pageReqParam) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerServiceOpenNetworkWorkOrder::getProjectId, (Object)Long.parseLong(projectId))).eq(CustomerServiceOpenNetworkWorkOrder::getWorkOrderType, (Object)OpenNetworkWorkOrderType.APPLY.getCode())).orderByDesc(CustomerServiceOpenNetworkWorkOrder::getCreateTime);
        Page page = new Page((long)pageReqParam.getPageNum(), (long)pageReqParam.getPageSize());
        this.page((IPage)page, (Wrapper)wrapper);
        ArrayList resultList = new ArrayList();
        page.getRecords().forEach(r -> {
            AppletWorkOrderVO openNetworkWorkOrderVO = new AppletWorkOrderVO();
            BeanUtil.copyProperties((Object)r, (Object)openNetworkWorkOrderVO, (String[])new String[0]);
            if (StrUtil.isNotBlank((CharSequence)r.getProvince()) && StrUtil.isNotBlank((CharSequence)r.getCity())) {
                openNetworkWorkOrderVO.setCity(r.getProvince() + "-" + r.getCity());
            }
            resultList.add(openNetworkWorkOrderVO);
        });
        return new PageResultVo(page, resultList);
    }

    public void selfServiceFilling(SelfServiceFillingVO fillingVO) {
        CustomerServiceOpenNetworkWorkOrder workOrder = new CustomerServiceOpenNetworkWorkOrder();
        BeanUtil.copyProperties((Object)fillingVO, (Object)workOrder, (String[])new String[0]);
        if (StrUtil.isNotBlank((CharSequence)fillingVO.getCity())) {
            String[] citys = fillingVO.getCity().split("-");
            workOrder.setProvince(citys[0]);
            workOrder.setCity(citys[1]);
            workOrder.setSerialNumber(SerialNumberUtil.generate((String)"YY%s%s%s%s%s", (String)"KWGD", (String)citys[1]));
        }
        workOrder.setIsInstall(Integer.valueOf(1));
        workOrder.setWorkOrderType(OpenNetworkWorkOrderType.APPLY.getCode());
        workOrder.setWorkOrderStatus(OpenNetworkWorkOrderStatus.AWAITING_SUBMIT.getCode());
        if (StrUtil.isNotBlank((CharSequence)fillingVO.getUserLeaseBeginTime()) && StrUtil.isNotBlank((CharSequence)fillingVO.getUserLeaseEndTime())) {
            workOrder.setUserLeaseTerm(Integer.valueOf((int)DateUtil.between((Date)DateUtil.parse((CharSequence)fillingVO.getUserLeaseBeginTime()), (Date)DateUtil.parse((CharSequence)fillingVO.getUserLeaseEndTime()), (DateUnit)DateUnit.DAY)));
        }
        this.save((Object)workOrder);
        this.processStart(workOrder, "/backend/#/approve/Networkworkflowapprove");
    }

    public AppletWorkOrderInfoVO appletInfo(String id) {
        CustomerServiceOpenNetworkWorkOrder workOrder = this.findById(id);
        AppletWorkOrderInfoVO info = new AppletWorkOrderInfoVO();
        BeanUtil.copyProperties((Object)workOrder, (Object)info, (String[])new String[0]);
        info.setCreateTime(DateUtil.formatLocalDateTime((LocalDateTime)workOrder.getCreateTime()));
        info.setInstallFinishTime(DateUtil.formatLocalDateTime((LocalDateTime)workOrder.getInstallFinishTime()));
        info.setCity(workOrder.getProvince() + "-" + workOrder.getCity());
        return info;
    }
}

