/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ruoyi.common.security.utils.SecurityUtils;
import com.ruoyi.constant.FeedbackStatus;
import com.ruoyi.entity.CustomerServiceOpinionReply;
import com.ruoyi.entity.CustomerServiceOpinionReplyFile;
import com.ruoyi.mapper.CustomerServiceOpinionReplyFileMapper;
import com.ruoyi.mapper.CustomerServiceOpinionReplyMapper;
import com.ruoyi.query.AppletOpinionReplyQuery;
import com.ruoyi.query.OpinionReplyQuery;
import com.ruoyi.service.CustomerServiceOpinionReplyService;
import com.ruoyi.util.DictUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.util.SerialNumberUtil;
import com.ruoyi.vo.opinionreply.AppletOpinionReplyVO;
import com.ruoyi.vo.opinionreply.CustomerServiceReplyVO;
import com.ruoyi.vo.opinionreply.FeedbackVO;
import com.ruoyi.vo.opinionreply.OpinionReplyExportVO;
import com.ruoyi.vo.opinionreply.OpinionReplyInfoVO;
import com.ruoyi.vo.opinionreply.OpinionReplyVO;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CustomerServiceOpinionReplyServiceImpl
extends ServiceImpl<CustomerServiceOpinionReplyMapper, CustomerServiceOpinionReply>
implements CustomerServiceOpinionReplyService {
    @Autowired
    private CustomerServiceOpinionReplyFileMapper customerServiceOpinionReplyFileMapper;

    public void feedback(FeedbackVO feedbackVO) {
        CustomerServiceOpinionReply opinionReply = new CustomerServiceOpinionReply();
        if (ObjectUtil.isNotEmpty((Object)feedbackVO.getProjectId())) {
            opinionReply.setProjectId(Long.valueOf(Long.parseLong(feedbackVO.getProjectId())));
        }
        opinionReply.setProjectName(feedbackVO.getProjectName());
        opinionReply.setReplyType(feedbackVO.getReplyType());
        opinionReply.setComplaintOpinion(feedbackVO.getOpinion());
        opinionReply.setPhone(feedbackVO.getPhone());
        if (StrUtil.isNotBlank((CharSequence)feedbackVO.getCity())) {
            String[] citys = feedbackVO.getCity().split("-");
            if (citys.length > 1) {
                opinionReply.setProvince(citys[0]);
                opinionReply.setCity(citys[1]);
            } else if (citys.length == 1) {
                opinionReply.setCity(citys[0]);
            }
            opinionReply.setSerialNumber(SerialNumberUtil.generate((String)"YY%s%s%s%s%s", (String)"YJFK", (String)feedbackVO.getCity()));
        }
        opinionReply.setStatus(FeedbackStatus.INIT.getCode());
        opinionReply.setCreateId(SecurityUtils.getLoginUser().getUserid());
        opinionReply.setCreateName(SecurityUtils.getLoginUser().getUsername());
        opinionReply.setCreateTime(LocalDateTime.now());
        this.save((Object)opinionReply);
        this.saveFile(feedbackVO.getFilePaths(), opinionReply.getId());
    }

    private void saveFile(List<String> filePaths, Long opinionId) {
        if (CollUtil.isNotEmpty(filePaths)) {
            ArrayList files = new ArrayList();
            filePaths.forEach(path -> {
                CustomerServiceOpinionReplyFile file = new CustomerServiceOpinionReplyFile();
                file.setId(Long.valueOf(IdWorker.getId((Object)file)));
                file.setOpinionId(opinionId);
                file.setFilePath(path);
                file.setIsDelete(Integer.valueOf(0));
                files.add(file);
            });
            this.customerServiceOpinionReplyFileMapper.saveBatch(files);
        }
    }

    private LambdaQueryWrapper<CustomerServiceOpinionReply> getLambdaQueryWrapperByOpinionReplyQuery(OpinionReplyQuery query) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (StrUtil.isNotBlank((CharSequence)query.getSerialNumber())) {
            wrapper.like(CustomerServiceOpinionReply::getSerialNumber, (Object)query.getSerialNumber());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getProjectId())) {
            wrapper.eq(CustomerServiceOpinionReply::getProjectId, (Object)Long.parseLong(query.getProjectId()));
        }
        if (null != query.getReplyType()) {
            wrapper.eq(CustomerServiceOpinionReply::getReplyType, (Object)query.getReplyType());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getFeedbackUser())) {
            wrapper.like(CustomerServiceOpinionReply::getCreateName, (Object)query.getFeedbackUser());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getFeedbackBeginTime())) {
            wrapper.ge(CustomerServiceOpinionReply::getCreateTime, (Object)(query.getFeedbackBeginTime() + " 00:00:00"));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getFeedbackEndTime())) {
            wrapper.le(CustomerServiceOpinionReply::getCreateTime, (Object)(query.getFeedbackEndTime() + " 23:59:59"));
        }
        wrapper.orderByDesc(CustomerServiceOpinionReply::getCreateTime);
        return wrapper;
    }

    public PageResultVo<OpinionReplyVO> pageList(OpinionReplyQuery query) {
        LambdaQueryWrapper wrapper = this.getLambdaQueryWrapperByOpinionReplyQuery(query);
        Page page = new Page((long)query.getPageNum(), (long)query.getPageSize());
        this.page((IPage)page, (Wrapper)wrapper);
        ArrayList resultList = new ArrayList();
        page.getRecords().forEach(r -> {
            OpinionReplyVO opinionReplyVO = new OpinionReplyVO();
            BeanUtil.copyProperties((Object)r, (Object)opinionReplyVO, (String[])new String[0]);
            opinionReplyVO.setCreateTime(DateUtil.formatLocalDateTime((LocalDateTime)r.getCreateTime()));
            resultList.add(opinionReplyVO);
        });
        return new PageResultVo(page, resultList);
    }

    public PageResultVo<AppletOpinionReplyVO> pageList(AppletOpinionReplyQuery query) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (null != query.getReplyType()) {
            wrapper.eq(CustomerServiceOpinionReply::getReplyType, (Object)query.getReplyType());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getKey())) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.like(CustomerServiceOpinionReply::getProjectName, (Object)query.getKey())).or()).like(CustomerServiceOpinionReply::getProjectCode, (Object)query.getKey());
        }
        if (StrUtil.isNotBlank((CharSequence)query.getCity())) {
            String[] citys = query.getCity().split("-");
            wrapper.eq(CustomerServiceOpinionReply::getProvince, (Object)citys[0]);
            wrapper.eq(CustomerServiceOpinionReply::getCity, (Object)citys[1]);
        }
        wrapper.eq(CustomerServiceOpinionReply::getCreateId, (Object)SecurityUtils.getUserId());
        Page page = new Page((long)query.getPageNum(), (long)query.getPageSize());
        this.page((IPage)page, (Wrapper)wrapper);
        ArrayList resultList = new ArrayList();
        page.getRecords().forEach(r -> {
            AppletOpinionReplyVO opinionReplyVO = new AppletOpinionReplyVO();
            BeanUtil.copyProperties((Object)r, (Object)opinionReplyVO, (String[])new String[0]);
            opinionReplyVO.setCreateTime(DateUtil.formatLocalDateTime((LocalDateTime)r.getCreateTime()));
            opinionReplyVO.setStatus(0 == r.getStatus() ? "\u5f85\u56de\u590d" : "\u5df2\u56de\u590d");
            if (null != r.getUpdateId()) {
                opinionReplyVO.setCustomerServiceId(r.getUpdateId() + "");
            }
            opinionReplyVO.setCustomerServiceName(r.getUpdateName());
            opinionReplyVO.setCustomerServiceReplyTime(DateUtil.formatLocalDateTime((LocalDateTime)r.getUpdateTime()));
            resultList.add(opinionReplyVO);
        });
        return new PageResultVo(page, resultList);
    }

    public OpinionReplyInfoVO info(String id) {
        CustomerServiceOpinionReply opinionReply = (CustomerServiceOpinionReply)this.getById((Serializable)Long.valueOf(Long.parseLong(id)));
        if (null == opinionReply) {
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
        OpinionReplyInfoVO info = new OpinionReplyInfoVO();
        BeanUtil.copyProperties((Object)opinionReply, (Object)info, (String[])new String[0]);
        info.setCreateTime(DateUtil.formatLocalDateTime((LocalDateTime)opinionReply.getCreateTime()));
        if (null != opinionReply.getUpdateTime()) {
            info.setUpdateTime(DateUtil.formatLocalDateTime((LocalDateTime)opinionReply.getUpdateTime()));
        }
        List files = this.customerServiceOpinionReplyFileMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(CustomerServiceOpinionReplyFile::getOpinionId, (Object)Long.parseLong(id))).eq(CustomerServiceOpinionReplyFile::getIsDelete, (Object)0)).orderByAsc(CustomerServiceOpinionReplyFile::getId));
        info.setFilePaths(files.stream().map(CustomerServiceOpinionReplyFile::getFilePath).collect(Collectors.toList()));
        return info;
    }

    public void reply(CustomerServiceReplyVO replyVO) {
        CustomerServiceOpinionReply opinionReply = (CustomerServiceOpinionReply)this.getById((Serializable)Long.valueOf(Long.parseLong(replyVO.getId())));
        if (null == opinionReply) {
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
        CustomerServiceOpinionReply editEntity = new CustomerServiceOpinionReply();
        editEntity.setId(opinionReply.getId());
        editEntity.setCustomerServiceReply(replyVO.getReply());
        editEntity.setUpdateId(SecurityUtils.getLoginUser().getUserid());
        editEntity.setUpdateName(SecurityUtils.getLoginUser().getUsername());
        editEntity.setUpdateTime(LocalDateTime.now());
        editEntity.setStatus(FeedbackStatus.REPLIED.getCode());
        this.updateById((Object)editEntity);
    }

    public List<OpinionReplyExportVO> exportList(OpinionReplyQuery query) {
        List list = this.list((Wrapper)this.getLambdaQueryWrapperByOpinionReplyQuery(query));
        Map dictMap = DictUtil.getDictMap((String)"helpdesk_opinion_reply_type");
        List<OpinionReplyExportVO> result = list.stream().map(l -> {
            OpinionReplyExportVO exportVO = new OpinionReplyExportVO();
            BeanUtil.copyProperties((Object)l, (Object)exportVO, (String[])new String[0]);
            exportVO.setReplyType(String.valueOf(dictMap.get(l.getReplyType())));
            exportVO.setStatus(FeedbackStatus.getNameByCode((Integer)l.getStatus()));
            exportVO.setCreateTime(DateUtil.formatLocalDateTime((LocalDateTime)l.getCreateTime()));
            return exportVO;
        }).collect(Collectors.toList());
        return result;
    }
}

