/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.workflow.service.impl;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONObject;
import com.ruoyi.constant.ProcessStatus;
import com.ruoyi.constant.RepairWorkOrderProcessNode;
import com.ruoyi.constant.RepairWorkOrderStatus;
import com.ruoyi.entity.CustomerServiceRepairWorkOrder;
import com.ruoyi.service.CustomerServiceRepairWorkOrderService;
import com.ruoyi.workflow.service.WorkFlowCallbackService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="process_doe86kdo")
public class RepairWorkOrderCallbackService
implements WorkFlowCallbackService {
    private static final Logger log = LoggerFactory.getLogger(RepairWorkOrderCallbackService.class);
    @Autowired
    private CustomerServiceRepairWorkOrderService repairWorkOrderService;

    public void callback(JSONObject data) {
        log.info("\u7ef4\u4fee\u5de5\u5355\u56de\u8c03=\u300b{}", (Object)data);
        String event = data.getString("event");
        JSONObject body = data.getJSONObject("body");
        String businessKey = body.getString("businessKey");
        if ("PROCESS_STARTED".equals(event)) {
            CustomerServiceRepairWorkOrder workOrder = this.repairWorkOrderService.findById(businessKey);
            workOrder.setProcessStatus(ProcessStatus.AWAITING_REVIEW.getCode());
            this.repairWorkOrderService.updateById((Object)workOrder);
        } else if ("PROCESS_COMPLETED".equals(event)) {
            CustomerServiceRepairWorkOrder workOrder = this.repairWorkOrderService.findById(businessKey);
            workOrder.setProcessStatus(ProcessStatus.FINISHED.getCode());
            workOrder.setWorkOrderStatus(RepairWorkOrderStatus.FINISHED.getCode());
            this.repairWorkOrderService.updateById((Object)workOrder);
        } else if ("TASK_CREATED".equals(event)) {
            Integer workFlowProcessNode = RepairWorkOrderProcessNode.getCodeByName((String)body.getString("taskDefinitionKey"));
            CustomerServiceRepairWorkOrder workOrder = this.repairWorkOrderService.findById(businessKey);
            workOrder.setProcessNode(workFlowProcessNode);
            if (RepairWorkOrderProcessNode.FILL_OUT_WORK_ORDER.getCode() == workFlowProcessNode && workOrder.getProcessStatus() == ProcessStatus.REJECTED.getCode()) {
                workOrder.setWorkOrderStatus(RepairWorkOrderStatus.REJECTED.getCode());
            }
            this.repairWorkOrderService.updateById((Object)workOrder);
        } else if ("TASK_COMPLETED".equals(event)) {
            JSONObject taskVariables = body.getJSONObject("taskVariables");
            if (null != taskVariables && !taskVariables.isEmpty() && taskVariables.getIntValue("approveStatus") == 2) {
                CustomerServiceRepairWorkOrder workOrder = this.repairWorkOrderService.findById(businessKey);
                workOrder.setProcessStatus(ProcessStatus.REJECTED.getCode());
                this.repairWorkOrderService.updateById((Object)workOrder);
            } else {
                JSONObject formData = body.getJSONObject("processVariables").getJSONObject("formData");
                CustomerServiceRepairWorkOrder workOrder = this.repairWorkOrderService.findById(businessKey);
                if (null != formData && !formData.isEmpty()) {
                    BeanUtil.copyProperties((Object)formData, (Object)workOrder, (String[])new String[0]);
                }
                Integer workFlowProcessNode = RepairWorkOrderProcessNode.getCodeByName((String)body.getString("taskDefinitionKey"));
                if (RepairWorkOrderProcessNode.CUSTOMER_SERVICE_DEPT.getCode() == workFlowProcessNode) {
                    workOrder.setWorkOrderStatus(RepairWorkOrderStatus.FINISHED.getCode());
                    workOrder.setProcessNode(RepairWorkOrderProcessNode.END.getCode());
                } else if (RepairWorkOrderProcessNode.TECHNICAL_DEPT.getCode() == workFlowProcessNode) {
                    workOrder.setWorkOrderStatus(RepairWorkOrderStatus.IN_REPAIR.getCode());
                } else if (RepairWorkOrderProcessNode.FILL_OUT_WORK_ORDER.getCode() == workFlowProcessNode) {
                    workOrder.setWorkOrderStatus(RepairWorkOrderStatus.AWAITING_REVIEW.getCode());
                }
                workOrder.setProcessStatus(ProcessStatus.AWAITING_REVIEW.getCode());
                this.repairWorkOrderService.updateById((Object)workOrder);
            }
        }
    }
}

