/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.workflow.service.impl;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ruoyi.client.WorkFlowClient;
import com.ruoyi.workflow.service.WorkFlowService;
import com.ruoyi.workflow.vo.ApproveTaskVO;
import com.ruoyi.workflow.vo.ProcessStartVO;
import com.ruoyi.workflow.vo.PushTaskVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WorkFlowServiceImpl
implements WorkFlowService {
    private static final Logger log = LoggerFactory.getLogger(WorkFlowServiceImpl.class);
    @Autowired
    private WorkFlowClient workFlowClient;

    public String start(ProcessStartVO processStartVO) {
        try {
            log.info("WorkFlowServiceImpl-startProcess:Parameter:{}", (Object)processStartVO);
            JSONObject resultJsonObj = this.workFlowClient.start(processStartVO);
            log.info("WorkFlowServiceImpl-startProcess:Result:{}", (Object)resultJsonObj);
            int code = resultJsonObj.getIntValue("code");
            if (code == 0) {
                String processInstanceId = resultJsonObj.getJSONObject("data").getString("id");
                return processInstanceId;
            }
        }
        catch (Exception e) {
            log.error("An error occurred", (Throwable)e);
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
        return null;
    }

    public void pickup(String candidateUser, String processInstanceId) {
        try {
            String taskId = this.getCurrentTask(processInstanceId);
            JSONObject requestObj = new JSONObject();
            requestObj.put("candidateUser", (Object)candidateUser);
            requestObj.put("taskId", (Object)taskId);
            log.info("WorkFlowServiceImpl-pickup:Parameter:{}", (Object)requestObj);
            JSONObject resultJsonObj = this.workFlowClient.pickUp(requestObj);
            log.info("WorkFlowServiceImpl-pickup:Result:{}", (Object)resultJsonObj);
            int code = resultJsonObj.getIntValue("code");
            if (code != 0) {
                throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
            }
        }
        catch (Exception e) {
            log.error("An error occurred", (Throwable)e);
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
    }

    public String getCurrentTask(String processInstanceId) {
        try {
            log.info("WorkFlowServiceImpl-getCurrentTask:Parameter:{}", (Object)processInstanceId);
            JSONObject resultJsonObj = this.workFlowClient.getCurrentTask(processInstanceId);
            log.info("WorkFlowServiceImpl-getCurrentTask:Result:{}", (Object)resultJsonObj);
            int code = resultJsonObj.getIntValue("code");
            if (code == 0) {
                String taskId = resultJsonObj.getJSONObject("data").getString("taskId");
                if (StrUtil.isBlank((CharSequence)taskId)) {
                    log.error("\u83b7\u53d6\u5f53\u524d\u4efb\u52a1\u5931\u8d25=\u300b processInstanceId:{}", (Object)processInstanceId);
                    throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
                }
                return taskId;
            }
        }
        catch (Exception e) {
            log.error("An error occurred", (Throwable)e);
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
        log.error("\u83b7\u53d6\u5f53\u524d\u4efb\u52a1\u5931\u8d25=\u300b processInstanceId:{}", (Object)processInstanceId);
        throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
    }

    public void approveTask(ApproveTaskVO approveTaskVO) {
        try {
            String taskId = this.getCurrentTask(approveTaskVO.getProcessInstanceId());
            JSONObject requestObj = new JSONObject();
            requestObj.put("assignee", (Object)approveTaskVO.getAssignee());
            requestObj.put("businessStatus", (Object)approveTaskVO.getBusinessStatus());
            requestObj.put("comment", (Object)(StrUtil.isNotBlank((CharSequence)approveTaskVO.getComment()) ? approveTaskVO.getComment() : ""));
            requestObj.put("taskId", (Object)taskId);
            requestObj.put("isCondition", (Object)approveTaskVO.isCondition());
            log.info("WorkFlowServiceImpl-approveTask:Parameter:{}", (Object)requestObj);
            JSONObject resultJsonObj = this.workFlowClient.approveTask(requestObj);
            log.info("WorkFlowServiceImpl-approveTask:Result:{}", (Object)resultJsonObj);
            int code = resultJsonObj.getIntValue("code");
            if (code != 0) {
                throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
            }
        }
        catch (Exception e) {
            log.error("An error occurred", (Throwable)e);
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
    }

    public List<Map<String, String>> getHistoricActivity(String processInstanceId) {
        try {
            log.info("WorkFlowServiceImpl-getHistoricActivity:Parameter:{}", (Object)processInstanceId);
            JSONObject resultJsonObj = this.workFlowClient.getHistoricActivity(processInstanceId);
            log.info("WorkFlowServiceImpl-getHistoricActivity:Result:{}", (Object)resultJsonObj);
            int code = resultJsonObj.getIntValue("code");
            if (code == 0) {
                JSONArray resultJsonArray = resultJsonObj.getJSONArray("data");
                ArrayList<Map<String, String>> returnResult = new ArrayList<Map<String, String>>();
                for (Object obj : resultJsonArray) {
                    Map dataMap = (Map)obj;
                    HashMap map = new HashMap();
                    map.put("activityId", dataMap.get("activityId"));
                    map.put("activityName", dataMap.get("activityName"));
                    returnResult.add(map);
                }
                return returnResult;
            }
        }
        catch (Exception e) {
            log.error("An error occurred", (Throwable)e);
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
        return null;
    }

    public List<String> getMyTask() {
        try {
            JSONObject requetData = new JSONObject();
            requetData.put("page", (Object)1);
            requetData.put("limit", (Object)Integer.MAX_VALUE);
            log.info("WorkFlowServiceImpl-getMyTask:Parameter:{}", (Object)requetData);
            JSONObject resultJsonObj = this.workFlowClient.undoTaskPage(requetData);
            log.info("WorkFlowServiceImpl-getMyTask:Result:{}", (Object)resultJsonObj);
            int code = resultJsonObj.getIntValue("code");
            if (code == 0) {
                JSONArray resultList = resultJsonObj.getJSONObject("data").getJSONArray("list");
                List<String> myTasks = resultList.stream().map(a -> (String)((Map)a).get("processInstanceId")).collect(Collectors.toList());
                return myTasks;
            }
        }
        catch (Exception e) {
            log.error("An error occurred", (Throwable)e);
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
        return null;
    }

    public void jump(String processInstanceId, String node) {
        try {
            String taskId = this.getCurrentTask(processInstanceId);
            log.info("WorkFlowServiceImpl-jump:Parameter:{},{}", (Object)taskId, (Object)node);
            JSONObject resultJsonObj = this.workFlowClient.jump(taskId, node);
            log.info("WorkFlowServiceImpl-jump:Result:{}", (Object)resultJsonObj);
            int code = resultJsonObj.getIntValue("code");
            if (code != 0) {
                throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
            }
        }
        catch (Exception e) {
            log.error("An error occurred", (Throwable)e);
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
    }

    public void pushTask(PushTaskVO pushTaskVO) {
        try {
            log.info("WorkFlowServiceImpl-pushTask:Parameter:{}", (Object)pushTaskVO);
            JSONObject resultJsonObj = this.workFlowClient.pushTask(pushTaskVO);
            log.info("WorkFlowServiceImpl-pushTask:Result:{}", (Object)resultJsonObj);
            int code = resultJsonObj.getIntValue("code");
            if (code != 0) {
                throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
            }
        }
        catch (Exception e) {
            log.error("An error occurred", (Throwable)e);
            throw new RuntimeException("\u7cfb\u7edf\u5f02\u5e38");
        }
    }
}

