/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.construction;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.api.R;
import com.ruoyi.dto.construction.ProjectAcceptanceCheckDTO;
import com.ruoyi.query.construction.ProjectAcceptanceCheckQuery;
import com.ruoyi.service.construction.ProjectAcceptanceCheckService;
import com.ruoyi.service.workFlow.WorkFlowCallBackVO;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.vo.construction.ProjectAcceptanceCheckDetailsVO;
import com.ruoyi.vo.construction.ProjectAcceptanceCheckExportVO;
import com.ruoyi.vo.construction.ProjectAcceptanceCheckPageVO;
import com.ruoyi.vo.construction.ProjectAcceptanceInventoryVO;
import com.ruoyi.vo.construction.ProjectAcceptanceScoreVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u7ae3\u5de5\u9a8c\u6536", tags={"\u7ae3\u5de5\u9a8c\u6536"})
@RequestMapping(value={"/acceptanceCheck"})
@RestController
public class ProjectAcceptanceCheckController {
    private static final Logger log = LoggerFactory.getLogger(ProjectAcceptanceCheckController.class);
    @Resource
    private ProjectAcceptanceCheckService projectAcceptanceCheckService;

    @PostMapping(value={"/getPage"})
    @ApiOperation(value="\u7ae3\u5de5\u9a8c\u6536\u5217\u8868\u9875\u9762")
    public R<PageResultVo<ProjectAcceptanceCheckPageVO>> getPage(@RequestBody ProjectAcceptanceCheckQuery projectAcceptanceCheckQuery) {
        try {
            PageResultVo contractDTOListPage = this.projectAcceptanceCheckService.getAcceptanceCheckListPage(projectAcceptanceCheckQuery);
            return R.ok((Object)contractDTOListPage);
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51fa\u7ae3\u5de5\u9a8c\u6536")
    public void export(@RequestBody ProjectAcceptanceCheckQuery projectAcceptanceCheckQuery, HttpServletResponse response) {
        try {
            List contractProjectList = this.projectAcceptanceCheckService.getAcceptanceCheckList(projectAcceptanceCheckQuery);
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u7ae3\u5de5\u9a8c\u6536", "\u7ae3\u5de5\u9a8c\u6536", ExcelType.XSSF), ProjectAcceptanceCheckExportVO.class, (Collection)contractProjectList);
            ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)"\u7ae3\u5de5\u9a8c\u6536");
        }
        catch (IOException e) {
            e.printStackTrace();
            log.warn("\u5bfc\u51fa\u5931\u8d25 error:{}", (Object)e.getMessage());
        }
    }

    @GetMapping(value={"getById"})
    @ApiOperation(value="\u7ae3\u5de5\u9a8c\u6536-\u8be6\u60c5")
    public R<ProjectAcceptanceCheckDetailsVO> getById(Long id) {
        try {
            ProjectAcceptanceCheckDetailsVO detailVo = this.projectAcceptanceCheckService.getAcceptanceCheckDTOById(id);
            return R.ok((Object)detailVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"getInventoryVO"})
    @ApiOperation(value="\u7ae3\u5de5\u9a8c\u6536-\u83b7\u53d6\u7ae3\u5de5\u76d8\u70b9")
    public R<List<ProjectAcceptanceInventoryVO>> getInventoryVO(String projectCode) {
        try {
            return R.ok((Object)this.projectAcceptanceCheckService.getInventoryVO(projectCode));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u521b\u5efa\u7ae3\u5de5\u9a8c\u6536")
    public R<Boolean> create(@RequestBody ProjectAcceptanceCheckDTO projectAcceptanceCheckDTO) {
        try {
            return R.ok((Object)this.projectAcceptanceCheckService.createAcceptanceCheck(projectAcceptanceCheckDTO));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u7ae3\u5de5\u9a8c\u6536\u4fe1\u606f")
    public R<Boolean> update(@RequestBody ProjectAcceptanceCheckDTO projectAcceptanceCheckDTO) {
        try {
            return R.ok((Object)this.projectAcceptanceCheckService.updateAcceptanceCheck(projectAcceptanceCheckDTO));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    @ApiOperation(value="\u7ae3\u5de5\u9a8c\u6536\u4fe1\u606f-\u5220\u9664")
    public R<Boolean> delete(@PathVariable(value="id") Long id) {
        try {
            return R.ok((Object)this.projectAcceptanceCheckService.deleteAcceptanceCheck(id));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/callBackUpdate"})
    @ApiOperation(value="\u7ae3\u5de5\u9a8c\u6536\u5217\u6570\u636e-\u5de5\u4f5c\u6d41\u7a0b\u4fee\u6539\u6570\u636e")
    public R<Boolean> callBackUpdate(@RequestBody ProjectAcceptanceCheckDTO projectAcceptanceCheckDTO) {
        try {
            return R.ok((Object)this.projectAcceptanceCheckService.callBackUpdate(projectAcceptanceCheckDTO));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/setProcessVariables"})
    @ApiOperation(value="\u7ae3\u5de5\u9a8c\u6536\u5217\u6570\u636e-\u662f\u5426\u6574\u6539-\u4fee\u6539\u7f51\u5173\u72b6\u6001")
    public R<String> setProcessVariables(@RequestParam(value="processInstanceId") String processInstanceId, @RequestBody Map<String, Object> map) {
        try {
            JSONObject jsonObject1 = this.projectAcceptanceCheckService.setProcessVariables(processInstanceId, map);
            return R.ok((Object)"\u6210\u529f");
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/callBack"})
    @ApiOperation(value="\u7ae3\u5de5\u9a8c\u6536\u5217\u6570\u636e-\u5de5\u4f5c\u6d41\u56de\u8c03")
    public R<String> callBack(@RequestBody WorkFlowCallBackVO callBackVO) {
        try {
            this.projectAcceptanceCheckService.callBack(callBackVO);
            return R.ok((Object)"success");
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @GetMapping(value={"getScoreModel"})
    @ApiOperation(value="\u83b7\u53d6-\u8003\u6838\u8bc4\u5206\u8868-\u6a21\u7248")
    public R<List<ProjectAcceptanceScoreVO>> getScoreModel() {
        try {
            List list = this.projectAcceptanceCheckService.getScoreModel();
            return R.ok((Object)list);
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.failed((String)e.getLocalizedMessage());
        }
    }
}

