/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.construction;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.baomidou.mybatisplus.extension.api.R;
import com.ruoyi.dto.construction.ProjectProgrammeDTO;
import com.ruoyi.query.construction.ProjectProgrammeQuery;
import com.ruoyi.service.construction.ProjectProgrammeService;
import com.ruoyi.service.workFlow.WorkFlowCallBackVO;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.vo.construction.ProjectProgrammeDetailsVO;
import com.ruoyi.vo.construction.ProjectProgrammeExportVO;
import com.ruoyi.vo.construction.ProjectProgrammePageVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u6280\u672f\u65b9\u6848", tags={"\u6280\u672f\u65b9\u6848"})
@RequestMapping(value={"/projectProgramme"})
@RestController
public class ProjectProgrammeController {
    private static final Logger log = LoggerFactory.getLogger(ProjectProgrammeController.class);
    @Resource
    private ProjectProgrammeService projectProgrammeService;

    @PostMapping(value={"/getPage"})
    @ApiOperation(value="\u6280\u672f\u65b9\u6848\u5217\u8868\u9875\u9762")
    public R<PageResultVo<ProjectProgrammePageVO>> getPage(@RequestBody ProjectProgrammeQuery projectProgrammeQuery) {
        try {
            PageResultVo contractDTOListPage = this.projectProgrammeService.getProjectProgrammeListPage(projectProgrammeQuery);
            return R.ok((Object)contractDTOListPage);
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51fa\u6280\u672f\u65b9\u6848")
    public void export(@RequestBody ProjectProgrammeQuery projectProgrammeQuery, HttpServletResponse response) {
        try {
            List contractProjectList = this.projectProgrammeService.getProjectProgrammeList(projectProgrammeQuery);
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u6280\u672f\u65b9\u6848", "\u6280\u672f\u65b9\u6848", ExcelType.XSSF), ProjectProgrammeExportVO.class, (Collection)contractProjectList);
            ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)"\u6280\u672f\u65b9\u6848");
        }
        catch (IOException e) {
            e.printStackTrace();
            log.warn("\u5bfc\u51fa\u5931\u8d25 error:{}", (Object)e.getMessage());
        }
    }

    @GetMapping(value={"getById"})
    @ApiOperation(value="\u6280\u672f\u65b9\u6848-\u8be6\u60c5")
    public R<ProjectProgrammeDetailsVO> getById(Long id) {
        try {
            ProjectProgrammeDetailsVO detailVo = this.projectProgrammeService.getProjectProgrammeById(id);
            return R.ok((Object)detailVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u521b\u5efa\u6280\u672f\u65b9\u6848")
    public R<Boolean> create(@RequestBody ProjectProgrammeDTO projectProgrammeDTO) {
        try {
            return R.ok((Object)this.projectProgrammeService.createProjectProgramme(projectProgrammeDTO));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u6280\u672f\u65b9\u6848")
    public R<Boolean> update(@RequestBody ProjectProgrammeDTO projectProgrammeDTO) {
        try {
            return R.ok((Object)this.projectProgrammeService.updateProjectProgramme(projectProgrammeDTO));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    @ApiOperation(value="\u6280\u672f\u65b9\u6848-\u5220\u9664")
    public R<Boolean> delete(@PathVariable(value="id") Long id) {
        try {
            return R.ok((Object)this.projectProgrammeService.deleteProjectProgramme(id));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/callBackUpdate"})
    @ApiOperation(value="\u6280\u672f\u65b9\u6848-\u5de5\u4f5c\u6d41\u7a0b\u4fee\u6539\u6570\u636e")
    public R<Boolean> callBackUpdate(@RequestBody ProjectProgrammeDTO projectProgrammeDTO) {
        try {
            return R.ok((Object)this.projectProgrammeService.callBackUpdate(projectProgrammeDTO));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/callBack"})
    @ApiOperation(value="\u6280\u672f\u65b9\u6848-\u5de5\u4f5c\u6d41\u56de\u8c03")
    public R<String> callBack(@RequestBody WorkFlowCallBackVO callBackVO) {
        try {
            this.projectProgrammeService.callBack(callBackVO);
            return R.ok((Object)"success");
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }
}

