/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.controller.construction;

import cn.afterturn.easypoi.excel.ExcelExportUtil;
import cn.afterturn.easypoi.excel.entity.ExportParams;
import cn.afterturn.easypoi.excel.entity.enmus.ExcelType;
import com.baomidou.mybatisplus.extension.api.R;
import com.ruoyi.dto.construction.ProjectSurveyDTO;
import com.ruoyi.query.construction.ProjectSurveyQuery;
import com.ruoyi.service.construction.ProjectSurveyService;
import com.ruoyi.service.workFlow.WorkFlowCallBackVO;
import com.ruoyi.util.ExcelUtil;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.vo.construction.ProjectSurveyDetailsVO;
import com.ruoyi.vo.construction.ProjectSurveyExportVO;
import com.ruoyi.vo.construction.ProjectSurveyPageVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(value="\u9879\u76ee\u52d8\u5bdf", tags={"\u9879\u76ee\u52d8\u5bdf"})
@RequestMapping(value={"/projectSurvey"})
@RestController
public class ProjectSurveyController {
    private static final Logger log = LoggerFactory.getLogger(ProjectSurveyController.class);
    @Resource
    private ProjectSurveyService projectSurveyService;

    @PostMapping(value={"/getPage"})
    @ApiOperation(value="\u9879\u76ee\u52d8\u5bdf\u5217\u8868\u9875\u9762")
    public R<PageResultVo<ProjectSurveyPageVO>> getPage(@RequestBody ProjectSurveyQuery projectSurveyQuery) {
        try {
            PageResultVo contractDTOListPage = this.projectSurveyService.getProjectSurveyListPage(projectSurveyQuery);
            return R.ok((Object)contractDTOListPage);
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/export"})
    @ApiOperation(value="\u5bfc\u51fa\u9879\u76ee\u52d8\u5bdf")
    public void export(@RequestBody ProjectSurveyQuery projectSurveyQuery, HttpServletResponse response) {
        try {
            List contractProjectList = this.projectSurveyService.getProjectSurveyList(projectSurveyQuery);
            Workbook workbook = ExcelExportUtil.exportExcel((ExportParams)new ExportParams("\u9879\u76ee\u52d8\u5bdf", "\u9879\u76ee\u52d8\u5bdf", ExcelType.XSSF), ProjectSurveyExportVO.class, (Collection)contractProjectList);
            ExcelUtil.ExcelExport((HttpServletResponse)response, (Workbook)workbook, (String)"\u9879\u76ee\u52d8\u5bdf");
        }
        catch (IOException e) {
            e.printStackTrace();
            log.warn("\u5bfc\u51fa\u5931\u8d25 error:{}", (Object)e.getMessage());
        }
    }

    @GetMapping(value={"getById"})
    @ApiOperation(value="\u9879\u76ee\u52d8\u5bdf-\u8be6\u60c5")
    public R<ProjectSurveyDetailsVO> getById(Long id) {
        try {
            ProjectSurveyDetailsVO detailVo = this.projectSurveyService.getProjectSurveyDTOById(id);
            return R.ok((Object)detailVo);
        }
        catch (Exception e) {
            e.printStackTrace();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/create"})
    @ApiOperation(value="\u521b\u5efa\u52d8\u5bdf\u4fe1\u606f")
    public R<Boolean> create(@RequestBody ProjectSurveyDTO projectSurveyDTO) {
        try {
            return R.ok((Object)this.projectSurveyService.createProjectSurvey(projectSurveyDTO));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539\u9879\u76ee\u52d8\u5bdf\u4fe1\u606f")
    public R<Boolean> update(@RequestBody ProjectSurveyDTO projectSurveyDTO) {
        try {
            return R.ok((Object)this.projectSurveyService.updateProjectSurvey(projectSurveyDTO));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @DeleteMapping(value={"/delete/{id}"})
    @ApiOperation(value="\u9879\u76ee\u52d8\u5bdf\u4fe1\u606f-\u5220\u9664")
    public R<Boolean> delete(@PathVariable(value="id") Long id) {
        try {
            return R.ok((Object)this.projectSurveyService.deleteProjectSurvey(id));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/callBackUpdate"})
    @ApiOperation(value="\u9879\u76ee\u52d8\u5bdf\u4fe1\u606f-\u5de5\u4f5c\u6d41\u7a0b\u4fee\u6539\u6570\u636e")
    public R<Boolean> callBackUpdate(@RequestBody ProjectSurveyDTO projectSurveyDTO) {
        try {
            return R.ok((Object)this.projectSurveyService.callBackUpdate(projectSurveyDTO));
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }

    @PostMapping(value={"/callBack"})
    @ApiOperation(value="\u9879\u76ee\u52d8\u5bdf\u5217\u6570\u636e-\u5de5\u4f5c\u6d41\u56de\u8c03")
    public R<String> callBack(@RequestBody WorkFlowCallBackVO callBackVO) {
        try {
            this.projectSurveyService.callBack(callBackVO);
            return R.ok((Object)"success");
        }
        catch (Exception e) {
            e.getMessage();
            return R.failed((String)e.getLocalizedMessage());
        }
    }
}

