/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.mybatis;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.OrderItem;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ruoyi.mybatis.LogicOpEnum;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class WrapUtil {
    private static final Logger log = LoggerFactory.getLogger(WrapUtil.class);
    private static final String[] pageKeySet = new String[]{"pageNo", "page", "current", "currentPage"};
    private static final String[] pageSizeKeySet = new String[]{"pageSize", "size", "limit"};

    public static <T> QueryWrapper<T> getWrapper(Map<String, Object> params, Class<?> clazz) {
        Set<String> keySet = params.keySet();
        List fieldList = ReflectionKit.getFieldList(clazz).stream().map(f -> {
            String fieldName = f.getName();
            TableField tField = f.getDeclaredAnnotation(TableField.class);
            if (tField != null) {
                if (!tField.exist()) {
                    return null;
                }
                return (String)StringUtils.defaultIfBlank((CharSequence)tField.value(), (CharSequence)WrapUtil.toUnderlineCase((String)fieldName));
            }
            return WrapUtil.toUnderlineCase((String)fieldName);
        }).filter(p -> p != null).collect(Collectors.toList());
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.setEntityClass(clazz);
        for (String key : keySet) {
            String columnName;
            String fieldName = StringUtils.substringBeforeLast((String)key, (String)"_");
            String condition = StringUtils.substringAfter((String)key, (int)95);
            String string = columnName = fieldList.contains(fieldName) ? fieldName : WrapUtil.toUnderlineCase((String)fieldName);
            if (!fieldList.contains(columnName)) continue;
            Object paramValue = params.get(key);
            log.debug("{}==>{}=={}", new Object[]{fieldName, columnName, paramValue});
            if (StringUtils.isEmpty((CharSequence)condition)) {
                wrapper.eq(ObjectUtils.isNotEmpty((Object)paramValue), (Object)columnName, paramValue);
                continue;
            }
            if (LogicOpEnum.EQ.name().equals(condition) || ObjectUtils.isEmpty((Object)condition)) {
                wrapper.eq(ObjectUtils.isNotEmpty((Object)paramValue), (Object)columnName, paramValue);
                continue;
            }
            if (LogicOpEnum.LIKE.name().equals(condition)) {
                wrapper.like(ObjectUtils.isNotEmpty((Object)paramValue), (Object)columnName, paramValue);
                continue;
            }
            if (LogicOpEnum.NE.name().equals(condition)) {
                wrapper.ne(ObjectUtils.isNotEmpty((Object)paramValue), (Object)columnName, paramValue);
                continue;
            }
            if (LogicOpEnum.GT.name().equals(condition)) {
                wrapper.gt(ObjectUtils.isNotEmpty((Object)paramValue), (Object)columnName, paramValue);
                continue;
            }
            if (LogicOpEnum.GTE.name().equals(condition)) {
                if (paramValue instanceof String) {
                    // empty if block
                }
                wrapper.ge(ObjectUtils.isNotEmpty((Object)paramValue), (Object)columnName, paramValue);
                continue;
            }
            if (LogicOpEnum.LT.name().equals(condition)) {
                wrapper.lt(ObjectUtils.isNotEmpty((Object)paramValue), (Object)columnName, paramValue);
                continue;
            }
            if (LogicOpEnum.LTE.name().equals(condition)) {
                wrapper.le(ObjectUtils.isNotEmpty((Object)paramValue), (Object)columnName, paramValue);
                continue;
            }
            if (LogicOpEnum.IN.name().equals(condition)) {
                if (paramValue instanceof List) {
                    wrapper.in(ObjectUtils.isNotEmpty((Object)paramValue), (Object)columnName, ((List)paramValue).toArray());
                    continue;
                }
                wrapper.in(ObjectUtils.isNotEmpty((Object)paramValue), (Object)columnName, (Object[])StringUtils.split((String)((String)paramValue), (String)","));
                continue;
            }
            if (LogicOpEnum.NI.name().equals(condition)) {
                if (paramValue instanceof List) {
                    wrapper.notIn(ObjectUtils.isNotEmpty((Object)paramValue), (Object)columnName, ((List)paramValue).toArray());
                    continue;
                }
                wrapper.notIn(ObjectUtils.isNotEmpty((Object)paramValue), (Object)columnName, (Object[])StringUtils.split((String)((String)paramValue), (String)","));
                continue;
            }
            if (LogicOpEnum.NULL.name().equals(condition)) {
                wrapper.isNull(ObjectUtils.isNotEmpty((Object)paramValue), (Object)columnName);
                continue;
            }
            if (!LogicOpEnum.NOTNULL.name().equals(condition)) continue;
            wrapper.isNotNull(ObjectUtils.isNotEmpty((Object)paramValue), (Object)columnName);
        }
        return wrapper;
    }

    public static <T> Page<T> getPage(Map<String, Object> params) {
        Long curPage = WrapUtil.getCurrentPage(params);
        Long pageSize = WrapUtil.getPageSize(params);
        Page page = new Page(curPage.longValue(), pageSize.longValue(), true);
        params.put("page", page);
        String orderField = (String)params.get("orderField");
        String order = (String)params.get("order");
        if (StringUtils.isNotEmpty((CharSequence)orderField) && StringUtils.isNotEmpty((CharSequence)order)) {
            return "asc".equalsIgnoreCase(order) ? page.addOrder(new OrderItem[]{OrderItem.asc((String)WrapUtil.toUnderlineCase((String)orderField))}) : page.addOrder(new OrderItem[]{OrderItem.desc((String)WrapUtil.toUnderlineCase((String)orderField))});
        }
        page.addOrder(new OrderItem[]{OrderItem.desc((String)"create_date")});
        return page;
    }

    public static Long getCurrentPage(Map<String, Object> params) {
        Long curPage = 1L;
        for (String pk : pageKeySet) {
            if (params.get(pk) == null) continue;
            curPage = Long.parseLong(String.valueOf(params.get(pk)));
            log.info("{}:{}", (Object)pk, (Object)curPage);
        }
        return curPage;
    }

    public static Long getPageSize(Map<String, Object> params) {
        Long pageSize = 10L;
        for (String pk : pageSizeKeySet) {
            if (params.get(pk) == null) continue;
            pageSize = Long.parseLong(String.valueOf(params.get(pk)));
            log.info("{}:{}", (Object)pk, (Object)pageSize);
        }
        return pageSize;
    }

    public static String toUnderlineCase(String camelCaseStr) {
        if (camelCaseStr == null) {
            return null;
        }
        char[] charArray = camelCaseStr.toCharArray();
        StringBuffer buffer = new StringBuffer();
        int l = charArray.length;
        for (int i = 0; i < l; ++i) {
            if (charArray[i] >= 'A' && charArray[i] <= 'Z') {
                charArray[i] = (char)(charArray[i] + 32);
                buffer.append("_").append(charArray[i]);
                continue;
            }
            buffer.append(charArray[i]);
        }
        return buffer.toString();
    }
}

