/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.service.construction.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ruoyi.entity.construction.ProjectAcceptanceCheckEntity;
import com.ruoyi.entity.construction.ProjectAcceptanceRectificationEntity;
import com.ruoyi.entity.construction.ProjectConstructionLogsEntity;
import com.ruoyi.entity.construction.ProjectPlanEntity;
import com.ruoyi.entity.construction.ProjectProgrammeEntity;
import com.ruoyi.entity.construction.ProjectSurveyEntity;
import com.ruoyi.enums.ApprovalStatusEnum;
import com.ruoyi.enums.ContractStatusEnum;
import com.ruoyi.enums.ProjectAcceptanceCheckStatusEnum;
import com.ruoyi.enums.ProjectAcceptanceRectificationStatusEnum;
import com.ruoyi.enums.ProjectStageStatusEnum;
import com.ruoyi.enums.ProjectStatusEnum;
import com.ruoyi.mapper.construction.ProjectProgressStatisticsMapper;
import com.ruoyi.query.construction.ProjectProgressStatisticsQuery;
import com.ruoyi.service.construction.ProjectAcceptanceCheckService;
import com.ruoyi.service.construction.ProjectAcceptanceRectificationService;
import com.ruoyi.service.construction.ProjectConstructionLogsService;
import com.ruoyi.service.construction.ProjectPlanService;
import com.ruoyi.service.construction.ProjectProgrammeService;
import com.ruoyi.service.construction.ProjectProgressStatisticsService;
import com.ruoyi.service.construction.ProjectSurveyService;
import com.ruoyi.util.DozerUtils;
import com.ruoyi.util.PageResultVo;
import com.ruoyi.vo.construction.ApartmentExportVO;
import com.ruoyi.vo.construction.BusinessExportVO;
import com.ruoyi.vo.construction.ContractVO;
import com.ruoyi.vo.construction.InvoicingVO;
import com.ruoyi.vo.construction.MaterialVO;
import com.ruoyi.vo.construction.ProjectInformationExportVO;
import com.ruoyi.vo.construction.SalesExportVO;
import com.ruoyi.vo.construction.VolumeVO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class ProjectProgressStatisticsServiceImpl
implements ProjectProgressStatisticsService {
    @Resource
    private ProjectProgressStatisticsMapper projectProgressStatisticsMapper;
    @Resource
    private ProjectSurveyService projectSurveyService;
    @Resource
    private ProjectProgrammeService projectProgrammeService;
    @Resource
    private ProjectPlanService projectPlanService;
    @Resource
    private ProjectConstructionLogsService projectConstructionLogsService;
    @Resource
    private ProjectAcceptanceCheckService projectAcceptanceCheckService;
    @Resource
    private ProjectAcceptanceRectificationService projectAcceptanceRectificationService;

    public List<ProjectInformationExportVO> getProject(Integer type, ProjectProgressStatisticsQuery projectAcceptanceCheckQuery) {
        if (type == 2) {
            projectAcceptanceCheckQuery.setType("\u516c\u5bd3\u5bbd\u5e26\u9879\u76ee");
        } else if (type == 3 || type == 4) {
            projectAcceptanceCheckQuery.setType("\u5546\u52a1\u5bbd\u5e26\u9879\u76ee");
        }
        List<ProjectInformationExportVO> projectList = this.projectProgressStatisticsMapper.getProjectList(projectAcceptanceCheckQuery);
        if (ObjectUtil.isEmpty((Object)projectList)) {
            return projectList;
        }
        List projectCodes = projectList.stream().map(ProjectInformationExportVO::getProjectCode).collect(Collectors.toList());
        List surveyEntities = ((LambdaQueryChainWrapper)this.projectSurveyService.lambdaQuery().in(ProjectSurveyEntity::getProjectCode, projectCodes)).list();
        List programmeEntities = ((LambdaQueryChainWrapper)this.projectProgrammeService.lambdaQuery().in(ProjectProgrammeEntity::getProjectCode, projectCodes)).list();
        List planEntities = ((LambdaQueryChainWrapper)this.projectPlanService.lambdaQuery().in(ProjectPlanEntity::getProjectCode, projectCodes)).list();
        List checkEntities = ((LambdaQueryChainWrapper)this.projectAcceptanceCheckService.lambdaQuery().in(ProjectAcceptanceCheckEntity::getProjectCode, projectCodes)).list();
        List contractVOS = null;
        if (type == 1) {
            contractVOS = this.projectProgressStatisticsMapper.selectContract(projectCodes);
        }
        if (ObjectUtil.isNotEmpty((Object)projectList)) {
            List finalContractVOS = contractVOS;
            projectList.forEach(p -> {
                long surveyCount = surveyEntities.stream().filter(f -> f.getProjectCode().equals(p.getProjectCode())).count();
                if (surveyCount != 0L) {
                    long programmeCount = programmeEntities.stream().filter(f -> f.getProjectCode().equals(p.getProjectCode())).count();
                    if (programmeCount != 0L) {
                        long planCount = planEntities.stream().filter(f -> f.getProjectCode().equals(p.getProjectCode())).count();
                        if (planCount != 0L) {
                            List collect = checkEntities.stream().filter(f -> f.getProjectCode().equals(p.getProjectCode())).collect(Collectors.toList());
                            if (ObjectUtil.isNotEmpty(collect)) {
                                long count = collect.stream().filter(f -> f.getStatus().equals(ProjectAcceptanceCheckStatusEnum.TEN.getCode())).count();
                                if ((long)collect.size() != count) {
                                    if (type == 1) {
                                        ContractVO contractVO;
                                        p.setStatus(ProjectStatusEnum.FOUR.getName());
                                        if (ObjectUtil.isNotEmpty((Object)finalContractVOS) && ObjectUtil.isNotEmpty((Object)(contractVO = (ContractVO)finalContractVOS.stream().filter(f -> f.getProjectCode().equals(p.getProjectCode())).findFirst().orElse(null))) && "\u5426".equals(contractVO.getIsOperate())) {
                                            p.setStatus(ProjectStatusEnum.FIVE.getName());
                                        }
                                    } else {
                                        p.setStatus(ProjectStageStatusEnum.FOUR.getName());
                                    }
                                } else {
                                    p.setStatus(ProjectStatusEnum.THREE.getName());
                                }
                            } else {
                                p.setStatus(ProjectStageStatusEnum.TWO.getName());
                            }
                        } else {
                            p.setStatus(ProjectStageStatusEnum.ONE.getName());
                        }
                    } else {
                        p.setStatus(ProjectStageStatusEnum.ZERO.getName());
                    }
                }
            });
        }
        if (StringUtils.isNotBlank((CharSequence)projectAcceptanceCheckQuery.getStage())) {
            projectList = projectList.stream().filter(f -> StringUtils.isNotBlank((CharSequence)f.getStatus()) && f.getStatus().equals(projectAcceptanceCheckQuery.getStage())).collect(Collectors.toList());
        }
        return projectList;
    }

    public PageResultVo<ProjectInformationExportVO> projectInformation(ProjectProgressStatisticsQuery projectAcceptanceCheckQuery) {
        Page page = new Page();
        List list = this.getProject(Integer.valueOf(1), projectAcceptanceCheckQuery);
        List records = this.pageList(list, projectAcceptanceCheckQuery.getPageSize(), projectAcceptanceCheckQuery.getPageNum());
        if (ObjectUtil.isNotEmpty((Object)records)) {
            List projectCodes = records.stream().map(ProjectInformationExportVO::getProjectCode).collect(Collectors.toList());
            List logsEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.projectConstructionLogsService.lambdaQuery().in(ProjectConstructionLogsEntity::getProjectCode, projectCodes)).orderByDesc(ProjectConstructionLogsEntity::getCreateTime)).list();
            List rxitReason = this.projectProgressStatisticsMapper.getExitReason(projectCodes);
            List contractVOS = this.projectProgressStatisticsMapper.selectContract(projectCodes);
            records.forEach(r -> {
                ProjectInformationExportVO projectInformationExportVO;
                ProjectConstructionLogsEntity logsEntity;
                ContractVO contractVO = contractVOS.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null);
                if (ObjectUtil.isNotEmpty((Object)contractVO)) {
                    r.setIsOperate(contractVO.getIsOperate());
                    r.setContractStatus(ContractStatusEnum.getName((String)contractVO.getContractStatus()));
                    r.setRoomQuantity(contractVO.getRoomQuantity());
                    if (StringUtils.isNotBlank((CharSequence)contractVO.getPaymentMode())) {
                        String[] split = contractVO.getPaymentMode().split(",");
                        String paymentMode = Arrays.stream(split).distinct().collect(Collectors.joining(","));
                        r.setPaymentMethod(paymentMode);
                    }
                }
                if (ObjectUtil.isNotEmpty((Object)(logsEntity = (ProjectConstructionLogsEntity)logsEntities.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null)))) {
                    r.setStartDate(logsEntity.getActualDate());
                    r.setCompletionDate(logsEntity.getActualCompletion());
                    if (StringUtils.isNotEmpty((CharSequence)logsEntity.getExternalLaunch()) && "\u5df2\u4e0a\u7ebf".equals(logsEntity.getExternalLaunch())) {
                        r.setBillingDate(logsEntity.getCreateTime());
                    }
                }
                if (ObjectUtil.isNotEmpty((Object)contractVO)) {
                    long num = contractVOS.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).count();
                    if (num > 1L) {
                        r.setExpirationDate(contractVO.getExpirationDate());
                        r.setRenewalDate(contractVO.getRenewalDate());
                    }
                    r.setContactsEndTime(contractVO.getContactsEndTime());
                    r.setContactsStartTime(contractVO.getContactsStartTime());
                }
                if (ObjectUtil.isNotEmpty((Object)(projectInformationExportVO = (ProjectInformationExportVO)rxitReason.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null)))) {
                    r.setExitDate(projectInformationExportVO.getExitDate());
                    r.setExitReason(projectInformationExportVO.getExitReason());
                }
            });
        }
        page.setCurrent((long)projectAcceptanceCheckQuery.getPageNum());
        page.setSize((long)projectAcceptanceCheckQuery.getPageSize());
        page.setTotal((long)list.size());
        page.setRecords(records);
        return new PageResultVo(page);
    }

    public PageResultVo<ApartmentExportVO> apartment(ProjectProgressStatisticsQuery projectAcceptanceCheckQuery) {
        Page page = new Page();
        List project = this.getProject(Integer.valueOf(2), projectAcceptanceCheckQuery);
        List list = DozerUtils.mapList((Collection)project, ApartmentExportVO.class);
        List records = this.pageList(list, projectAcceptanceCheckQuery.getPageSize(), projectAcceptanceCheckQuery.getPageNum());
        if (ObjectUtil.isNotEmpty((Object)records)) {
            List projectCodes = records.stream().map(ApartmentExportVO::getProjectCode).collect(Collectors.toList());
            List logsEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.projectConstructionLogsService.lambdaQuery().in(ProjectConstructionLogsEntity::getProjectCode, projectCodes)).orderByDesc(ProjectConstructionLogsEntity::getCreateTime)).list();
            List surveyEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.projectSurveyService.lambdaQuery().in(ProjectSurveyEntity::getProjectCode, projectCodes)).orderByDesc(ProjectSurveyEntity::getCreateTime)).list();
            List checkEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.projectAcceptanceCheckService.lambdaQuery().in(ProjectAcceptanceCheckEntity::getProjectCode, projectCodes)).orderByDesc(ProjectAcceptanceCheckEntity::getCreateTime)).list();
            List rectificationEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.projectAcceptanceRectificationService.lambdaQuery().in(ProjectAcceptanceRectificationEntity::getProjectCode, projectCodes)).orderByDesc(ProjectAcceptanceRectificationEntity::getCreateTime)).list();
            List contractVOS = this.projectProgressStatisticsMapper.selectContract(projectCodes);
            List materialVOS = this.projectProgressStatisticsMapper.selectMaterial(projectCodes);
            List invoicingVOS = this.projectProgressStatisticsMapper.selectInvoicing(projectCodes);
            records.forEach(r -> {
                ProjectAcceptanceRectificationEntity rectificationEntity;
                ProjectAcceptanceCheckEntity acceptanceCheckEntity;
                InvoicingVO invoicingVO;
                MaterialVO materialVO;
                ProjectConstructionLogsEntity logsEntity;
                ProjectSurveyEntity projectSurveyEntity;
                ContractVO contractVO = contractVOS.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null);
                if (ObjectUtil.isNotEmpty((Object)contractVO)) {
                    r.setApartmentDormitory(contractVO.getRoomQuantity());
                    if (StringUtils.isNotBlank((CharSequence)contractVO.getPaymentMode())) {
                        String[] split = contractVO.getPaymentMode().split(",");
                        String paymentMode = Arrays.stream(split).distinct().collect(Collectors.joining(","));
                        r.setPaymentMethod(paymentMode);
                    }
                }
                if (ObjectUtil.isNotEmpty((Object)(projectSurveyEntity = (ProjectSurveyEntity)surveyEntities.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null)))) {
                    r.setSurveyStatus(ApprovalStatusEnum.getName((Integer)projectSurveyEntity.getApprovalStatus()));
                    r.setSurveyReport(projectSurveyEntity.getSurveyNumber());
                }
                if (ObjectUtil.isNotEmpty((Object)(logsEntity = (ProjectConstructionLogsEntity)logsEntities.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null)))) {
                    r.setActualDate(logsEntity.getActualDate());
                    r.setCompletionDate(logsEntity.getActualCompletion());
                    if (StringUtils.isNotBlank((CharSequence)logsEntity.getExternalPlace()) && "\u5df2\u5b89\u88c5".equals(logsEntity.getExternalPlace())) {
                        r.setNetwork("100%");
                    } else {
                        r.setNetwork("0%");
                    }
                    r.setConstruction(logsEntity.getFloorConstruction());
                    r.setComputer(logsEntity.getComputerConstruction());
                    r.setRoom(logsEntity.getRoomConstruction());
                    if (StringUtils.isNotEmpty((CharSequence)logsEntity.getExternalLaunch()) && "\u5df2\u4e0a\u7ebf".equals(logsEntity.getExternalLaunch())) {
                        r.setGoOnline("100%");
                        r.setIsCharging("\u662f");
                    } else {
                        r.setGoOnline("0%");
                        r.setIsCharging("\u5426");
                    }
                }
                if (ObjectUtil.isNotEmpty((Object)(materialVO = (MaterialVO)materialVOS.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null)))) {
                    r.setApply(materialVO.getApply());
                    r.setOutbound(materialVO.getOutbound());
                    BigDecimal app = new BigDecimal(materialVO.getApplyCount());
                    BigDecimal oub = new BigDecimal(materialVO.getOutboundCount());
                    if (app.compareTo(BigDecimal.ZERO) != 0) {
                        r.setMaterial(oub.multiply(new BigDecimal(100)).divide(app, 1, 4).toString() + "%");
                    }
                }
                if (ObjectUtil.isNotEmpty((Object)contractVO)) {
                    r.setContactsStartTime(contractVO.getContactsStartTime());
                    r.setContactsEndTime(contractVO.getContactsEndTime());
                }
                if (ObjectUtil.isNotEmpty((Object)(invoicingVO = (InvoicingVO)invoicingVOS.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null)))) {
                    r.setInvoicing(invoicingVO.getInvoicing());
                }
                if (ObjectUtil.isNotEmpty((Object)(acceptanceCheckEntity = (ProjectAcceptanceCheckEntity)checkEntities.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null)))) {
                    r.setCertificateNumber(acceptanceCheckEntity.getAcceptanceNumber());
                    r.setCertificateStatus(ProjectAcceptanceCheckStatusEnum.getName((Integer)acceptanceCheckEntity.getStatus()));
                }
                if (ObjectUtil.isNotEmpty((Object)(rectificationEntity = (ProjectAcceptanceRectificationEntity)rectificationEntities.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null)))) {
                    r.setCauseAnalysis(rectificationEntity.getRectificationSuggestions());
                    r.setRectificationNumber(rectificationEntity.getAcceptanceRectificationNumber());
                    r.setResolveSituation(ProjectAcceptanceRectificationStatusEnum.getName((Integer)rectificationEntity.getStatus()));
                }
            });
        }
        page.setCurrent((long)projectAcceptanceCheckQuery.getPageNum());
        page.setSize((long)projectAcceptanceCheckQuery.getPageSize());
        page.setTotal((long)list.size());
        page.setRecords(records);
        return new PageResultVo(page);
    }

    public PageResultVo<BusinessExportVO> business(ProjectProgressStatisticsQuery projectAcceptanceCheckQuery) {
        Page page = new Page();
        List project = this.getProject(Integer.valueOf(3), projectAcceptanceCheckQuery);
        List list = DozerUtils.mapList((Collection)project, BusinessExportVO.class);
        List records = this.pageList(list, projectAcceptanceCheckQuery.getPageSize(), projectAcceptanceCheckQuery.getPageNum());
        if (ObjectUtil.isNotEmpty((Object)records)) {
            List projectCodes = records.stream().map(BusinessExportVO::getProjectCode).collect(Collectors.toList());
            List logsEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.projectConstructionLogsService.lambdaQuery().in(ProjectConstructionLogsEntity::getProjectCode, projectCodes)).orderByDesc(ProjectConstructionLogsEntity::getCreateTime)).list();
            List surveyEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.projectSurveyService.lambdaQuery().in(ProjectSurveyEntity::getProjectCode, projectCodes)).orderByDesc(ProjectSurveyEntity::getCreateTime)).list();
            List checkEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.projectAcceptanceCheckService.lambdaQuery().in(ProjectAcceptanceCheckEntity::getProjectCode, projectCodes)).orderByDesc(ProjectAcceptanceCheckEntity::getCreateTime)).list();
            List rectificationEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.projectAcceptanceRectificationService.lambdaQuery().in(ProjectAcceptanceRectificationEntity::getProjectCode, projectCodes)).orderByDesc(ProjectAcceptanceRectificationEntity::getCreateTime)).list();
            List contractVOS = this.projectProgressStatisticsMapper.selectContract(projectCodes);
            List materialVOS = this.projectProgressStatisticsMapper.selectMaterial(projectCodes);
            List invoicingVOS = this.projectProgressStatisticsMapper.selectInvoicing(projectCodes);
            List volumeVOS = this.projectProgressStatisticsMapper.selectVolume(projectCodes);
            records.forEach(r -> {
                ProjectAcceptanceRectificationEntity rectificationEntity;
                ProjectAcceptanceCheckEntity acceptanceCheckEntity;
                InvoicingVO invoicingVO;
                ContractVO contractVO;
                MaterialVO materialVO;
                ProjectConstructionLogsEntity logsEntity;
                long count = volumeVOS.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode()) && "\u516c\u5bd3".equals(f.getSalesTargetType())).count();
                long count1 = volumeVOS.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode()) && "\u5bbf\u820d".equals(f.getSalesTargetType())).count();
                long count2 = volumeVOS.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode()) && "\u81ea\u6301\u5bbf\u820d".equals(f.getSalesTargetType())).count();
                long count3 = volumeVOS.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode()) && "\u4f01\u4e1a".equals(f.getSalesTargetType())).count();
                long count4 = volumeVOS.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode()) && "\u5382\u623f".equals(f.getSalesTargetType())).count();
                long count5 = volumeVOS.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode()) && "\u5546\u94fa".equals(f.getSalesTargetType())).count();
                long count6 = volumeVOS.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).count();
                r.setApartment(String.valueOf(count));
                r.setDormitory(String.valueOf(count1));
                r.setSustaining(String.valueOf(count2));
                r.setEnterprise(String.valueOf(count3));
                r.setWorkshop(String.valueOf(count4));
                r.setShops(String.valueOf(count5));
                r.setTotal(String.valueOf(count6));
                ProjectSurveyEntity projectSurveyEntity = surveyEntities.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null);
                if (ObjectUtil.isNotEmpty((Object)projectSurveyEntity)) {
                    r.setSurveyStatus(ApprovalStatusEnum.getName((Integer)projectSurveyEntity.getApprovalStatus()));
                    r.setSurveyReport(projectSurveyEntity.getSurveyNumber());
                }
                if (ObjectUtil.isNotEmpty((Object)(logsEntity = (ProjectConstructionLogsEntity)logsEntities.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null)))) {
                    r.setActualDate(logsEntity.getActualDate());
                    r.setCompletionDate(logsEntity.getActualCompletion());
                    if (StringUtils.isNotBlank((CharSequence)logsEntity.getExternalPlace()) && "\u5df2\u5b89\u88c5".equals(logsEntity.getExternalPlace())) {
                        r.setNetwork("100%");
                    } else {
                        r.setNetwork("0%");
                    }
                    r.setConstruction(logsEntity.getFloorConstruction());
                    r.setComputer(logsEntity.getComputerConstruction());
                    r.setRoom(logsEntity.getRoomConstruction());
                    if (StringUtils.isNotEmpty((CharSequence)logsEntity.getExternalLaunch()) && "\u5df2\u4e0a\u7ebf".equals(logsEntity.getExternalLaunch())) {
                        r.setGoOnline("100%");
                        r.setIsCharging("\u662f");
                    } else {
                        r.setGoOnline("0%");
                        r.setIsCharging("\u5426");
                    }
                }
                if (ObjectUtil.isNotEmpty((Object)(materialVO = (MaterialVO)materialVOS.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null)))) {
                    r.setApply(materialVO.getApply());
                    r.setOutbound(materialVO.getOutbound());
                    BigDecimal app = new BigDecimal(materialVO.getApplyCount());
                    BigDecimal oub = new BigDecimal(materialVO.getOutboundCount());
                    if (app.compareTo(BigDecimal.ZERO) != 0) {
                        r.setMaterial(oub.multiply(new BigDecimal(100)).divide(app, 1, 4).toString() + "%");
                    }
                }
                if (ObjectUtil.isNotEmpty((Object)(contractVO = (ContractVO)contractVOS.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null)))) {
                    r.setContactsStartTime(contractVO.getContactsStartTime());
                    r.setContactsEndTime(contractVO.getContactsEndTime());
                }
                if (ObjectUtil.isNotEmpty((Object)(invoicingVO = (InvoicingVO)invoicingVOS.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null)))) {
                    r.setInvoicing(invoicingVO.getInvoicing());
                }
                if (ObjectUtil.isNotEmpty((Object)(acceptanceCheckEntity = (ProjectAcceptanceCheckEntity)checkEntities.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null)))) {
                    r.setCertificateNumber(acceptanceCheckEntity.getAcceptanceNumber());
                    r.setCertificateStatus(ProjectAcceptanceCheckStatusEnum.getName((Integer)acceptanceCheckEntity.getStatus()));
                }
                if (ObjectUtil.isNotEmpty((Object)(rectificationEntity = (ProjectAcceptanceRectificationEntity)rectificationEntities.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null)))) {
                    r.setCauseAnalysis(rectificationEntity.getRectificationSuggestions());
                    r.setRectificationNumber(rectificationEntity.getAcceptanceRectificationNumber());
                    r.setResolveSituation(ProjectAcceptanceRectificationStatusEnum.getName((Integer)rectificationEntity.getStatus()));
                }
            });
        }
        page.setCurrent((long)projectAcceptanceCheckQuery.getPageNum());
        page.setSize((long)projectAcceptanceCheckQuery.getPageSize());
        page.setTotal((long)list.size());
        page.setRecords(records);
        return new PageResultVo(page);
    }

    public PageResultVo<SalesExportVO> sales(ProjectProgressStatisticsQuery projectAcceptanceCheckQuery) {
        List records;
        Page page = new Page();
        List project = this.getProject(Integer.valueOf(4), projectAcceptanceCheckQuery);
        List list = DozerUtils.mapList((Collection)project, SalesExportVO.class);
        ArrayList allList = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)list)) {
            List projectCodes = list.stream().map(SalesExportVO::getProjectCode).collect(Collectors.toList());
            List volumeVOS = this.projectProgressStatisticsMapper.selectVolume(projectCodes);
            list.forEach(l -> {
                List<VolumeVO> collect = volumeVOS.stream().filter(f -> f.getProjectCode().equals(l.getProjectCode())).collect(Collectors.toList());
                if (ObjectUtil.isNotEmpty(collect)) {
                    collect.forEach(v -> {
                        SalesExportVO transfor = (SalesExportVO)DozerUtils.transfor((Object)l, SalesExportVO.class);
                        transfor.setSalesType(v.getSalesTargetType());
                        transfor.setSalesName(v.getSalesTargetType());
                        transfor.setRoom(v.getRoomCount());
                        allList.add(transfor);
                    });
                }
            });
        }
        if (ObjectUtil.isNotEmpty((Object)(records = this.pageList(list, projectAcceptanceCheckQuery.getPageSize(), projectAcceptanceCheckQuery.getPageNum())))) {
            List projectCodes = records.stream().map(SalesExportVO::getProjectCode).collect(Collectors.toList());
            List logsEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.projectConstructionLogsService.lambdaQuery().in(ProjectConstructionLogsEntity::getProjectCode, projectCodes)).orderByDesc(ProjectConstructionLogsEntity::getCreateTime)).list();
            List surveyEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.projectSurveyService.lambdaQuery().in(ProjectSurveyEntity::getProjectCode, projectCodes)).orderByDesc(ProjectSurveyEntity::getCreateTime)).list();
            List checkEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.projectAcceptanceCheckService.lambdaQuery().in(ProjectAcceptanceCheckEntity::getProjectCode, projectCodes)).orderByDesc(ProjectAcceptanceCheckEntity::getCreateTime)).list();
            List rectificationEntities = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.projectAcceptanceRectificationService.lambdaQuery().in(ProjectAcceptanceRectificationEntity::getProjectCode, projectCodes)).orderByDesc(ProjectAcceptanceRectificationEntity::getCreateTime)).list();
            List contractVOS = this.projectProgressStatisticsMapper.selectContract(projectCodes);
            List materialVOS = this.projectProgressStatisticsMapper.selectMaterial(projectCodes);
            List invoicingVOS = this.projectProgressStatisticsMapper.selectInvoicing(projectCodes);
            records.forEach(r -> {
                ProjectAcceptanceRectificationEntity rectificationEntity;
                ProjectAcceptanceCheckEntity acceptanceCheckEntity;
                InvoicingVO invoicingVO;
                ContractVO contractVO;
                MaterialVO materialVO;
                ProjectConstructionLogsEntity logsEntity;
                ProjectSurveyEntity projectSurveyEntity = surveyEntities.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null);
                if (ObjectUtil.isNotEmpty((Object)projectSurveyEntity)) {
                    r.setSurveyStatus(ApprovalStatusEnum.getName((Integer)projectSurveyEntity.getApprovalStatus()));
                    r.setSurveyReport(projectSurveyEntity.getSurveyNumber());
                }
                if (ObjectUtil.isNotEmpty((Object)(logsEntity = (ProjectConstructionLogsEntity)logsEntities.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null)))) {
                    r.setActualDate(logsEntity.getActualDate());
                    r.setCompletionDate(logsEntity.getActualCompletion());
                    if (StringUtils.isNotBlank((CharSequence)logsEntity.getExternalPlace()) && "\u5df2\u5b89\u88c5".equals(logsEntity.getExternalPlace())) {
                        r.setNetwork("100%");
                    } else {
                        r.setNetwork("0%");
                    }
                    r.setConstruction(logsEntity.getFloorConstruction());
                    r.setComputer(logsEntity.getComputerConstruction());
                    r.setRoom(logsEntity.getRoomConstruction());
                    if (StringUtils.isNotEmpty((CharSequence)logsEntity.getExternalLaunch()) && "\u5df2\u4e0a\u7ebf".equals(logsEntity.getExternalLaunch())) {
                        r.setGoOnline("100%");
                        r.setIsCharging("\u662f");
                    } else {
                        r.setGoOnline("0%");
                        r.setIsCharging("\u5426");
                    }
                }
                if (ObjectUtil.isNotEmpty((Object)(materialVO = (MaterialVO)materialVOS.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null)))) {
                    r.setApply(materialVO.getApply());
                    r.setOutbound(materialVO.getOutbound());
                    BigDecimal app = new BigDecimal(materialVO.getApplyCount());
                    BigDecimal oub = new BigDecimal(materialVO.getOutboundCount());
                    if (app.compareTo(BigDecimal.ZERO) != 0) {
                        r.setMaterial(oub.multiply(new BigDecimal(100)).divide(app, 1, 4).toString() + "%");
                    }
                }
                if (ObjectUtil.isNotEmpty((Object)(contractVO = (ContractVO)contractVOS.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null)))) {
                    r.setContactsStartTime(contractVO.getContactsStartTime());
                    r.setContactsEndTime(contractVO.getContactsEndTime());
                }
                if (ObjectUtil.isNotEmpty((Object)(invoicingVO = (InvoicingVO)invoicingVOS.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null)))) {
                    r.setInvoicing(invoicingVO.getInvoicing());
                }
                if (ObjectUtil.isNotEmpty((Object)(acceptanceCheckEntity = (ProjectAcceptanceCheckEntity)checkEntities.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null)))) {
                    r.setCertificateNumber(acceptanceCheckEntity.getAcceptanceNumber());
                    r.setCertificateStatus(ProjectAcceptanceCheckStatusEnum.getName((Integer)acceptanceCheckEntity.getStatus()));
                }
                if (ObjectUtil.isNotEmpty((Object)(rectificationEntity = (ProjectAcceptanceRectificationEntity)rectificationEntities.stream().filter(f -> f.getProjectCode().equals(r.getProjectCode())).findFirst().orElse(null)))) {
                    r.setCauseAnalysis(rectificationEntity.getRectificationSuggestions());
                    r.setRectificationNumber(rectificationEntity.getAcceptanceRectificationNumber());
                    r.setResolveSituation(ProjectAcceptanceRectificationStatusEnum.getName((Integer)rectificationEntity.getStatus()));
                }
            });
        }
        page.setCurrent((long)projectAcceptanceCheckQuery.getPageNum());
        page.setSize((long)projectAcceptanceCheckQuery.getPageSize());
        page.setTotal((long)list.size());
        page.setRecords(records);
        return new PageResultVo(page);
    }

    public List pageList(List dataList, int pageSize, int pageNum) {
        ArrayList currentPageList = new ArrayList();
        if (ObjectUtil.isNotEmpty((Object)dataList)) {
            int currIdx = pageNum > 1 ? (pageNum - 1) * pageSize : 0;
            for (int i = 0; i < pageSize && i < dataList.size() - currIdx; ++i) {
                Object data = dataList.get(currIdx + i);
                currentPageList.add(data);
            }
        }
        return currentPageList;
    }
}

