/*
 * Decompiled with CFR 0.152.
 */
package com.ruoyi.util;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.WeekFields;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class DateUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(DateUtils.class);
    public static final String DATEFORMAT_YYYYMM = "yyyyMM";
    public static final String DATEFORMAT_YYYY = "yyyy";
    public static final String DATEFORMAT_YYYYMMDD = "yyyyMMdd";
    public static final String DATEFORMAT_MM = "MM";
    public static final String DATEFORMAT_YYYYMMDDHH = "yyyyMMddHH";
    public static final String DATEFORMAT_YYYYMMDDHHMM = "yyyyMMddHHmm";
    public static final String DATEFORMAT_YYYY_MM_DD = "yyyy-MM-dd";
    public static final String DATEFORMAT_YYYY_MM = "yyyy-MM";
    public static final String DATEFORMAT_YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String DATEFORMAT_YYYYMMDD_HH_MM_SS = "yyyyMMdd HH:mm:ss";
    public static final String DATEFORMAT_YYYYMMDDHHMMSS = "yyyyMMddHHmmss";
    public static final String DATEFORMAT_MMDD = "MM.dd";
    public static final String YYYYMMDD = "yyyy.MM.dd";

    public static String getDateToString(Date date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sf = new SimpleDateFormat(format);
        return sf.format(date);
    }

    public static Date getStringToDate(String dateString) {
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        if (ObjectUtil.isNotEmpty((Object)dateString)) {
            try {
                Date date = formatter.parse(dateString);
                System.out.println(date);
                return date;
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static String getOracleDateToString(Timestamp date, String format) {
        if (date == null) {
            return null;
        }
        SimpleDateFormat sf = new SimpleDateFormat(format);
        return sf.format(date);
    }

    public static String getDateToString(Date date) {
        return DateUtils.getDateToString((Date)date, (String)"yyyy-MM-dd");
    }

    public static Date convertStrToDate(String strDate, String pattern) throws ParseException {
        if (StringUtils.isBlank((CharSequence)strDate)) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.parse(strDate);
    }

    public static String dateTimeFormat(Date systemTime, String dateRegex1, String dateRegex2) {
        if (StringUtils.isNotBlank((CharSequence)dateRegex2)) {
            return DateUtils.getDateToString((Date)systemTime, (String)dateRegex2);
        }
        return DateUtils.getDateToString((Date)systemTime, (String)dateRegex1);
    }

    public static String dateTimeFormat(Date systemTime, String dateRegex1) {
        return DateUtils.getDateToString((Date)systemTime, (String)dateRegex1);
    }

    public static Integer cmpDatetime(Date d1, Date d2) {
        Integer result = null;
        if (d1 != null && d2 != null) {
            return d1.compareTo(d2);
        }
        return result;
    }

    public static boolean periodDup(Date start1, Date end1, Date start2, Date end2) {
        return DateUtils.periodDup((Date)start1, (Date)end1, (Date)start2, (Date)end2, (boolean)true, (boolean)true);
    }

    public static boolean periodDup(Date start1, Date end1, Date start2, Date end2, boolean nullAsUnlimit, boolean boundEqualAsDup) {
        boolean dup = false;
        if (nullAsUnlimit || start1 != null && end1 != null && start2 != null && end2 != null) {
            Date tmp;
            boolean valid2;
            Integer check1 = DateUtils.cmpDatetime((Date)start1, (Date)end1);
            Integer check2 = DateUtils.cmpDatetime((Date)start2, (Date)end2);
            boolean valid1 = check1 == null || check1 <= 0;
            boolean bl = valid2 = check2 == null || check2 <= 0;
            if (!valid1) {
                tmp = start1;
                start1 = end1;
                end1 = tmp;
            }
            if (!valid2) {
                tmp = start2;
                start2 = end2;
                end2 = tmp;
            }
            Integer cmp1 = DateUtils.cmpDatetime((Date)end1, (Date)start2);
            Integer cmp2 = DateUtils.cmpDatetime((Date)end2, (Date)start1);
            boolean noDup1 = false;
            boolean noDup2 = false;
            if (cmp1 != null) {
                int i1 = cmp1;
                boolean bl2 = noDup1 = i1 < 0 || i1 == 0 && !boundEqualAsDup;
            }
            if (cmp2 != null) {
                int i2 = cmp2;
                noDup2 = i2 < 0 || i2 == 0 && !boundEqualAsDup;
            }
            dup = !noDup1 && !noDup2;
        }
        return dup;
    }

    public static String getMonday() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cld = Calendar.getInstance(Locale.CHINA);
        cld.setFirstDayOfWeek(2);
        cld.setTimeInMillis(System.currentTimeMillis());
        cld.set(7, 2);
        return df.format(cld.getTime());
    }

    public static String getMonday(Integer weeks) {
        Calendar cld = Calendar.getInstance(Locale.CHINA);
        DayOfWeek dayOfWeek = LocalDate.of(cld.getWeekYear(), 1, 1).getDayOfWeek();
        if (dayOfWeek == DayOfWeek.FRIDAY || dayOfWeek == DayOfWeek.SATURDAY || dayOfWeek == DayOfWeek.SUNDAY) {
            weeks = weeks - 1;
        }
        WeekFields weekFields = WeekFields.ISO;
        LocalDate now = LocalDate.now();
        LocalDate localDate = now.withYear(cld.getWeekYear()).with(weekFields.weekOfYear(), weeks.intValue());
        LocalDate localDate1 = localDate.with(weekFields.dayOfWeek(), 1L);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date date = Date.from(localDate1.atStartOfDay(ZoneId.systemDefault()).toInstant());
        return df.format(date);
    }

    public static String getSunday() {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Calendar cld = Calendar.getInstance(Locale.CHINA);
        cld.setFirstDayOfWeek(2);
        cld.setTimeInMillis(System.currentTimeMillis());
        cld.set(7, 1);
        return df.format(cld.getTime());
    }

    public static String getSunday(Integer weeks) {
        Calendar cld = Calendar.getInstance(Locale.CHINA);
        DayOfWeek dayOfWeek = LocalDate.of(cld.getWeekYear(), 1, 1).getDayOfWeek();
        if (dayOfWeek == DayOfWeek.FRIDAY || dayOfWeek == DayOfWeek.SATURDAY || dayOfWeek == DayOfWeek.SUNDAY) {
            weeks = weeks - 1;
        }
        WeekFields weekFields = WeekFields.ISO;
        LocalDate now = LocalDate.now();
        LocalDate localDate = now.withYear(cld.getWeekYear()).with(weekFields.weekOfYear(), weeks.intValue());
        LocalDate localDate7 = localDate.with(weekFields.dayOfWeek(), 7L);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Date date = Date.from(localDate7.atStartOfDay(ZoneId.systemDefault()).toInstant());
        return df.format(date);
    }

    public static Integer getWeek() {
        Calendar cld = Calendar.getInstance(Locale.CHINA);
        cld.setFirstDayOfWeek(2);
        return cld.get(3);
    }

    public static Integer getYear() {
        Calendar cld = Calendar.getInstance(Locale.CHINA);
        return cld.getWeekYear();
    }

    public static int getWeeksByYear(Integer year) {
        boolean is53weekYear = LocalDate.of((int)year, 12, 31).getDayOfWeek() == DayOfWeek.SUNDAY;
        return is53weekYear ? 53 : 52;
    }

    public static String getStartOfDay(Date date) {
        DateTime startOfDay = DateUtil.beginOfDay((Date)date);
        return String.valueOf(startOfDay);
    }

    public static String getEndOfDay(Date date) {
        DateTime endOfDay = DateUtil.endOfDay((Date)date);
        return String.valueOf(endOfDay);
    }
}

