/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.security;

import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import cn.hutool.jwt.JWT;
import cn.hutool.jwt.JWTPayload;
import cn.hutool.jwt.JWTUtil;
import com.njhm.workflow.security.Oauth2Token;
import com.njhm.workflow.security.UserPrincipal;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.LockedAccountException;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.flowable.common.engine.impl.identity.Authentication;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class Oauth2Realm
extends AuthorizingRealm {
    private static final Logger log = LoggerFactory.getLogger(Oauth2Realm.class);
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    public boolean supports(AuthenticationToken token) {
        return token instanceof Oauth2Token;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        return null;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        String accessToken = (String)authenticationToken.getPrincipal();
        log.debug("token:{}", (Object)authenticationToken);
        String jwtToken = (String)authenticationToken.getPrincipal();
        if (StringUtils.isBlank((CharSequence)jwtToken)) {
            throw new LockedAccountException("\u8d26\u53f7\u672a\u627e\u5230\uff0c\u8bf7\u767b\u5f55\uff01");
        }
        JWT jwt = JWTUtil.parseToken((String)jwtToken).setKey(accessToken.getBytes());
        JWTPayload payload = jwt.getPayload();
        JSONObject claimsJson = payload.getClaimsJson();
        UserPrincipal principal = new UserPrincipal();
        principal.setName((String)StringUtils.defaultIfBlank((CharSequence)claimsJson.getStr((Object)"realName"), (CharSequence)claimsJson.getStr((Object)"nick_name")));
        principal.setMobile(claimsJson.getStr((Object)"mobile"));
        principal.setGender(claimsJson.getInt((Object)"gender"));
        principal.setPostId(claimsJson.getStr((Object)"postId"));
        principal.setEmail(claimsJson.getStr((Object)"email"));
        principal.setHeadUrl(claimsJson.getStr((Object)"headUrl"));
        principal.setPostName(claimsJson.getStr((Object)"postName"));
        principal.setUserId((String)StringUtils.defaultIfBlank((CharSequence)claimsJson.getStr((Object)"id"), (CharSequence)claimsJson.getStr((Object)"user_id")));
        principal.setDeptId(claimsJson.getStr((Object)"deptId"));
        log.info("=online----user ----===\u5f53\u524d\u767b\u5f55\u7528\u6237\u4fe1\u606f\uff1a{}", (Object)JSONUtil.toJsonStr((Object)principal));
        Authentication.setAuthenticatedUserId((String)principal.getUserId());
        return new SimpleAuthenticationInfo((Object)principal, (Object)accessToken, this.getName());
    }
}

