/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.service.impl;

import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.njhm.workflow.dto.comm.ProcessRoleComm;
import com.njhm.workflow.dto.comm.ProcessUserComm;
import com.njhm.workflow.dto.event.FlowNoticeEvent;
import com.njhm.workflow.dto.event.FlowTaskNotice;
import com.njhm.workflow.exception.BizException;
import com.njhm.workflow.service.WorkflowCommService;
import com.njhm.workflow.utils.PageData;
import com.njhm.workflow.utils.ValidatorUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class WorkflowCommServiceImpl
implements WorkflowCommService {
    private static final Logger log = LoggerFactory.getLogger(WorkflowCommServiceImpl.class);
    @Value(value="${workflow.envUrl}")
    private String envUrl;

    public PageData<ProcessUserComm> findUserList(Integer pageNum, Integer pageSize, String userName) {
        String result;
        JSONObject jsonObject;
        String code;
        Integer total = 0;
        ArrayList<ProcessUserComm> results = new ArrayList<ProcessUserComm>();
        String baseUrl = this.envUrl + "/prod-api/system/user/pageUsersForProcess?pageNum=%s&pageSize=%s";
        Object staffUrl = String.format(baseUrl, pageNum, pageSize);
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            staffUrl = (String)staffUrl + String.format("&userName=%s", userName);
        }
        if ("200".equals(code = (jsonObject = JSONUtil.parseObj((String)(result = HttpUtil.get((String)staffUrl)))).get((Object)"code").toString())) {
            JSONObject pageObj = (JSONObject)jsonObject.get((Object)"data");
            total = (Integer)pageObj.get((Object)"total");
            JSONArray array = (JSONArray)pageObj.get((Object)"list");
            for (Object obj : array) {
                ProcessUserComm comm = new ProcessUserComm();
                JSONObject entity = JSONUtil.parseObj(obj);
                comm.setId(entity.get((Object)"id").toString());
                comm.setUserCode(entity.get((Object)"userCode").toString());
                comm.setUserName(entity.get((Object)"userName").toString());
                results.add(comm);
            }
        }
        PageData page = new PageData(results, (long)total.intValue());
        return page;
    }

    public PageData<ProcessRoleComm> findRoleList(Integer pageNum, Integer pageSize, String roleName) {
        String result;
        JSONObject jsonObject;
        String code;
        Integer total = 0;
        ArrayList<ProcessRoleComm> results = new ArrayList<ProcessRoleComm>();
        String baseUrl = this.envUrl + "/prod-api/system/role/pageRolesForProcess?pageNum=%s&pageSize=%s";
        Object roleUrl = String.format(baseUrl, pageNum, pageSize);
        if (StringUtils.isNotBlank((CharSequence)roleName)) {
            roleUrl = (String)roleUrl + String.format("&roleName=%s", roleName);
        }
        if ("200".equals(code = (jsonObject = JSONUtil.parseObj((String)(result = HttpUtil.get((String)roleUrl)))).get((Object)"code").toString())) {
            JSONObject pageObj = (JSONObject)jsonObject.get((Object)"data");
            total = (Integer)pageObj.get((Object)"total");
            JSONArray array = (JSONArray)pageObj.get((Object)"list");
            for (Object obj : array) {
                ProcessRoleComm comm = new ProcessRoleComm();
                JSONObject entity = JSONUtil.parseObj(obj);
                comm.setId(entity.get((Object)"id").toString());
                comm.setRoleCode(entity.get((Object)"roleCode").toString());
                comm.setRoleName(entity.get((Object)"roleName").toString());
                results.add(comm);
            }
        }
        PageData page = new PageData(results, (long)total.intValue());
        return page;
    }

    public List<ProcessUserComm> findUserByRoleId(String roleId) {
        ArrayList<ProcessUserComm> results = new ArrayList<ProcessUserComm>();
        String baseUrl = this.envUrl + "/prod-api/system/user/getUserByRoleId?roleId=%s";
        String staffUrl = String.format(baseUrl, roleId);
        String result = HttpUtil.get((String)staffUrl);
        JSONObject jsonObject = JSONUtil.parseObj((String)result);
        String code = jsonObject.get((Object)"code").toString();
        if ("200".equals(code)) {
            JSONArray array = (JSONArray)jsonObject.get((Object)"data");
            for (Object obj : array) {
                ProcessUserComm comm = new ProcessUserComm();
                JSONObject entity = JSONUtil.parseObj(obj);
                comm.setId(entity.get((Object)"id").toString());
                comm.setUserCode(entity.get((Object)"userCode").toString());
                comm.setUserName(entity.get((Object)"userName").toString());
                results.add(comm);
            }
        }
        return results;
    }

    public void workflowCallBack(FlowNoticeEvent data) {
        String event = data.getEvent();
        if (StringUtils.isBlank((CharSequence)event)) {
            throw new BizException("\u4e8b\u4ef6\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u6838\u5b9e!");
        }
        FlowTaskNotice body = data.getBody();
        ValidatorUtils.validateEntity((Object)body, (Class[])new Class[0]);
        log.info("\u5de5\u4f5c\u6d41\u56de\u8c03\u6570\u636e\uff1a{}", (Object)JSONUtil.toJsonStr((Object)data));
    }

    public static List startPage(List list, int pageNum, int pageSize) {
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return null;
        }
        int count = list.size();
        int pageCount = 0;
        pageCount = count % pageSize == 0 ? count / pageSize : count / pageSize + 1;
        if (pageNum > pageCount) {
            return null;
        }
        int fromIndex = 0;
        int toIndex = 0;
        if (pageNum != pageCount) {
            fromIndex = (pageNum - 1) * pageSize;
            toIndex = fromIndex + pageSize;
        } else {
            fromIndex = (pageNum - 1) * pageSize;
            toIndex = count;
        }
        if (fromIndex > count || toIndex > count) {
            return null;
        }
        return list.subList(fromIndex, toIndex);
    }
}

