/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.njhm.workflow.dto.UndoOpt;
import com.njhm.workflow.dto.UndoTaskSendForm;
import com.njhm.workflow.entity.HmWorkflowInstances;
import com.njhm.workflow.entity.HmWorkflowTasks;
import com.njhm.workflow.entity.UndoTask;
import com.njhm.workflow.query.RecordQuery;
import com.njhm.workflow.query.UndoTaskQuery;
import com.njhm.workflow.security.SecurityUser;
import com.njhm.workflow.service.IHmWorkflowInstancesService;
import com.njhm.workflow.service.IHmWorkflowTasksService;
import com.njhm.workflow.service.UndoTaskService;
import com.njhm.workflow.utils.ConvertUtils;
import com.njhm.workflow.utils.PageData;
import com.njhm.workflow.utils.Result;
import com.njhm.workflow.utils.WrapUtil;
import com.njhm.workflow.vo.UndoTaskVo;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.MapUtils;
import org.apache.shiro.SecurityUtils;
import org.flowable.common.engine.impl.identity.Authentication;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/undo-task"})
@Tag(name="\u5f85\u529e\u901a\u77e5")
public class UndoTaskController {
    private final UndoTaskService undoTaskService;
    @Autowired
    private IHmWorkflowInstancesService hmWorkflowInstancesService;
    @Autowired
    private IHmWorkflowTasksService hmWorkflowTasksService;

    @Operation(summary="\u67e5\u8be2\u6211\u7684\u4ee3\u529e\u6570\u91cf")
    @GetMapping(value={"getUndoCount"})
    public Result<Long> getUndoCount() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        String startUserId = "" + SecurityUser.getUserId();
        queryWrapper.eq(UndoTask::getIsWorkflow, (Object)0);
        queryWrapper.eq(UndoTask::getStatus, (Object)0);
        queryWrapper.eq(StringUtils.hasLength((String)startUserId), UndoTask::getStartUserId, (Object)startUserId);
        long count = this.undoTaskService.count((Wrapper)queryWrapper);
        return Result.ok(null, (Object)count);
    }

    private Result<PageData<UndoTask>> page(Map<String, Object> params) {
        IPage page = WrapUtil.getPage(params);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        Integer isWorkflow = MapUtils.getInteger(params, (Object)"isWorkflow");
        queryWrapper.eq(isWorkflow != null, UndoTask::getIsWorkflow, (Object)isWorkflow);
        String startUserId = MapUtils.getString(params, (Object)"startUserId");
        queryWrapper.eq(StringUtils.hasLength((String)startUserId), UndoTask::getStartUserId, (Object)startUserId);
        Integer status = MapUtils.getInteger(params, (Object)"status", (Integer)0);
        queryWrapper.eq(UndoTask::getStatus, (Object)status);
        String userId = MapUtils.getString(params, (Object)"userId");
        queryWrapper.eq(StringUtils.hasLength((String)userId), UndoTask::getUserId, (Object)userId);
        queryWrapper.orderByDesc(UndoTask::getStartTime);
        IPage result = this.undoTaskService.page(page, (Wrapper)queryWrapper);
        return Result.okData((Object)new PageData(result.getRecords(), result.getTotal()));
    }

    @Operation(summary="\u67e5\u8be2\u6211\u53d1\u8d77\u7684")
    @GetMapping(value={"instances"})
    public Result<PageData<UndoTask>> pageByStarter(@Parameter(description="\u9875\u7801 \u4ece1\u5f00\u59cb") @RequestParam(defaultValue="1") int page, @Parameter(description="\u5206\u9875\u5927\u5c0f ") @RequestParam(defaultValue="10") int limit) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        SecurityUtils.getSubject();
        params.put("page", page);
        params.put("limit", limit);
        params.put("startUserId", Authentication.getAuthenticatedUserId());
        params.put("isWorkflow", 1);
        return this.page(params);
    }

    @Operation(summary="\u67e5\u8be2\u6211\u7684\u4ee3\u529e")
    @GetMapping(value={"todo"})
    public Result<PageData<UndoTask>> pageByUserUnFinished(@Parameter(description="\u9875\u7801 \u4ece1\u5f00\u59cb") @RequestParam(defaultValue="1") int page, @Parameter(description="\u5206\u9875\u5927\u5c0f ") @RequestParam(defaultValue="10") int limit) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("page", page);
        params.put("limit", limit);
        params.put("userId", Authentication.getAuthenticatedUserId());
        params.put("isWorkflow", 0);
        params.put("status", 0);
        return this.page(params);
    }

    @Operation(summary="\u67e5\u8be2\u6211\u7684\u5df2\u529e")
    @GetMapping(value={"done"})
    public Result<PageData<UndoTask>> pageByUserFinished(@Parameter(description="\u9875\u7801 \u4ece1\u5f00\u59cb") @RequestParam(defaultValue="1") int page, @Parameter(description="\u5206\u9875\u5927\u5c0f ") @RequestParam(defaultValue="10") int limit) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("page", page);
        params.put("limit", limit);
        params.put("userId", Authentication.getAuthenticatedUserId());
        params.put("isWorkflow", 0);
        params.put("status", 1);
        return this.page(params);
    }

    @DeleteMapping(value={"cancel"})
    public Result cleanByProcessInstanceId(@RequestBody UndoOpt opt) {
        Long count = this.undoTaskService.cancel(opt);
        return Result.okMsg((String)("\u5171\u8ba1\u53d6\u6d88" + count + "\u6761\u4ee3\u529e\u8bb0\u5f55\uff01"));
    }

    @Operation(summary="\u6839\u636eID\u5220\u9664\u4ee3\u529e")
    @DeleteMapping(value={"{undoTaskId}"})
    public Result delete(@PathVariable(value="undoTaskId") String undoTaskId) {
        this.undoTaskService.removeById((Serializable)((Object)undoTaskId));
        return Result.ok();
    }

    @Operation(summary="\u6839\u636eID\u5b8c\u6210\u4ee3\u529e")
    @PostMapping(value={"{undoTaskId}/resolve"})
    public Result resolve(@PathVariable(value="undoTaskId") String undoTaskId) {
        this.undoTaskService.resolve(undoTaskId);
        return Result.ok();
    }

    @Operation(summary="\u6839\u636e\u53d1\u8d77\u4eba\u83b7\u53d6\u8be5\u53d1\u8d77\u4eba\u53d1\u8d77\u7684\u6d41\u7a0b\u5b9e\u4f8b\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/starterPage"})
    public Result<PageData<HmWorkflowInstances>> starterPage(@RequestBody RecordQuery query) {
        PageData results = this.hmWorkflowInstancesService.starterPage(query);
        return Result.okData((Object)results);
    }

    @Operation(summary="\u6839\u636e\u6267\u884c\u4eba\u83b7\u53d6\u8be5\u6267\u884c\u4eba\u5df2\u529e\u7ed3\u7684\u4efb\u52a1\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/assigneePage"})
    public Result<PageData<HmWorkflowTasks>> assigneePage(@RequestBody RecordQuery query) {
        PageData results = this.hmWorkflowTasksService.assigneePage(query);
        return Result.okData((Object)results);
    }

    @Operation(summary="\u67e5\u8be2\u6211\u7684\u4ee3\u529e-new")
    @PostMapping(value={"/undoTaskPage"})
    public Result<PageData<UndoTask>> undoTaskPage(@RequestBody UndoTaskQuery query) {
        PageData results = this.undoTaskService.undoTaskPage(query);
        return Result.okData((Object)results);
    }

    @Operation(summary="\u67e5\u8be2\u6211\u7684\u4ee3\u529e\u603b\u6570")
    @PostMapping(value={"/undoTaskUndoTaskVo"})
    public Result<UndoTaskVo> undoTaskUndoTaskVo(@RequestBody UndoTaskQuery query) {
        UndoTaskVo undoTaskVo = this.undoTaskService.undoTaskUndoTaskVo(query);
        return Result.okData((Object)undoTaskVo);
    }

    @Operation(summary="\u53d1\u9001\u5f85\u529e(\u4e1a\u52a1\u7aef\u76f4\u63a5\u53d1\u9001\u4ee3\u529e)")
    @PostMapping(value={"pushUndoTask"})
    public Result pushUndoTask(@RequestBody UndoTaskSendForm form) {
        ArrayList<UndoTask> entityList = new ArrayList<UndoTask>();
        if (!CollectionUtils.isEmpty((Collection)form.getReceiverIds())) {
            for (String userId : form.getReceiverIds()) {
                UndoTask task = (UndoTask)ConvertUtils.sourceToTarget((Object)form, UndoTask.class);
                task.setUserId(userId);
                task.setSendTime(new Date());
                task.setIsWorkflow(Integer.valueOf(0));
                task.setMsgStatus(Integer.valueOf(0));
                task.setUserType(Integer.valueOf(3));
                task.setStartUserId(form.getSenderId());
                task.setStartUserName(form.getSenderName());
                task.setStartTime(new Date());
                entityList.add(task);
            }
            this.undoTaskService.saveBatch(entityList);
        }
        return Result.ok();
    }

    @Operation(summary="\u4fee\u6539\u6d88\u606f\u72b6\u6001")
    @GetMapping(value={"/changeMsgStatusById"})
    public Result changeMsgStatusById(@RequestParam(value="id") String id) {
        this.undoTaskService.changeMsgStatusById(id);
        return Result.ok();
    }

    public UndoTaskController(UndoTaskService undoTaskService, IHmWorkflowInstancesService hmWorkflowInstancesService, IHmWorkflowTasksService hmWorkflowTasksService) {
        this.undoTaskService = undoTaskService;
        this.hmWorkflowInstancesService = hmWorkflowInstancesService;
        this.hmWorkflowTasksService = hmWorkflowTasksService;
    }
}

