/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.controller;

import cn.hutool.core.map.MapUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.njhm.workflow.dto.FlowCategory;
import com.njhm.workflow.entity.WorkflowCategory;
import com.njhm.workflow.exception.BizException;
import com.njhm.workflow.query.CategoryQuery;
import com.njhm.workflow.service.WorkflowCategoryService;
import com.njhm.workflow.utils.ConvertUtils;
import com.njhm.workflow.utils.PageData;
import com.njhm.workflow.utils.Result;
import com.njhm.workflow.utils.TreeUtils;
import com.njhm.workflow.utils.ValidatorUtils;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/category"})
@Tag(name="\u5206\u7c7b\u7ba1\u7406")
public class WorkflowCategoryController {
    private static final Logger log = LoggerFactory.getLogger(WorkflowCategoryController.class);
    @Autowired
    private WorkflowCategoryService workflowCategoryService;

    @Operation(summary="\u5206\u7c7b\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/listPage"})
    public Result<PageData<FlowCategory>> listPage(@RequestBody CategoryQuery query) {
        PageData results = this.workflowCategoryService.listPage(query);
        return Result.okData((Object)results);
    }

    @GetMapping(value={"/list"})
    @Operation(summary="\u5206\u7c7b\u5217\u8868")
    public Result<List<FlowCategory>> list(@RequestParam Map<String, Object> params) {
        log.info("\u5206\u7c7b\u5217\u8868\u67e5\u8be2");
        Integer status = MapUtil.getInt(params, (Object)"status");
        String categoryName = MapUtil.getStr(params, (Object)"categoryName");
        List list = this.workflowCategoryService.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(status != null, WorkflowCategory::getStatus, (Object)status)).like(StringUtils.hasLength((String)categoryName), WorkflowCategory::getCategoryName, (Object)categoryName)).orderByAsc(WorkflowCategory::getSort));
        return Result.okData((Object)TreeUtils.build((List)ConvertUtils.sourceToTarget((Collection)list, FlowCategory.class)));
    }

    @GetMapping(value={"{id}"})
    @Operation(summary="\u5206\u7c7b\u8be6\u60c5")
    public Result get(@PathVariable Long id) {
        return Result.okData((Object)this.workflowCategoryService.getById((Serializable)id));
    }

    @GetMapping(value={"/getInfoByCode"})
    @Operation(summary="\u6839\u636e\u5206\u7c7b\u7f16\u7801\u83b7\u53d6\u5206\u7c7b\u8be6\u60c5")
    public Result getInfoByCode(@RequestParam(value="categoryCode") String categoryCode) {
        FlowCategory result = this.workflowCategoryService.getInfoByCode(categoryCode);
        return Result.okData((Object)result);
    }

    @DeleteMapping(value={"{id}"})
    @Operation(summary="\u5220\u9664\u5206\u7c7b")
    public Result delete(@PathVariable Long id) {
        if (0L < this.workflowCategoryService.count((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WorkflowCategory::getParentId, (Object)id)).or(w -> ((LambdaQueryWrapper)w.eq(WorkflowCategory::getStatus, (Object)1)).eq(WorkflowCategory::getId, (Object)id)))) {
            throw new BizException("\u5220\u9664\u5931\u8d25\uff01\u8bf7\u5148\u7981\u7528\u5206\u7c7b\u6216\u5220\u9664\u5b50\u5206\u7c7b\u3002");
        }
        this.workflowCategoryService.removeById((Serializable)id);
        return Result.ok();
    }

    @PutMapping
    @Operation(summary="\u4fee\u6539\u5206\u7c7b")
    public Result update(@RequestBody FlowCategory dto) {
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        dto.setUpdateTime(new Date());
        this.workflowCategoryService.updateById((Object)((WorkflowCategory)ConvertUtils.sourceToTarget((Object)dto, WorkflowCategory.class)));
        return Result.ok();
    }

    @PostMapping
    @Operation(summary="\u4fdd\u5b58\u5206\u7c7b")
    public Result save(@RequestBody FlowCategory dto) {
        ValidatorUtils.validateEntity((Object)dto, (Class[])new Class[0]);
        if (0L < this.workflowCategoryService.count((Wrapper)new LambdaQueryWrapper().eq(WorkflowCategory::getCategoryCode, (Object)dto.getCategoryCode()))) {
            throw new BizException("\u6dfb\u52a0\u5931\u8d25\uff01\u5206\u7c7b\u7f16\u7801\u5df2\u5b58\u5728\u3002");
        }
        dto.setCreateTime(new Date());
        dto.setUpdateTime(new Date());
        WorkflowCategory entity = (WorkflowCategory)ConvertUtils.sourceToTarget((Object)dto, WorkflowCategory.class);
        entity.setUpdateTime(new Date());
        entity.setCreateTime(new Date());
        this.workflowCategoryService.save((Object)entity);
        return Result.ok();
    }

    @PostMapping(value={"{id}/enable"})
    @Operation(summary="\u542f\u7528\u5206\u7c7b")
    public Result enable(@PathVariable Long id) {
        this.workflowCategoryService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(WorkflowCategory::getId, (Object)id)).set(WorkflowCategory::getStatus, (Object)1));
        return Result.ok();
    }

    @PostMapping(value={"{id}/disable"})
    @Operation(summary="\u505c\u7528\u5206\u7c7b")
    public Result disable(@PathVariable Long id) {
        this.workflowCategoryService.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(WorkflowCategory::getId, (Object)id)).set(WorkflowCategory::getStatus, (Object)0));
        return Result.ok();
    }
}

