/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.njhm.workflow.dto.FlowCategory;
import com.njhm.workflow.dto.FlowComment;
import com.njhm.workflow.dto.FlowProcess;
import com.njhm.workflow.dto.FlowProcessInstance;
import com.njhm.workflow.dto.FlowTaskInfo;
import com.njhm.workflow.dto.comm.ProcessStartForm;
import com.njhm.workflow.enums.BusinessCommEnum;
import com.njhm.workflow.exception.BizException;
import com.njhm.workflow.mapper.ActReDeploymentMapper;
import com.njhm.workflow.query.InstanceParamQuery;
import com.njhm.workflow.security.SecurityUser;
import com.njhm.workflow.service.ProcessInstanceService;
import com.njhm.workflow.service.ProcessTaskService;
import com.njhm.workflow.service.WorkflowCategoryService;
import com.njhm.workflow.utils.CommUtils;
import com.njhm.workflow.utils.ConvertUtils;
import com.njhm.workflow.utils.PageData;
import com.njhm.workflow.utils.ValidatorUtils;
import com.njhm.workflow.vo.ActReDeploymentVO;
import com.njhm.workflow.vo.GatewayConditionVO;
import com.njhm.workflow.vo.HistoricActivityVO;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.FlowElement;
import org.flowable.bpmn.model.FlowNode;
import org.flowable.bpmn.model.Gateway;
import org.flowable.bpmn.model.Process;
import org.flowable.bpmn.model.SequenceFlow;
import org.flowable.bpmn.model.UserTask;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.engine.HistoryService;
import org.flowable.engine.ProcessEngine;
import org.flowable.engine.ProcessEngineConfiguration;
import org.flowable.engine.ProcessEngines;
import org.flowable.engine.RepositoryService;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.TaskService;
import org.flowable.engine.history.HistoricActivityInstance;
import org.flowable.engine.history.HistoricActivityInstanceQuery;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.history.HistoricProcessInstanceQuery;
import org.flowable.engine.repository.ProcessDefinition;
import org.flowable.engine.runtime.ProcessInstance;
import org.flowable.engine.runtime.ProcessInstanceBuilder;
import org.flowable.engine.runtime.ProcessInstanceQuery;
import org.flowable.engine.task.Comment;
import org.flowable.image.ProcessDiagramGenerator;
import org.flowable.task.api.Task;
import org.flowable.task.api.TaskQuery;
import org.flowable.task.api.history.HistoricTaskInstance;
import org.flowable.task.api.history.HistoricTaskInstanceQuery;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ProcessInstanceServiceImpl
implements ProcessInstanceService {
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RepositoryService repositoryService;
    @Autowired
    private ActReDeploymentMapper actReDeploymentMapper;
    @Autowired
    private WorkflowCategoryService workflowCategoryService;
    @Autowired
    private ProcessTaskService processTaskService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlowProcessInstance startProcessInstance(ProcessStartForm form) {
        FlowProcessInstance flowProcessInstance = null;
        ValidatorUtils.validateEntity((Object)form, (Class[])new Class[0]);
        String processDefinitionKey = form.getProcessDefinitionKey();
        String processInstanceName = form.getProcessInstanceName();
        String projectName = form.getProjectName();
        String businessKey = form.getBusinessKey();
        String formUrl = form.getFormUrl();
        HashMap<String, Object> variables = form.getVariables();
        if (CollectionUtils.isEmpty((Map)variables)) {
            variables = new HashMap<String, Object>();
        }
        String startUserId = SecurityUser.getUserId().toString();
        variables.put("businessKey", businessKey);
        variables.put("startUserId", startUserId);
        variables.put("startUserName", SecurityUser.getUsername());
        variables.put("fromUrl", formUrl);
        variables.put("fromUrlOrg", formUrl);
        variables.put("projectName", projectName);
        Map formData = form.getFormData();
        if (formData != null && formData.size() > 0) {
            variables.put("formData", formData);
        }
        ProcessInstanceServiceImpl processInstanceServiceImpl = this;
        synchronized (processInstanceServiceImpl) {
            Authentication.setAuthenticatedUserId((String)startUserId);
            ProcessInstanceBuilder processInstanceBuilder = this.runtimeService.createProcessInstanceBuilder().processDefinitionKey(processDefinitionKey).name(processInstanceName).businessKey(businessKey).variables(variables);
            ProcessInstance instance = processInstanceBuilder.start();
            Task task = (Task)((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processDefinitionKey(processDefinitionKey)).processInstanceBusinessKey(businessKey)).singleResult();
            String taskId = task.getId();
            HashMap<String, Object> localVariables = new HashMap<String, Object>();
            localVariables.put("approveStatus", BusinessCommEnum.TaskStatus.PP_1.getCode());
            localVariables.put("approveUserId", SecurityUser.getUserId());
            localVariables.put("approveUserName", SecurityUser.getUsername());
            this.taskService.setVariablesLocal(taskId, localVariables);
            this.taskService.complete(taskId);
            Authentication.setAuthenticatedUserId(null);
            flowProcessInstance = new FlowProcessInstance(instance);
            Map processVariables = instance.getProcessVariables();
            if (processVariables.size() > 0) {
                flowProcessInstance.setProcessVariables(processVariables);
            }
        }
        return flowProcessInstance;
    }

    public void run(String processInstanceId) {
        this.runtimeService.activateProcessInstanceById(processInstanceId);
    }

    public void suspend(String processInstanceId) {
        this.runtimeService.suspendProcessInstanceById(processInstanceId);
    }

    public PageData<FlowProcessInstance> instancePage(InstanceParamQuery query) {
        ArrayList<FlowProcessInstance> results = new ArrayList<FlowProcessInstance>();
        String category = query.getCategory();
        String processDefinitionKey = query.getProcessDefinitionKey();
        String processDefinitionName = query.getProcessDefinitionName();
        String processInstanceName = query.getProcessInstanceName();
        String businessKey = query.getBusinessKey();
        String startUserId = query.getStartUserId();
        ProcessInstanceQuery queryCondition = this.runtimeService.createProcessInstanceQuery();
        if (StringUtils.isNotEmpty((CharSequence)category)) {
            queryCondition.processDefinitionCategory(category);
        }
        if (StringUtils.isNotEmpty((CharSequence)processDefinitionName)) {
            queryCondition.processDefinitionName(processDefinitionName);
        }
        if (StringUtils.isNotEmpty((CharSequence)processDefinitionKey)) {
            queryCondition.processDefinitionKey(processDefinitionKey);
        }
        if (StringUtils.isNotEmpty((CharSequence)processInstanceName)) {
            queryCondition.processInstanceNameLike("%" + processInstanceName + "%");
        }
        if (StringUtils.isNotEmpty((CharSequence)businessKey)) {
            queryCondition.processInstanceBusinessKey(businessKey);
        }
        if (StringUtils.isNotEmpty((CharSequence)startUserId)) {
            queryCondition.startedBy(startUserId);
        }
        int total = queryCondition.list().size();
        int start = (query.getPage() - 1) * query.getLimit();
        List pageList = ((ProcessInstanceQuery)queryCondition.includeProcessVariables().orderByStartTime().desc()).listPage(start, query.getLimit().intValue());
        for (ProcessInstance instance : pageList) {
            FlowCategory entity;
            String categoryCode;
            List tasks;
            FlowProcessInstance info = new FlowProcessInstance(instance);
            Map processVariables = instance.getProcessVariables();
            if (processVariables.size() > 0) {
                info.setProcessVariables(processVariables);
            }
            if ((tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(instance.getProcessInstanceId())).list()).size() > 0) {
                Object taskName = "";
                Object assignee = "";
                for (Task t : tasks) {
                    taskName = (String)taskName + t.getName() + ",";
                    assignee = (String)assignee + t.getAssignee() + ",";
                }
                taskName = ((String)taskName).substring(0, ((String)taskName).length() - 1);
                assignee = ((String)assignee).substring(0, ((String)assignee).length() - 1);
                info.setCurrentTaskAlias((String)taskName);
                info.setAssignee((String)assignee);
            }
            if (StringUtils.isNotBlank((CharSequence)(categoryCode = info.getCategory())) && (entity = this.workflowCategoryService.getInfoByCode(categoryCode)) != null) {
                info.setCategoryName(entity.getCategoryName());
            }
            results.add(info);
        }
        PageData page = new PageData(results, (long)total);
        return page;
    }

    public PageData<FlowProcessInstance> instanceFinishedPage(InstanceParamQuery query) {
        ArrayList<FlowProcessInstance> results = new ArrayList<FlowProcessInstance>();
        String category = query.getCategory();
        String processDefinitionKey = query.getProcessDefinitionKey();
        String processDefinitionName = query.getProcessDefinitionName();
        String processInstanceName = query.getProcessInstanceName();
        String businessKey = query.getBusinessKey();
        String startUserId = query.getStartUserId();
        HistoricProcessInstanceQuery queryCondition = this.historyService.createHistoricProcessInstanceQuery();
        if (StringUtils.isNotEmpty((CharSequence)category)) {
            queryCondition.processDefinitionCategory(category);
        }
        if (StringUtils.isNotEmpty((CharSequence)processDefinitionKey)) {
            queryCondition.processDefinitionKey(processDefinitionKey);
        }
        if (StringUtils.isNotEmpty((CharSequence)processDefinitionName)) {
            queryCondition.processDefinitionName(processDefinitionName);
        }
        if (StringUtils.isNotEmpty((CharSequence)processInstanceName)) {
            queryCondition.processInstanceNameLike("%" + processInstanceName + "%");
        }
        if (StringUtils.isNotEmpty((CharSequence)businessKey)) {
            queryCondition.processInstanceBusinessKey(businessKey);
        }
        if (StringUtils.isNotEmpty((CharSequence)startUserId)) {
            queryCondition.startedBy(startUserId);
        }
        int total = queryCondition.finished().list().size();
        int start = (query.getPage() - 1) * query.getLimit();
        List pageList = ((HistoricProcessInstanceQuery)queryCondition.includeProcessVariables().orderByProcessInstanceEndTime().desc()).finished().listPage(start, query.getLimit().intValue());
        for (HistoricProcessInstance instance : pageList) {
            FlowCategory entity;
            String categoryCode;
            FlowProcessInstance info = new FlowProcessInstance(instance);
            Map processVariables = instance.getProcessVariables();
            if (processVariables.size() > 0) {
                info.setProcessVariables(processVariables);
            }
            if (StringUtils.isNotBlank((CharSequence)(categoryCode = info.getCategory())) && (entity = this.workflowCategoryService.getInfoByCode(categoryCode)) != null) {
                info.setCategoryName(entity.getCategoryName());
            }
            results.add(info);
        }
        PageData page = new PageData(results, (long)total);
        return page;
    }

    public FlowProcessInstance instanceInfoByKey(String processDefinitionKey, String businessKey) {
        FlowProcessInstance result = null;
        ProcessInstanceQuery queryCondition = this.runtimeService.createProcessInstanceQuery();
        queryCondition.processDefinitionKey(processDefinitionKey);
        queryCondition.processInstanceBusinessKey(businessKey);
        List instances = ((ProcessInstanceQuery)queryCondition.includeProcessVariables().orderByStartTime().desc()).list();
        if (!CollectionUtils.isEmpty((Collection)instances)) {
            ProcessInstance instance = (ProcessInstance)instances.get(0);
            result = new FlowProcessInstance(instance);
            Map processVariables = instance.getProcessVariables();
            if (processVariables.size() > 0) {
                result.setProcessVariables(processVariables);
            }
            List historyTaskList = this.getHistoryTaskList(result.getId(), true);
            result.setHistoryTaskList(historyTaskList);
        } else {
            HistoricProcessInstanceQuery queryHistoricCondition = this.historyService.createHistoricProcessInstanceQuery();
            queryHistoricCondition.processDefinitionKey(processDefinitionKey);
            queryHistoricCondition.processInstanceBusinessKey(businessKey);
            List historicProcessInstances = ((HistoricProcessInstanceQuery)queryHistoricCondition.includeProcessVariables().finished().orderByProcessInstanceStartTime().desc()).list();
            if (!CollectionUtils.isEmpty((Collection)historicProcessInstances)) {
                HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)historicProcessInstances.get(0);
                result = new FlowProcessInstance(historicProcessInstance);
                Map processVariables = historicProcessInstance.getProcessVariables();
                if (processVariables.size() > 0) {
                    result.setProcessVariables(processVariables);
                }
                List historyTaskList = this.getHistoryTaskList(result.getId(), true);
                result.setHistoryTaskList(historyTaskList);
            }
        }
        return result;
    }

    public List<FlowTaskInfo> getHistoryTaskList(String processInstanceId, boolean includeTaskVariables) {
        HistoricTaskInstanceQuery historicTaskInstanceQuery = (HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId);
        if (includeTaskVariables) {
            historicTaskInstanceQuery.includeTaskLocalVariables();
        }
        List historicTaskInstances = ((HistoricTaskInstanceQuery)historicTaskInstanceQuery.orderByHistoricTaskInstanceStartTime().asc()).list();
        Map<String, HistoricTaskInstance> collectMap = historicTaskInstances.stream().collect(Collectors.toMap(p -> p.getId(), p -> p));
        List flowTasks = ConvertUtils.sourceToTarget((Collection)historicTaskInstances, FlowTaskInfo.class);
        for (FlowTaskInfo flowTaskInfo : flowTasks) {
            flowTaskInfo.setTaskVariables(collectMap.get(flowTaskInfo.getId()).getTaskLocalVariables());
        }
        List commentList = this.taskService.getProcessInstanceComments(processInstanceId);
        if (CollectionUtil.isNotEmpty((Collection)commentList)) {
            Map<String, List<Comment>> commentMap = commentList.stream().collect(Collectors.groupingBy(Comment::getTaskId));
            flowTasks.parallelStream().forEach(task -> task.setComments(ConvertUtils.sourceToTarget((Collection)((Collection)commentMap.get(task.getId())), FlowComment.class)));
        }
        return flowTasks;
    }

    public FlowProcess getDefinitionsByInstanceId(String instanceId) {
        FlowCategory entity;
        List actReDeploymentVOS;
        ActReDeploymentVO actReDeploymentVO;
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(instanceId).singleResult();
        String deploymentId = processInstance.getDeploymentId();
        ProcessDefinition processDefinition = (ProcessDefinition)this.repositoryService.createProcessDefinitionQuery().deploymentId(deploymentId).singleResult();
        FlowProcess result = new FlowProcess(processDefinition, actReDeploymentVO = (actReDeploymentVOS = this.actReDeploymentMapper.selectActReDeploymentByIds(new HashSet<String>(Arrays.asList(deploymentId)))).parallelStream().filter(ard -> deploymentId.equals(ard.getId())).findAny().orElse(new ActReDeploymentVO()));
        String categoryCode = result.getCategory();
        if (StringUtils.isNotBlank((CharSequence)categoryCode) && (entity = this.workflowCategoryService.getInfoByCode(categoryCode)) != null) {
            result.setCategoryName(entity.getCategoryName());
        }
        return result;
    }

    public List<FlowTaskInfo> getTaskInfosByInstanceIds(List<String> instanceIds) {
        List<Object> results = new ArrayList<FlowTaskInfo>();
        if (instanceIds != null && !instanceIds.isEmpty()) {
            List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().includeTaskLocalVariables()).processInstanceIdIn(instanceIds)).list();
            results = tasks.stream().map(t -> {
                FlowCategory entity;
                ProcessInstance process = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().includeProcessVariables().processInstanceId(t.getProcessInstanceId()).singleResult();
                FlowTaskInfo result = new FlowTaskInfo(t, process);
                String categoryCode = result.getCategory();
                if (StringUtils.isNotBlank((CharSequence)categoryCode) && (entity = this.workflowCategoryService.getInfoByCode(categoryCode)) != null) {
                    result.setCategoryName(entity.getCategoryName());
                }
                Set taskCandidateUser = this.processTaskService.getTaskCandidate(t.getId(), Integer.valueOf(0));
                result.setCandidateUser(StringUtils.join((Iterable)taskCandidateUser, (String)","));
                Set taskCandidateGroup = this.processTaskService.getTaskCandidate(t.getId(), Integer.valueOf(1));
                result.setCandidateGroups(StringUtils.join((Iterable)taskCandidateGroup, (String)","));
                return result;
            }).collect(Collectors.toList());
        }
        return results;
    }

    public List<HistoricActivityVO> getHistoricActivity(String instanceId) {
        ArrayList results = new ArrayList();
        HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(instanceId).singleResult();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(historicProcessInstance.getProcessDefinitionId());
        Process process = (Process)bpmnModel.getProcesses().get(0);
        Collection flowElements = process.getFlowElements();
        List listFinished = this.historyService.createHistoricActivityInstanceQuery().processInstanceId(instanceId).finished().list();
        listFinished.forEach(s -> {
            for (FlowElement flowElement : flowElements) {
                UserTask userTask;
                if (!(flowElement instanceof UserTask) || !(userTask = (UserTask)flowElement).getId().equals(s.getActivityId())) continue;
                HistoricActivityVO vo = new HistoricActivityVO();
                vo.setId(s.getId());
                vo.setActivityId(s.getActivityId());
                vo.setActivityName(s.getActivityName());
                vo.setExecutionId(s.getExecutionId());
                results.add(vo);
            }
        });
        ArrayList collect = results.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<HistoricActivityVO>(Comparator.comparing(p -> p.getActivityId()))), ArrayList::new));
        return collect;
    }

    public Set<String> getGetewayCondition(String instanceId) {
        ArrayList<GatewayConditionVO> results = new ArrayList<GatewayConditionVO>();
        String processDefinitionId = ((ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(instanceId).singleResult()).getProcessDefinitionId();
        BpmnModel bpmnModel = this.repositoryService.getBpmnModel(processDefinitionId);
        Process process = (Process)bpmnModel.getProcesses().get(0);
        Collection flowElements = process.getFlowElements();
        for (FlowElement flowElement : flowElements) {
            if (!(flowElement instanceof Gateway)) continue;
            Gateway gateway = (Gateway)flowElement;
            List outgoingFlows = gateway.getOutgoingFlows();
            for (SequenceFlow outgoingFlow : outgoingFlows) {
                String id = outgoingFlow.getId();
                String conditionExpression = outgoingFlow.getConditionExpression();
                if (!StringUtils.isNotBlank((CharSequence)conditionExpression)) continue;
                GatewayConditionVO vo = new GatewayConditionVO();
                vo.setId(id);
                vo.setConditionExpression(conditionExpression);
                String conditionKey = CommUtils.evaluateConditionKey((String)conditionExpression);
                vo.setConditionKey(conditionKey);
                results.add(vo);
            }
        }
        return results.stream().map(t -> t.getConditionKey()).collect(Collectors.toSet());
    }

    public void generateFlowChart(String processInstanceId, OutputStream outputStream) {
        try {
            int len;
            if (StringUtils.isEmpty((CharSequence)processInstanceId)) {
                return;
            }
            HistoricProcessInstance historicProcessInstance = (HistoricProcessInstance)this.historyService.createHistoricProcessInstanceQuery().processInstanceId(processInstanceId).singleResult();
            List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().processInstanceId(processInstanceId).orderByHistoricActivityInstanceStartTime().asc()).list();
            ArrayList<String> highLightedActivitiIds = new ArrayList<String>();
            for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
                highLightedActivitiIds.add(historicActivityInstance.getActivityId());
            }
            ProcessEngine processEngine = ProcessEngines.getDefaultProcessEngine();
            ProcessEngineConfiguration processEngineConfig = processEngine.getProcessEngineConfiguration();
            ProcessDiagramGenerator processDiagramGenerator = processEngineConfig.getProcessDiagramGenerator();
            BpmnModel bpmnModel = this.repositoryService.getBpmnModel(historicProcessInstance.getProcessDefinitionId());
            List highLightedFlowIds = this.getHighLightedFlows(bpmnModel, historicActivityInstances);
            InputStream imageStream = processDiagramGenerator.generateDiagram(bpmnModel, "png", highLightedActivitiIds, highLightedFlowIds, "\u5b8b\u4f53", "\u5b8b\u4f53", "\u5b8b\u4f53", null, 1.0, false);
            byte[] b = new byte[1024];
            while ((len = imageStream.read(b, 0, 1024)) != -1) {
                outputStream.write(b, 0, len);
            }
        }
        catch (Exception e) {
            throw new BizException("processInstanceId" + processInstanceId + "\u751f\u6210\u6d41\u7a0b\u56fe\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage());
        }
    }

    private List<String> getHighLightedFlows(BpmnModel bpmnModel, List<HistoricActivityInstance> historicActivityInstances) {
        ArrayList<String> highLightedFlowIds = new ArrayList<String>();
        ArrayList<FlowNode> historicActivityNodesTemp = new ArrayList<FlowNode>();
        for (HistoricActivityInstance historicActivityInstance : historicActivityInstances) {
            FlowElement flowElement = bpmnModel.getMainProcess().getFlowElement(historicActivityInstance.getActivityId(), true);
            if (!(flowElement instanceof FlowNode)) continue;
            FlowNode flowNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(historicActivityInstance.getActivityId(), true);
            historicActivityNodesTemp.add(flowNode);
        }
        ArrayList historicActivityNodes = historicActivityNodesTemp.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<FlowNode>(Comparator.comparing(p -> p.getId()))), ArrayList::new));
        for (HistoricActivityInstance currentActivityInstance : historicActivityInstances) {
            FlowElement flowElement = bpmnModel.getMainProcess().getFlowElement(currentActivityInstance.getActivityId(), true);
            if (!(flowElement instanceof FlowNode)) continue;
            FlowNode currentFlowNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(currentActivityInstance.getActivityId(), true);
            List sequenceFlows = currentFlowNode.getOutgoingFlows();
            for (SequenceFlow sequenceFlow : sequenceFlows) {
                int current;
                int target;
                FlowNode targetFlowNode = (FlowNode)bpmnModel.getMainProcess().getFlowElement(sequenceFlow.getTargetRef(), true);
                if (!historicActivityNodes.contains(targetFlowNode) || (target = historicActivityNodes.indexOf(targetFlowNode)) - (current = historicActivityNodes.indexOf(currentFlowNode)) != 1) continue;
                highLightedFlowIds.add(sequenceFlow.getId());
            }
        }
        return highLightedFlowIds;
    }
}

