/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.service.impl;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.njhm.workflow.dto.FlowProcessInstance;
import com.njhm.workflow.dto.UndoOpt;
import com.njhm.workflow.entity.UndoTask;
import com.njhm.workflow.exception.BizException;
import com.njhm.workflow.mapper.UndoTaskMapper;
import com.njhm.workflow.query.UndoTaskQuery;
import com.njhm.workflow.security.SecurityUser;
import com.njhm.workflow.service.UndoTaskService;
import com.njhm.workflow.service.WorkflowService;
import com.njhm.workflow.utils.PageData;
import com.njhm.workflow.vo.UndoTaskVo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.flowable.common.engine.impl.identity.Authentication;
import org.flowable.engine.RuntimeService;
import org.flowable.engine.impl.persistence.entity.ExecutionEntityImpl;
import org.flowable.task.service.impl.persistence.entity.TaskEntityImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UndoTaskServiceImpl
extends ServiceImpl<UndoTaskMapper, UndoTask>
implements UndoTaskService {
    @Value(value="${workflow.targetUrl}")
    private String targetUrl;
    @Autowired
    private WorkflowService workflowService;
    @Autowired
    private RuntimeService runtimeService;

    public void send(ExecutionEntityImpl processInstance) {
        UndoTask undo = new UndoTask();
        Map variables = processInstance.getVariables();
        String businessKey = MapUtil.getStr((Map)variables, (Object)"businessKey", (String)processInstance.getBusinessKey());
        undo.setStartUserId(MapUtil.getStr((Map)variables, (Object)"startUserId"));
        undo.setStartUserName(MapUtil.getStr((Map)variables, (Object)"startUserName"));
        undo.setProjectName(MapUtil.getStr((Map)variables, (Object)"projectName"));
        undo.setBusinessKey(businessKey);
        undo.setSenderName(SecurityUser.getUsername());
        undo.setSenderId("" + SecurityUser.getUserId());
        undo.setSendTime(new Date());
        undo.setUserId("" + SecurityUser.getUserId());
        undo.setName(processInstance.getProcessDefinitionName());
        undo.setStartTime(processInstance.getStartTime());
        undo.setProcessInstanceId(processInstance.getProcessInstanceId());
        undo.setIsWorkflow(Integer.valueOf(1));
        Object formUrl = MapUtil.getStr((Map)variables, (Object)"fromUrlOrg", (String)"");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processInstId", processInstance.getProcessInstanceId());
        String paramStr = HttpUtil.toParams(params);
        formUrl = StrUtil.indexOf((CharSequence)formUrl, (char)'?') >= 0 ? (String)formUrl + "&" + paramStr : (String)formUrl + "?" + paramStr;
        Object targetUrlTemp = "";
        targetUrlTemp = StrUtil.indexOf((CharSequence)this.targetUrl, (char)'?') >= 0 ? this.targetUrl + "&" + paramStr : this.targetUrl + "?" + paramStr;
        this.runtimeService.setVariable(processInstance.getId(), "fromUrl", formUrl);
        undo.setTargetUrl((String)targetUrlTemp);
        this.save((Object)undo);
    }

    public void sendCcToUser(ExecutionEntityImpl processInstance, String ccToUser) {
        UndoTask undo = new UndoTask();
        Map variables = processInstance.getVariables();
        String businessKey = MapUtil.getStr((Map)variables, (Object)"businessKey", (String)processInstance.getBusinessKey());
        undo.setStartUserId(MapUtil.getStr((Map)variables, (Object)"startUserId"));
        undo.setStartUserName(MapUtil.getStr((Map)variables, (Object)"startUserName"));
        undo.setProjectName(MapUtil.getStr((Map)variables, (Object)"projectName"));
        undo.setBusinessKey(businessKey);
        undo.setSenderName(SecurityUser.getUsername());
        undo.setSenderId("" + SecurityUser.getUserId());
        undo.setSendTime(new Date());
        undo.setUserId(ccToUser);
        undo.setName(processInstance.getProcessDefinitionName());
        undo.setStartTime(processInstance.getStartTime());
        undo.setProcessInstanceId(processInstance.getProcessInstanceId());
        undo.setIsWorkflow(Integer.valueOf(1));
        undo.setMsgStatus(Integer.valueOf(0));
        undo.setUserType(Integer.valueOf(2));
        Object formUrl = MapUtil.getStr((Map)variables, (Object)"fromUrlOrg", (String)"");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processInstId", processInstance.getProcessInstanceId());
        String paramStr = HttpUtil.toParams(params);
        formUrl = StrUtil.indexOf((CharSequence)formUrl, (char)'?') >= 0 ? (String)formUrl + "&" + paramStr : (String)formUrl + "?" + paramStr;
        Object targetUrlTemp = "";
        targetUrlTemp = StrUtil.indexOf((CharSequence)this.targetUrl, (char)'?') >= 0 ? this.targetUrl + "&" + paramStr : this.targetUrl + "?" + paramStr;
        this.runtimeService.setVariable(processInstance.getId(), "fromUrl", formUrl);
        undo.setTargetUrl((String)targetUrlTemp);
        this.save((Object)undo);
    }

    public void cancelAll(String processInstanceId, String reason) {
        this.remove((Wrapper)new LambdaUpdateWrapper().eq(UndoTask::getProcessInstanceId, (Object)processInstanceId));
    }

    public void resolveByProcessInstanceId(String processInstId) {
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UndoTask::getProcessInstanceId, (Object)processInstId)).set(UndoTask::getEndTime, (Object)new Date())).set(UndoTask::getStatus, (Object)1));
    }

    public void send(String toUserId, TaskEntityImpl task, Integer userType) {
        UndoTask undo = new UndoTask();
        FlowProcessInstance processInstance = this.workflowService.getProcessInstanceById(task.getProcessInstanceId(), true);
        Map variables = processInstance.getProcessVariables();
        String businessKey = MapUtil.getStr((Map)variables, (Object)"businessKey", (String)processInstance.getBusinessKey());
        undo.setStartUserId(MapUtil.getStr((Map)variables, (Object)"startUserId"));
        undo.setStartUserName(MapUtil.getStr((Map)variables, (Object)"startUserName"));
        undo.setProjectName(MapUtil.getStr((Map)variables, (Object)"projectName"));
        undo.setBusinessKey(businessKey);
        undo.setSenderId("" + SecurityUser.getUserId());
        undo.setSenderName(SecurityUser.getUsername());
        undo.setSendTime(new Date());
        undo.setUserId(toUserId);
        undo.setUserType(userType);
        undo.setTaskId(task.getId());
        undo.setTaskName(task.getName());
        undo.setName(processInstance.getName());
        undo.setStartTime(processInstance.getStartTime());
        undo.setStatus(Integer.valueOf(0));
        undo.setIsWorkflow(Integer.valueOf(0));
        undo.setProcessInstanceId(processInstance.getId());
        Object formUrl = MapUtil.getStr((Map)variables, (Object)"fromUrlOrg", (String)"");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processInstId", processInstance.getId());
        params.put("taskKey", task.getTaskDefinitionKey());
        params.put("taskId", task.getId());
        String paramStr = HttpUtil.toParams(params);
        formUrl = StrUtil.indexOf((CharSequence)formUrl, (char)'?') >= 0 ? (String)formUrl + "&" + paramStr : (String)formUrl + "?" + paramStr;
        Object targetUrlTemp = "";
        targetUrlTemp = StrUtil.indexOf((CharSequence)this.targetUrl, (char)'?') >= 0 ? this.targetUrl + "&" + paramStr : this.targetUrl + "?" + paramStr;
        this.runtimeService.setVariable(processInstance.getId(), "fromUrl", formUrl);
        undo.setTargetUrl((String)targetUrlTemp);
        this.save((Object)undo);
    }

    public void sendCcToUser(String ccToUser, TaskEntityImpl task) {
        UndoTask undo = new UndoTask();
        FlowProcessInstance processInstance = this.workflowService.getProcessInstanceById(task.getProcessInstanceId(), true);
        Map variables = processInstance.getProcessVariables();
        String businessKey = MapUtil.getStr((Map)variables, (Object)"businessKey", (String)processInstance.getBusinessKey());
        undo.setStartUserId(MapUtil.getStr((Map)variables, (Object)"startUserId"));
        undo.setStartUserName(MapUtil.getStr((Map)variables, (Object)"startUserName"));
        undo.setProjectName(MapUtil.getStr((Map)variables, (Object)"projectName"));
        undo.setBusinessKey(businessKey);
        undo.setSenderId("" + SecurityUser.getUserId());
        undo.setSenderName(SecurityUser.getUsername());
        undo.setSendTime(new Date());
        undo.setUserId(ccToUser);
        undo.setTaskId(task.getId());
        undo.setTaskName(task.getName());
        undo.setName(processInstance.getName());
        undo.setStartTime(processInstance.getStartTime());
        undo.setIsWorkflow(Integer.valueOf(0));
        undo.setMsgStatus(Integer.valueOf(0));
        undo.setUserType(Integer.valueOf(2));
        undo.setProcessInstanceId(processInstance.getId());
        Object formUrl = MapUtil.getStr((Map)variables, (Object)"fromUrlOrg", (String)"");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("processInstId", processInstance.getId());
        String paramStr = HttpUtil.toParams(params);
        formUrl = StrUtil.indexOf((CharSequence)formUrl, (char)'?') >= 0 ? (String)formUrl + "&" + paramStr : (String)formUrl + "?" + paramStr;
        Object targetUrlTemp = "";
        targetUrlTemp = StrUtil.indexOf((CharSequence)this.targetUrl, (char)'?') >= 0 ? this.targetUrl + "&" + paramStr : this.targetUrl + "?" + paramStr;
        this.runtimeService.setVariable(processInstance.getId(), "fromUrl", formUrl);
        undo.setTargetUrl((String)targetUrlTemp);
        this.save((Object)undo);
    }

    public void resolveByTaskId(String taskId) {
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UndoTask::getTaskId, (Object)taskId)).set(UndoTask::getEndTime, (Object)new Date())).set(UndoTask::getStatus, (Object)1));
    }

    public void changeAssignByTaskId(String taskId, String assignee) {
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UndoTask::getTaskId, (Object)taskId)).set(UndoTask::getUserId, (Object)assignee));
    }

    public void changeMsgStatusById(String id) {
        this.update((Wrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UndoTask::getId, (Object)id)).set(UndoTask::getMsgStatus, (Object)1));
    }

    public PageData<UndoTask> undoTaskPage(UndoTaskQuery query) {
        String name = query.getName();
        String projectName = query.getProjectName();
        String startUserName = query.getStartUserName();
        String senderName = query.getSenderName();
        Integer status = query.getStatus();
        Integer msgStatus = query.getMsgStatus();
        String startTime = query.getStartTime();
        String sendTime = query.getSendTime();
        Integer dataType = query.getDataType();
        QueryWrapper wrapper = new QueryWrapper();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)name)) {
            wrapper.like((Object)"name", (Object)name);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)projectName)) {
            wrapper.like((Object)"project_name", (Object)projectName);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)startUserName)) {
            wrapper.like((Object)"start_user_name", (Object)startUserName);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)senderName)) {
            wrapper.like((Object)"sender_name", (Object)senderName);
        }
        if (status != null) {
            wrapper.eq((Object)"status", (Object)status);
        }
        if (msgStatus != null) {
            wrapper.eq((Object)"msg_status", (Object)msgStatus);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)startTime)) {
            wrapper.apply("date_format(start_time,'%Y-%m-%d') = date_format('" + startTime + "','%Y-%m-%d')", new Object[0]);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sendTime)) {
            wrapper.apply("date_format(send_time,'%Y-%m-%d') = date_format('" + sendTime + "','%Y-%m-%d')", new Object[0]);
        }
        if (dataType != null && dataType == 0) {
            wrapper.in((Object)"user_type", Arrays.asList(0, 1));
        }
        if (dataType != null && dataType == 1) {
            wrapper.notIn((Object)"user_type", Arrays.asList(0, 1));
        }
        wrapper.eq((Object)"user_id", (Object)Authentication.getAuthenticatedUserId());
        wrapper.eq((Object)"is_workflow", (Object)0);
        wrapper.orderByDesc((Object)"send_time");
        Page results = (Page)((UndoTaskMapper)this.baseMapper).selectPage((IPage)new Page(query.getPage().longValue(), query.getLimit().longValue()), (Wrapper)wrapper);
        PageData page = new PageData(results.getRecords(), results.getTotal());
        return page;
    }

    public UndoTaskVo undoTaskUndoTaskVo(UndoTaskQuery query) {
        UndoTaskVo undoTaskVo = new UndoTaskVo();
        String name = query.getName();
        String projectName = query.getProjectName();
        String startUserName = query.getStartUserName();
        String senderName = query.getSenderName();
        String startTime = query.getStartTime();
        String sendTime = query.getSendTime();
        QueryWrapper wrapper = new QueryWrapper();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)name)) {
            wrapper.like((Object)"name", (Object)name);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)projectName)) {
            wrapper.like((Object)"project_name", (Object)projectName);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)startUserName)) {
            wrapper.like((Object)"start_user_name", (Object)startUserName);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)senderName)) {
            wrapper.like((Object)"sender_name", (Object)senderName);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)startTime)) {
            wrapper.apply("date_format(start_time,'%Y-%m-%d') = date_format('" + startTime + "','%Y-%m-%d')", new Object[0]);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sendTime)) {
            wrapper.apply("date_format(send_time,'%Y-%m-%d') = date_format('" + sendTime + "','%Y-%m-%d')", new Object[0]);
        }
        wrapper.eq((Object)"user_id", (Object)Authentication.getAuthenticatedUserId());
        wrapper.eq((Object)"is_workflow", (Object)0);
        wrapper.orderByDesc((Object)"send_time");
        undoTaskVo.setTotalMessages(this.totalMessages(wrapper));
        QueryWrapper wrappers = new QueryWrapper();
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)name)) {
            wrappers.like((Object)"name", (Object)name);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)projectName)) {
            wrappers.like((Object)"project_name", (Object)projectName);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)startUserName)) {
            wrappers.like((Object)"start_user_name", (Object)startUserName);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)senderName)) {
            wrappers.like((Object)"sender_name", (Object)senderName);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)startTime)) {
            wrappers.apply("date_format(start_time,'%Y-%m-%d') = date_format('" + startTime + "','%Y-%m-%d')", new Object[0]);
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)sendTime)) {
            wrappers.apply("date_format(send_time,'%Y-%m-%d') = date_format('" + sendTime + "','%Y-%m-%d')", new Object[0]);
        }
        wrappers.eq((Object)"user_id", (Object)Authentication.getAuthenticatedUserId());
        wrappers.eq((Object)"is_workflow", (Object)0);
        wrappers.orderByDesc((Object)"send_time");
        undoTaskVo.setTotalNumber(this.totalNumber(wrappers));
        return undoTaskVo;
    }

    public Long totalMessages(QueryWrapper<UndoTask> wrapper) {
        wrapper.eq((Object)"msg_status", (Object)0);
        wrapper.notIn((Object)"user_type", Arrays.asList(0, 1));
        Long l = ((UndoTaskMapper)this.baseMapper).selectCount(wrapper);
        return l;
    }

    public Long totalNumber(QueryWrapper<UndoTask> wrapper) {
        wrapper.in((Object)"user_type", Arrays.asList(0, 1));
        wrapper.eq((Object)"status", (Object)0);
        Long l = ((UndoTaskMapper)this.baseMapper).selectCount(wrapper);
        return l;
    }

    public Long cancel(UndoOpt opt) {
        if (StrUtil.isAllBlank((CharSequence[])new CharSequence[]{opt.getProcessInstanceId(), opt.getTaskId()})) {
            throw new BizException("\u53d6\u6d88\u4ee3\u529e\u5931\u8d25\uff01\u6d41\u7a0b\u5b9e\u4f8bID\u548c\u4efb\u52a1ID\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002");
        }
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(StringUtils.hasLength((String)opt.getProcessInstanceId()), UndoTask::getProcessInstanceId, (Object)opt.getProcessInstanceId())).eq(StringUtils.hasLength((String)opt.getTaskId()), UndoTask::getTaskId, (Object)opt.getTaskId())).in(!CollectionUtils.isEmpty((Collection)opt.getUserIds()), UndoTask::getUserId, (Collection)opt.getUserIds());
        long count = ((UndoTaskMapper)this.baseMapper).selectCount((Wrapper)queryWrapper);
        if (count > 0L) {
            this.remove((Wrapper)queryWrapper);
        }
        return count;
    }

    public void resolve(String undoTaskId) {
        this.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(UndoTask::getId, (Object)undoTaskId)).eq(UndoTask::getStatus, (Object)0)).eq(UndoTask::getUserId, (Object)("" + SecurityUser.getUserId()))).set(UndoTask::getEndTime, (Object)new Date())).set(UndoTask::getStatus, (Object)1));
    }
}

