/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.dto;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.njhm.workflow.dto.FlowTaskInfo;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.flowable.engine.history.HistoricProcessInstance;
import org.flowable.engine.runtime.ProcessInstance;

@Schema(description="FlowProcessInstance\u6d41\u7a0b\u5b9e\u4f8b\u4fe1\u606f")
public class FlowProcessInstance {
    @Schema(description="\u6d41\u7a0b\u5206\u7c7b\u7f16\u7801")
    private String category;
    @Schema(description="\u6d41\u7a0b\u5206\u7c7b\u540d\u79f0")
    private String categoryName;
    @Schema(description="\u6d41\u7a0b\u5b9a\u4e49Id")
    private String processDefinitionId;
    @Schema(description="\u6d41\u7a0b\u5b9a\u4e49\u540d\u79f0")
    private String processDefinitionName;
    @Schema(description="\u6d41\u7a0b\u5b9a\u4e49KEY")
    private String processDefinitionKey;
    @Schema(description="\u6d41\u7a0b\u5b9a\u4e49\u7248\u672c")
    private Integer processDefinitionVersion;
    @Schema(description="\u6d41\u7a0b\u5b9e\u4f8bID")
    private String id;
    @JsonProperty(value="processInstanceName")
    @Schema(description="\u6d41\u7a0b\u5b9e\u4f8b\u540d\u79f0")
    private String name;
    @Schema(description="\u4e1a\u52a1\u4e3b\u952e", $comment="\u6d41\u7a0b\u542f\u52a8\u65f6\u4f20\u5165\u7684\u4e1a\u52a1\u4e3b\u952e")
    private String businessKey;
    @Schema(description="\u6d41\u7a0b\u5b9e\u4f8b\u5f00\u542f\u65f6\u95f4")
    private Date startTime;
    @Schema(description="\u6d41\u7a0b\u5b9e\u4f8b\u7ed3\u675f\u65f6\u95f4")
    private Date endTime;
    @Schema(description="\u6d41\u7a0b\u5b9e\u4f8b\u53d1\u8d77\u4eba")
    private String startUserId;
    @Schema(description="\u662f\u5426\u6302\u8d77", $comment="true: \u6d41\u7a0b\u5df2\u6302\u8d77\u65e0\u6cd5\u8fdb\u884c\u5ba1\u6279 false: \u6d41\u7a0b\u672a\u6302\u8d77\uff0c\u53ef\u8fdb\u884c\u5ba1\u6279\u64cd\u4f5c")
    private Boolean suspended;
    @Schema(description="\u662f\u5426\u5df2\u7ed3\u675f", $comment="true: \u6d41\u7a0b\u5ba1\u6279\u7ed3\u675f false: \u6d41\u7a0b\u8fdb\u884c\u4e2d\uff0c\u53ef\u8fdb\u884c\u5ba1\u6279\u64cd\u4f5c")
    private Boolean ended;
    @Schema(description="\u6d41\u7a0b\u5b9e\u4f8b\u53d8\u91cf")
    private Map<String, Object> processVariables;
    @Schema(description="\u67e5\u770b\u5f53\u524d\u6d3b\u52a8\u4efb\u52a1")
    private String currentTaskAlias;
    @Schema(description="\u67e5\u770b\u5f53\u524d\u6d3b\u52a8\u4efb\u52a1")
    private String assignee;
    @Schema(description="\u6d41\u7a0b\u5b9e\u4f8b\u63cf\u8ff0")
    private String description;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Schema(description="\u6d41\u7a0b\u5b9e\u4f8b\u4efb\u52a1\u5217\u8868", $comment="\u6570\u636e\u6309\u7167\u4efb\u52a1\u521b\u5efa\u65f6\u95f4\u5012\u53d9")
    private List<FlowTaskInfo> historyTaskList;
    @Schema(description="FlowTaskInfo")
    private FlowTaskInfo currentTask;
    @Schema(description="\u6d41\u7a0b\u542f\u52a8\u8005\u540d\u79f0")
    private String startUserName;
    @Schema(description="\u4e1a\u52a1\u5ba1\u6279\u7ed3\u679c", $comment="\u6d41\u7a0b\u5ba1\u6279\u7ed3\u675f\u65f6\u7684\u4e1a\u52a1\u72b6\u6001")
    private String businessStatus;

    public FlowProcessInstance() {
    }

    public FlowProcessInstance(ProcessInstance instance) {
        this.category = instance.getProcessDefinitionCategory();
        this.processDefinitionId = instance.getProcessDefinitionId();
        this.processDefinitionKey = instance.getProcessDefinitionKey();
        this.processDefinitionName = instance.getProcessDefinitionName();
        this.processDefinitionVersion = instance.getProcessDefinitionVersion();
        this.id = instance.getProcessInstanceId();
        this.name = instance.getName();
        this.businessKey = instance.getBusinessKey();
        this.startTime = instance.getStartTime();
        this.endTime = null;
        this.startUserId = instance.getStartUserId();
        this.suspended = instance.isSuspended();
        this.ended = instance.isEnded();
        this.description = instance.getDescription();
    }

    public FlowProcessInstance(HistoricProcessInstance instance) {
        this.category = instance.getProcessDefinitionCategory();
        this.processDefinitionId = instance.getProcessDefinitionId();
        this.processDefinitionKey = instance.getProcessDefinitionKey();
        this.processDefinitionName = instance.getProcessDefinitionName();
        this.processDefinitionVersion = instance.getProcessDefinitionVersion();
        this.id = instance.getId();
        this.name = instance.getName();
        this.businessKey = instance.getBusinessKey();
        this.startTime = instance.getStartTime();
        this.endTime = instance.getEndTime();
        this.startUserId = instance.getStartUserId();
        this.suspended = null;
        this.ended = true;
        this.description = instance.getDescription();
    }

    public String getCategory() {
        return this.category;
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getProcessDefinitionId() {
        return this.processDefinitionId;
    }

    public String getProcessDefinitionName() {
        return this.processDefinitionName;
    }

    public String getProcessDefinitionKey() {
        return this.processDefinitionKey;
    }

    public Integer getProcessDefinitionVersion() {
        return this.processDefinitionVersion;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getBusinessKey() {
        return this.businessKey;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public String getStartUserId() {
        return this.startUserId;
    }

    public Boolean getSuspended() {
        return this.suspended;
    }

    public Boolean getEnded() {
        return this.ended;
    }

    public Map<String, Object> getProcessVariables() {
        return this.processVariables;
    }

    public String getCurrentTaskAlias() {
        return this.currentTaskAlias;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public String getDescription() {
        return this.description;
    }

    public List<FlowTaskInfo> getHistoryTaskList() {
        return this.historyTaskList;
    }

    public FlowTaskInfo getCurrentTask() {
        return this.currentTask;
    }

    public String getStartUserName() {
        return this.startUserName;
    }

    public String getBusinessStatus() {
        return this.businessStatus;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public void setProcessDefinitionId(String processDefinitionId) {
        this.processDefinitionId = processDefinitionId;
    }

    public void setProcessDefinitionName(String processDefinitionName) {
        this.processDefinitionName = processDefinitionName;
    }

    public void setProcessDefinitionKey(String processDefinitionKey) {
        this.processDefinitionKey = processDefinitionKey;
    }

    public void setProcessDefinitionVersion(Integer processDefinitionVersion) {
        this.processDefinitionVersion = processDefinitionVersion;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="processInstanceName")
    public void setName(String name) {
        this.name = name;
    }

    public void setBusinessKey(String businessKey) {
        this.businessKey = businessKey;
    }

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public void setStartUserId(String startUserId) {
        this.startUserId = startUserId;
    }

    public void setSuspended(Boolean suspended) {
        this.suspended = suspended;
    }

    public void setEnded(Boolean ended) {
        this.ended = ended;
    }

    public void setProcessVariables(Map<String, Object> processVariables) {
        this.processVariables = processVariables;
    }

    public void setCurrentTaskAlias(String currentTaskAlias) {
        this.currentTaskAlias = currentTaskAlias;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHistoryTaskList(List<FlowTaskInfo> historyTaskList) {
        this.historyTaskList = historyTaskList;
    }

    public void setCurrentTask(FlowTaskInfo currentTask) {
        this.currentTask = currentTask;
    }

    public void setStartUserName(String startUserName) {
        this.startUserName = startUserName;
    }

    public void setBusinessStatus(String businessStatus) {
        this.businessStatus = businessStatus;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FlowProcessInstance)) {
            return false;
        }
        FlowProcessInstance other = (FlowProcessInstance)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Integer this$processDefinitionVersion = this.getProcessDefinitionVersion();
        Integer other$processDefinitionVersion = other.getProcessDefinitionVersion();
        if (this$processDefinitionVersion == null ? other$processDefinitionVersion != null : !((Object)this$processDefinitionVersion).equals(other$processDefinitionVersion)) {
            return false;
        }
        Boolean this$suspended = this.getSuspended();
        Boolean other$suspended = other.getSuspended();
        if (this$suspended == null ? other$suspended != null : !((Object)this$suspended).equals(other$suspended)) {
            return false;
        }
        Boolean this$ended = this.getEnded();
        Boolean other$ended = other.getEnded();
        if (this$ended == null ? other$ended != null : !((Object)this$ended).equals(other$ended)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        if (this$category == null ? other$category != null : !this$category.equals(other$category)) {
            return false;
        }
        String this$categoryName = this.getCategoryName();
        String other$categoryName = other.getCategoryName();
        if (this$categoryName == null ? other$categoryName != null : !this$categoryName.equals(other$categoryName)) {
            return false;
        }
        String this$processDefinitionId = this.getProcessDefinitionId();
        String other$processDefinitionId = other.getProcessDefinitionId();
        if (this$processDefinitionId == null ? other$processDefinitionId != null : !this$processDefinitionId.equals(other$processDefinitionId)) {
            return false;
        }
        String this$processDefinitionName = this.getProcessDefinitionName();
        String other$processDefinitionName = other.getProcessDefinitionName();
        if (this$processDefinitionName == null ? other$processDefinitionName != null : !this$processDefinitionName.equals(other$processDefinitionName)) {
            return false;
        }
        String this$processDefinitionKey = this.getProcessDefinitionKey();
        String other$processDefinitionKey = other.getProcessDefinitionKey();
        if (this$processDefinitionKey == null ? other$processDefinitionKey != null : !this$processDefinitionKey.equals(other$processDefinitionKey)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$businessKey = this.getBusinessKey();
        String other$businessKey = other.getBusinessKey();
        if (this$businessKey == null ? other$businessKey != null : !this$businessKey.equals(other$businessKey)) {
            return false;
        }
        Date this$startTime = this.getStartTime();
        Date other$startTime = other.getStartTime();
        if (this$startTime == null ? other$startTime != null : !((Object)this$startTime).equals(other$startTime)) {
            return false;
        }
        Date this$endTime = this.getEndTime();
        Date other$endTime = other.getEndTime();
        if (this$endTime == null ? other$endTime != null : !((Object)this$endTime).equals(other$endTime)) {
            return false;
        }
        String this$startUserId = this.getStartUserId();
        String other$startUserId = other.getStartUserId();
        if (this$startUserId == null ? other$startUserId != null : !this$startUserId.equals(other$startUserId)) {
            return false;
        }
        Map this$processVariables = this.getProcessVariables();
        Map other$processVariables = other.getProcessVariables();
        if (this$processVariables == null ? other$processVariables != null : !((Object)this$processVariables).equals(other$processVariables)) {
            return false;
        }
        String this$currentTaskAlias = this.getCurrentTaskAlias();
        String other$currentTaskAlias = other.getCurrentTaskAlias();
        if (this$currentTaskAlias == null ? other$currentTaskAlias != null : !this$currentTaskAlias.equals(other$currentTaskAlias)) {
            return false;
        }
        String this$assignee = this.getAssignee();
        String other$assignee = other.getAssignee();
        if (this$assignee == null ? other$assignee != null : !this$assignee.equals(other$assignee)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        List this$historyTaskList = this.getHistoryTaskList();
        List other$historyTaskList = other.getHistoryTaskList();
        if (this$historyTaskList == null ? other$historyTaskList != null : !((Object)this$historyTaskList).equals(other$historyTaskList)) {
            return false;
        }
        FlowTaskInfo this$currentTask = this.getCurrentTask();
        FlowTaskInfo other$currentTask = other.getCurrentTask();
        if (this$currentTask == null ? other$currentTask != null : !this$currentTask.equals(other$currentTask)) {
            return false;
        }
        String this$startUserName = this.getStartUserName();
        String other$startUserName = other.getStartUserName();
        if (this$startUserName == null ? other$startUserName != null : !this$startUserName.equals(other$startUserName)) {
            return false;
        }
        String this$businessStatus = this.getBusinessStatus();
        String other$businessStatus = other.getBusinessStatus();
        return !(this$businessStatus == null ? other$businessStatus != null : !this$businessStatus.equals(other$businessStatus));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FlowProcessInstance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $processDefinitionVersion = this.getProcessDefinitionVersion();
        result = result * 59 + ($processDefinitionVersion == null ? 43 : ((Object)$processDefinitionVersion).hashCode());
        Boolean $suspended = this.getSuspended();
        result = result * 59 + ($suspended == null ? 43 : ((Object)$suspended).hashCode());
        Boolean $ended = this.getEnded();
        result = result * 59 + ($ended == null ? 43 : ((Object)$ended).hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        String $categoryName = this.getCategoryName();
        result = result * 59 + ($categoryName == null ? 43 : $categoryName.hashCode());
        String $processDefinitionId = this.getProcessDefinitionId();
        result = result * 59 + ($processDefinitionId == null ? 43 : $processDefinitionId.hashCode());
        String $processDefinitionName = this.getProcessDefinitionName();
        result = result * 59 + ($processDefinitionName == null ? 43 : $processDefinitionName.hashCode());
        String $processDefinitionKey = this.getProcessDefinitionKey();
        result = result * 59 + ($processDefinitionKey == null ? 43 : $processDefinitionKey.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $businessKey = this.getBusinessKey();
        result = result * 59 + ($businessKey == null ? 43 : $businessKey.hashCode());
        Date $startTime = this.getStartTime();
        result = result * 59 + ($startTime == null ? 43 : ((Object)$startTime).hashCode());
        Date $endTime = this.getEndTime();
        result = result * 59 + ($endTime == null ? 43 : ((Object)$endTime).hashCode());
        String $startUserId = this.getStartUserId();
        result = result * 59 + ($startUserId == null ? 43 : $startUserId.hashCode());
        Map $processVariables = this.getProcessVariables();
        result = result * 59 + ($processVariables == null ? 43 : ((Object)$processVariables).hashCode());
        String $currentTaskAlias = this.getCurrentTaskAlias();
        result = result * 59 + ($currentTaskAlias == null ? 43 : $currentTaskAlias.hashCode());
        String $assignee = this.getAssignee();
        result = result * 59 + ($assignee == null ? 43 : $assignee.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        List $historyTaskList = this.getHistoryTaskList();
        result = result * 59 + ($historyTaskList == null ? 43 : ((Object)$historyTaskList).hashCode());
        FlowTaskInfo $currentTask = this.getCurrentTask();
        result = result * 59 + ($currentTask == null ? 43 : $currentTask.hashCode());
        String $startUserName = this.getStartUserName();
        result = result * 59 + ($startUserName == null ? 43 : $startUserName.hashCode());
        String $businessStatus = this.getBusinessStatus();
        result = result * 59 + ($businessStatus == null ? 43 : $businessStatus.hashCode());
        return result;
    }

    public String toString() {
        return "FlowProcessInstance(category=" + this.getCategory() + ", categoryName=" + this.getCategoryName() + ", processDefinitionId=" + this.getProcessDefinitionId() + ", processDefinitionName=" + this.getProcessDefinitionName() + ", processDefinitionKey=" + this.getProcessDefinitionKey() + ", processDefinitionVersion=" + this.getProcessDefinitionVersion() + ", id=" + this.getId() + ", name=" + this.getName() + ", businessKey=" + this.getBusinessKey() + ", startTime=" + this.getStartTime() + ", endTime=" + this.getEndTime() + ", startUserId=" + this.getStartUserId() + ", suspended=" + this.getSuspended() + ", ended=" + this.getEnded() + ", processVariables=" + this.getProcessVariables() + ", currentTaskAlias=" + this.getCurrentTaskAlias() + ", assignee=" + this.getAssignee() + ", description=" + this.getDescription() + ", historyTaskList=" + this.getHistoryTaskList() + ", currentTask=" + this.getCurrentTask() + ", startUserName=" + this.getStartUserName() + ", businessStatus=" + this.getBusinessStatus() + ")";
    }
}

