/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.exception;

import com.njhm.workflow.exception.BizException;
import com.njhm.workflow.utils.Result;
import org.flowable.common.engine.api.FlowableObjectNotFoundException;
import org.flowable.common.engine.api.FlowableOptimisticLockingException;
import org.flowable.common.engine.api.FlowableTaskAlreadyClaimedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;

@RestControllerAdvice
public class WorkflowExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(WorkflowExceptionHandler.class);

    @ExceptionHandler(value={FlowableOptimisticLockingException.class})
    public Result handleFlowableOptimisticLockingException(FlowableOptimisticLockingException ex) {
        return Result.error((int)1002);
    }

    @ExceptionHandler(value={FlowableTaskAlreadyClaimedException.class})
    public Result handleFlowableTaskAlreadyClaimedException(FlowableTaskAlreadyClaimedException ex) {
        return Result.error((int)500, (String)String.format("\u4efb\u52a1[%s]\u5df2\u88ab\u8ba4\u9886\uff01", ex.getTaskId()));
    }

    @ExceptionHandler(value={FlowableObjectNotFoundException.class})
    public Result handleFlowableObjectNotFoundException(FlowableObjectNotFoundException ex) {
        return Result.error((int)500, (String)ex.getLocalizedMessage());
    }

    @ExceptionHandler(value={BizException.class})
    public Result handleRenException(BizException ex) {
        return Result.error((int)ex.getCode(), (String)ex.getMsg());
    }

    @ExceptionHandler(value={DuplicateKeyException.class})
    public Result handleDuplicateKeyException(DuplicateKeyException ex) {
        return Result.error((int)1001, (String)ex.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public Result handleException(Exception ex) {
        log.error(ex.getMessage(), (Throwable)ex);
        return Result.error((String)ex.getMessage());
    }
}

