/*
 * Decompiled with CFR 0.152.
 */
package com.njhm.workflow.security;

import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.njhm.workflow.security.Oauth2Token;
import com.njhm.workflow.utils.HttpContextUtils;
import com.njhm.workflow.utils.Result;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.authc.AuthenticatingFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMethod;

public class Oauth2Filter
extends AuthenticatingFilter {
    private static final Logger log = LoggerFactory.getLogger(Oauth2Filter.class);
    private static final String TOKEN_HEADER = "token";

    public boolean preHandle(ServletRequest request, ServletResponse response) throws Exception {
        return super.preHandle(request, response);
    }

    protected AuthenticationToken createToken(ServletRequest request, ServletResponse response) throws Exception {
        String token = this.getRequestToken((HttpServletRequest)request);
        if (StrUtil.isBlank((CharSequence)token)) {
            return null;
        }
        return new Oauth2Token(token);
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) {
        return ((HttpServletRequest)request).getMethod().equals(RequestMethod.OPTIONS.name());
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws Exception {
        String token = this.getRequestToken((HttpServletRequest)request);
        if (StrUtil.isBlank((CharSequence)token)) {
            HttpServletResponse httpResponse = (HttpServletResponse)response;
            httpResponse.setContentType("application/json;charset=utf-8");
            httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
            httpResponse.setHeader("Access-Control-Allow-Origin", HttpContextUtils.getOrigin());
            new Result();
            String json = JSONUtil.toJsonStr((Object)Result.error((int)401));
            httpResponse.getWriter().print(json);
            return false;
        }
        return this.executeLogin(request, response);
    }

    protected boolean onLoginFailure(AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        httpResponse.setContentType("application/json;charset=utf-8");
        httpResponse.setHeader("Access-Control-Allow-Credentials", "true");
        httpResponse.setHeader("Access-Control-Allow-Origin", HttpContextUtils.getOrigin());
        try {
            Object throwable = e.getCause() == null ? e : e.getCause();
            new Result();
            Result r = Result.error((int)401, (String)((Throwable)throwable).getMessage());
            String json = JSONUtil.toJsonStr((Object)r);
            httpResponse.getWriter().print(json);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    private String getRequestToken(HttpServletRequest httpRequest) {
        String token = httpRequest.getHeader(TOKEN_HEADER);
        if (StrUtil.isBlank((CharSequence)token)) {
            token = httpRequest.getParameter(TOKEN_HEADER);
        }
        if (StrUtil.isBlank((CharSequence)token)) {
            token = httpRequest.getHeader("authorization");
            token = StrUtil.subAfter((CharSequence)token, (CharSequence)"Bearer ", (boolean)false);
        }
        log.info("token:{}", (Object)token);
        return token;
    }
}

